/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.psi.manipulator;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sh.ShFileType;
import com.intellij.sh.psi.ShFunctionDefinition;
import com.intellij.sh.psi.ShLiteral;
import org.jetbrains.annotations.NotNull;

public final class ShElementGenerator {
    @NotNull
    public static ShLiteral createLiteral(@NotNull Project project, @NotNull String command) {
        PsiFile file = ShElementGenerator.createTempFile(project, command);
        ShLiteral literal = (ShLiteral)PsiTreeUtil.findChildOfType((PsiElement)file, ShLiteral.class);
        assert (literal != null);
        return literal;
    }

    @NotNull
    public static PsiElement createFunctionIdentifier(@NotNull Project project, @NotNull String functionName) {
        PsiFile file = ShElementGenerator.createTempFile(project, functionName + "() {  }");
        ShFunctionDefinition functionDefinition = (ShFunctionDefinition)PsiTreeUtil.findChildOfType((PsiElement)file, ShFunctionDefinition.class);
        assert (functionDefinition != null);
        PsiElement word = functionDefinition.getWord();
        assert (word != null);
        return word;
    }

    @NotNull
    private static PsiFile createTempFile(@NotNull Project project, @NotNull String contents) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("dummy_file." + ShFileType.INSTANCE.getDefaultExtension(), (FileType)ShFileType.INSTANCE, (CharSequence)contents);
    }
}

