/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.sh.ShTypes;
import com.intellij.sh.psi.ShFunctionDefinition;
import com.intellij.sh.psi.impl.ShCommandImpl;
import com.intellij.sh.psi.manipulator.ShElementGenerator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ShFunctionDefinitionMixin
extends ShCommandImpl
implements ShFunctionDefinition {
    ShFunctionDefinitionMixin(ASTNode node) {
        super(node);
    }

    public String getName() {
        PsiElement word = this.getWord();
        if (word != null) {
            return word.getText();
        }
        return null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        ASTNode functionNode = this.getNode();
        ASTNode identifierNode = functionNode.findChildByType(ShTypes.WORD);
        assert (identifierNode != null) : "Function identifier can't be empty";
        PsiElement newFunctionIdentifier = ShElementGenerator.createFunctionIdentifier(this.getProject(), name);
        functionNode.replaceChild(identifierNode, newFunctionIdentifier.getNode());
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getWord();
    }

    public int getTextOffset() {
        PsiElement word = this.getWord();
        return word != null ? word.getTextOffset() : super.getTextOffset();
    }
}

