/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.parser;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sh.ShTypes;
import com.intellij.sh.psi.ShFile;
import com.intellij.util.PathUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShShebangParserUtil {
    @NonNls
    private static final List<String> KNOWN_EXTENSIONS = Arrays.asList("exe", "bat", "cmd");
    private static final String PREFIX = "#!";

    private ShShebangParserUtil() {
    }

    @Nullable
    public static String getShebangExecutable(@NotNull ShFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && virtualFile.exists()) {
            ASTNode shebang = file.getNode().findChildByType(ShTypes.SHEBANG);
            String prefix = PREFIX;
            if (shebang != null && shebang.getText().startsWith(prefix)) {
                return shebang.getText().substring(prefix.length()).trim();
            }
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public static String getInterpreter(@NotNull ShFile file, @NotNull List<@NlsSafe String> knownShells, @NlsSafe @NotNull String defaultShell) {
        String shebang = ApplicationManager.getApplication().isDispatchThread() ? file.findShebang() : (String)ReadAction.compute(() -> file.findShebang());
        String detectedInterpreter = shebang != null ? ShShebangParserUtil.detectInterpreter(shebang) : null;
        return detectedInterpreter != null && knownShells.contains(detectedInterpreter) ? detectedInterpreter : defaultShell;
    }

    @Nullable
    public static String detectInterpreter(@Nullable String shebang) {
        if (shebang == null || !shebang.startsWith(PREFIX)) {
            return null;
        }
        String interpreterPath = ShShebangParserUtil.getInterpreterPath(shebang.substring(PREFIX.length()).trim());
        String lowerCasePath = SystemInfo.isFileSystemCaseSensitive ? interpreterPath.toLowerCase(Locale.ENGLISH) : interpreterPath;
        return ShShebangParserUtil.trimKnownExt(PathUtil.getFileName((String)lowerCasePath));
    }

    @NotNull
    private static String getInterpreterPath(@NotNull String shebang) {
        String possiblePath;
        int index = shebang.indexOf(" ");
        String string = possiblePath = index < 0 ? shebang : shebang.substring(0, index);
        if (!possiblePath.equals("/usr/bin/env")) {
            return possiblePath;
        }
        String interpreterPath = shebang.substring(index + 1);
        return (index = interpreterPath.indexOf(" ")) < 0 ? interpreterPath : interpreterPath.substring(0, index);
    }

    @NotNull
    private static String trimKnownExt(@NotNull String name) {
        String ext = PathUtil.getFileExtension((String)name);
        return ext != null && KNOWN_EXTENSIONS.contains(ext) ? name.substring(0, name.length() - ext.length() - 1) : name;
    }
}

