/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.highlighting;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.text.StringSearcher;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShTextOccurrencesUtil {
    private ShTextOccurrencesUtil() {
    }

    @Nullable
    public static TextRange findTextRangeOfIdentifierAtCaret(@NotNull Editor editor) {
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        if (caret.hasSelection()) {
            TextRange textRange = TextRange.create((int)caret.getSelectionStart(), (int)caret.getSelectionEnd());
            CharSequence subSequence = textRange.subSequence(editor.getDocument().getCharsSequence());
            return StringUtil.isEmptyOrSpaces((CharSequence)subSequence) || StringUtil.contains((CharSequence)subSequence, (CharSequence)"\n") ? null : textRange;
        }
        return SelectWordUtil.getWordSelectionRange((CharSequence)editor.getDocument().getImmutableCharSequence(), (int)caret.getOffset(), ShTextOccurrencesUtil::isWordPartCondition);
    }

    private static boolean isWordPartCondition(char ch) {
        return ch == '_' || Character.isLetterOrDigit(ch);
    }

    @NotNull
    public static Collection<TextRange> findAllOccurrences(@NotNull CharSequence documentText, @NotNull CharSequence textToFind, boolean matchExactWordsOnly) {
        CollectConsumer consumer = new CollectConsumer();
        ShTextOccurrencesUtil.consumeAllOccurrences(documentText, textToFind, matchExactWordsOnly, (Consumer<? super TextRange>)consumer);
        return consumer.getResult();
    }

    public static void consumeAllOccurrences(@NotNull CharSequence documentText, @NotNull CharSequence textToFind, boolean matchExactWordsOnly, Consumer<? super TextRange> consumer) {
        String pattern = textToFind.toString();
        int length = pattern.length();
        StringSearcher searcher = new StringSearcher(pattern, true, true);
        searcher.processOccurrences(documentText, value -> {
            TextRange tr = TextRange.create((int)value, (int)(value + length));
            if (matchExactWordsOnly && ShTextOccurrencesUtil.isWordExpandableOutside(documentText, (Segment)tr)) {
                return true;
            }
            consumer.consume((Object)tr);
            return true;
        });
    }

    private static boolean isWordExpandableOutside(@NotNull CharSequence documentText, @NotNull Segment textRange) {
        char ch;
        if (textRange.getStartOffset() > 0 && ShTextOccurrencesUtil.isWordPartCondition(ch = documentText.charAt(textRange.getStartOffset() - 1))) {
            return true;
        }
        if (textRange.getEndOffset() < documentText.length()) {
            ch = documentText.charAt(textRange.getEndOffset());
            return ShTextOccurrencesUtil.isWordPartCondition(ch);
        }
        return false;
    }
}

