/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

final class ShSemanticEditorPosition {
    private final HighlighterIterator myIterator;

    private ShSemanticEditorPosition(@NotNull Editor editor, int offset) {
        this.myIterator = editor.getHighlighter().createIterator(offset);
    }

    void moveBefore() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
    }

    void moveBeforeOptionalMix(IElementType ... elements) {
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
    }

    void moveAfterOptionalMix(IElementType ... elements) {
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
    }

    boolean isAtAnyOf(IElementType ... syntaxElements) {
        if (!this.myIterator.atEnd()) {
            IElementType currElement = this.myIterator.getTokenType();
            for (IElementType element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAt(@NotNull IElementType elementType) {
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    int getStartOffset() {
        return !this.myIterator.atEnd() ? this.myIterator.getStart() : -1;
    }

    @NotNull
    static ShSemanticEditorPosition createEditorPosition(@NotNull Editor editor, int offset) {
        return new ShSemanticEditorPosition(editor, offset);
    }
}

