/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sh.ShTypes;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.sh.psi.ShBlock;
import com.intellij.sh.psi.ShDoBlock;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.psi.ShHeredoc;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShFoldingBuilder
extends CustomFoldingBuilder {
    private static final String DOT_DOT_DOT = "...";
    private static final String BRACE_DOTS = "{...}";
    @NlsSafe
    private static final String DO_DOTS_DONE = "do...done";

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (!(root instanceof ShFile)) {
            return;
        }
        Collection psiElements = PsiTreeUtil.findChildrenOfAnyType((PsiElement)root, (Class[])new Class[]{ShBlock.class, ShDoBlock.class, ShHeredoc.class, PsiComment.class});
        ShFoldingBuilder.foldHeredoc(descriptors, psiElements, document);
        ShFoldingBuilder.foldComment(descriptors, psiElements, document);
        ShFoldingBuilder.foldBlock(descriptors, psiElements);
    }

    private static void foldHeredoc(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements, @NotNull Document document) {
        psiElements.forEach(element -> {
            if (element instanceof ShHeredoc) {
                PsiElement heredocContent = ((ShHeredoc)element).getHeredocContent();
                if (heredocContent == null) {
                    return;
                }
                TextRange textRange = heredocContent.getTextRange();
                int lineNumber = document.getLineNumber(textRange.getEndOffset());
                int endOffset = document.getLineEndOffset(lineNumber - 1);
                if (textRange.getStartOffset() >= endOffset) {
                    return;
                }
                descriptors.add(new FoldingDescriptor(element.getNode(), TextRange.create((int)textRange.getStartOffset(), (int)endOffset), null, ShFoldingBuilder.getHeredocPlaceholder(heredocContent, document)));
            }
        });
    }

    private static void foldComment(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements, @NotNull Document document) {
        HashSet handledComments = new HashSet();
        psiElements.forEach(element -> {
            if (element instanceof PsiComment && ((PsiComment)element).getTokenType() != ShTypes.SHEBANG && !handledComments.contains(element)) {
                PsiElement nextSibling;
                IElementType elementType;
                PsiElement lastComment = element;
                PsiElement currentElement = element;
                handledComments.add(element);
                while (currentElement.getNextSibling() != null && ((elementType = (nextSibling = currentElement.getNextSibling()).getNode().getElementType()) == ShTypes.LINEFEED || elementType == ShTokenTypes.WHITESPACE || nextSibling instanceof PsiComment)) {
                    if (nextSibling instanceof PsiComment) {
                        handledComments.add(nextSibling);
                        lastComment = nextSibling;
                    }
                    currentElement = nextSibling;
                }
                if (element == lastComment) {
                    return;
                }
                int startOffset = element.getTextRange().getStartOffset();
                int endOffset = lastComment.getTextRange().getEndOffset();
                descriptors.add(new FoldingDescriptor((ASTNode)element.getContainingFile().getNode(), TextRange.create((int)startOffset, (int)endOffset), null, ShFoldingBuilder.getCommentPlaceholder(element, document)));
            }
        });
    }

    private static void foldBlock(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements) {
        psiElements.forEach(element -> {
            if (element instanceof ShBlock || element instanceof ShDoBlock) {
                descriptors.add(new FoldingDescriptor(element, element.getTextRange()));
            }
        });
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType elementType = node.getElementType();
        if (elementType == ShTypes.BLOCK) {
            return BRACE_DOTS;
        }
        if (elementType == ShTypes.DO_BLOCK) {
            return DO_DOTS_DONE;
        }
        return DOT_DOT_DOT;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }

    private static String getHeredocPlaceholder(@NotNull PsiElement heredocContent, @NotNull Document document) {
        TextRange textRange = heredocContent.getTextRange();
        int lineNumber = document.getLineNumber(textRange.getStartOffset());
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        return document.getText(TextRange.create((int)startOffset, (int)endOffset)).trim() + DOT_DOT_DOT;
    }

    private static String getCommentPlaceholder(@NotNull PsiElement comment, @NotNull Document document) {
        TextRange textRange = comment.getTextRange();
        return document.getText(TextRange.create((int)(textRange.getStartOffset() + 1), (int)textRange.getEndOffset())).trim() + DOT_DOT_DOT;
    }
}

