/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.codeStyle;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.codeStyle.ShCodeStylePanel;
import com.intellij.sh.codeStyle.ShCodeStyleSettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, final @NotNull CodeStyleSettings modelSettings) {
        return new CodeStyleAbstractConfigurable(settings, modelSettings, this.getLanguage().getID()){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                return new ShCodeStylePanel(settings, modelSettings);
            }
        };
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INDENT_SIZE", "USE_TAB_CHARACTER", "TAB_SIZE"});
        }
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        return "";
    }

    @NotNull
    public Language getLanguage() {
        return ShLanguage.INSTANCE;
    }

    @NonNls
    @NotNull
    public String getExternalLanguageId() {
        return "shell";
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        return new ShCodeStyleSettings(settings);
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
    }
}

