/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sh.ShTypes;
import com.intellij.sh.highlighter.ShHighlighterColors;
import com.intellij.sh.psi.ShAssignmentCommand;
import com.intellij.sh.psi.ShFunctionDefinition;
import com.intellij.sh.psi.ShGenericCommandDirective;
import com.intellij.sh.psi.ShLiteral;
import com.intellij.sh.psi.ShShellParameterExpansion;
import com.intellij.sh.psi.ShSimpleCommandElement;
import com.intellij.sh.psi.ShSubshellCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShAnnotator
implements Annotator {
    ShAnnotator() {
    }

    public void annotate(@NotNull PsiElement o, @NotNull AnnotationHolder holder) {
        IElementType elementType;
        if (o instanceof ShGenericCommandDirective) {
            ShAnnotator.mark(o, holder, ShHighlighterColors.GENERIC_COMMAND);
        } else if (o instanceof ShAssignmentCommand) {
            ShLiteral literal = ((ShAssignmentCommand)o).getLiteral();
            ShAnnotator.mark(literal, holder, ShHighlighterColors.VARIABLE_DECLARATION);
        } else if (o instanceof ShShellParameterExpansion) {
            ASTNode[] children;
            for (ASTNode node : children = o.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{ShTypes.PARAM_SEPARATOR}))) {
                ShAnnotator.mark(node.getPsi(), holder, ShHighlighterColors.COMPOSED_VARIABLE);
            }
        } else if (o instanceof ShSubshellCommand) {
            ShSubshellCommand subshellCommand = (ShSubshellCommand)o;
            ShAnnotator.mark(subshellCommand.getLeftParen(), holder, ShHighlighterColors.SUBSHELL_COMMAND);
            ShAnnotator.mark(subshellCommand.getRightParen(), holder, ShHighlighterColors.SUBSHELL_COMMAND);
        }
        ASTNode node = o.getNode();
        IElementType iElementType = elementType = node == null ? null : node.getElementType();
        if (elementType == ShTypes.WORD) {
            PsiElement parent = o.getParent();
            if (parent instanceof ShSimpleCommandElement) {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
            }
            if (parent instanceof ShFunctionDefinition) {
                ShAnnotator.mark(o, holder, ShHighlighterColors.FUNCTION_DECLARATION);
            }
        }
    }

    private static void mark(@Nullable PsiElement o, @NotNull AnnotationHolder holder, @NotNull TextAttributesKey key) {
        if (o != null) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(o).textAttributes(key).create();
        }
    }
}

