/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import org.jetbrains.annotations.NotNull;

public class AndroidNativeLibData {
    private final String myPath;
    private final String myArchitecture;
    private final String myTargetFileName;

    public AndroidNativeLibData(@NotNull String architecture, @NotNull String path, @NotNull String targetFileName) {
        this.myPath = path;
        this.myArchitecture = architecture;
        this.myTargetFileName = targetFileName;
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @NotNull
    public String getArchitecture() {
        return this.myArchitecture;
    }

    @NotNull
    public String getTargetFileName() {
        return this.myTargetFileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidNativeLibData lib = (AndroidNativeLibData)o;
        if (!this.myArchitecture.equals(lib.myArchitecture)) {
            return false;
        }
        if (!this.myTargetFileName.equals(lib.myTargetFileName)) {
            return false;
        }
        return this.myPath.equals(lib.myPath);
    }

    public String toString() {
        return "[" + this.myPath + "," + this.myArchitecture + "," + this.myTargetFileName + "]";
    }

    public int hashCode() {
        int result = this.myPath.hashCode();
        result = 31 * result + this.myArchitecture.hashCode();
        result = 31 * result + this.myTargetFileName.hashCode();
        return result;
    }
}

