/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.FileComparisonData;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComparisonFailureData {
    private static final String ASSERTION_CLASS_NAME = "java.lang.AssertionError";
    private static final String ASSERTION_FAILED_CLASS_NAME = "junit.framework.AssertionFailedError";
    public static final String OPENTEST4J_ASSERTION = "org.opentest4j.AssertionFailedError";
    private static final List<String> COMPARISON_FAILURES = Arrays.asList("org.junit.ComparisonFailure", "org.junit.ComparisonFailure");
    private final String myExpected;
    private final String myActual;
    private final String myFilePath;
    private final String myActualFilePath;
    private static final Map<Class<?>, Field> EXPECTED = new HashMap();
    private static final Map<Class<?>, Field> ACTUAL = new HashMap();

    private static void init(String exceptionClassName) throws NoSuchFieldException, ClassNotFoundException {
        Class<?> exceptionClass = Class.forName(exceptionClassName, false, ComparisonFailureData.class.getClassLoader());
        Field expectedField = exceptionClass.getDeclaredField("fExpected");
        expectedField.setAccessible(true);
        EXPECTED.put(exceptionClass, expectedField);
        Field actualField = exceptionClass.getDeclaredField("fActual");
        actualField.setAccessible(true);
        ACTUAL.put(exceptionClass, actualField);
    }

    public ComparisonFailureData(String expected, String actual) {
        this(expected, actual, null);
    }

    public ComparisonFailureData(String expected, String actual, String filePath) {
        this(expected, actual, filePath, null);
    }

    public ComparisonFailureData(String expected, String actual, String filePath, String actualFilePath) {
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = filePath != null ? new File(filePath).getAbsolutePath() : null;
        this.myActualFilePath = actualFilePath != null ? new File(actualFilePath).getAbsolutePath() : null;
    }

    public static void registerSMAttributes(ComparisonFailureData notification, String trace, String failureMessage, Map attrs, Throwable throwable) {
        ComparisonFailureData.registerSMAttributes(notification, trace, failureMessage, attrs, throwable, "Comparison Failure: ", "expected:<");
    }

    public static void registerSMAttributes(ComparisonFailureData notification, String trace, String failureMessage, Map attrs, Throwable throwable, String comparisonFailurePrefix, String expectedPrefix) {
        String details;
        int failureIdx = failureMessage != null ? trace.indexOf(failureMessage) : -1;
        int failureMessageLength = failureMessage != null ? failureMessage.length() : 0;
        String string = details = failureIdx > -1 ? trace.substring(failureIdx + failureMessageLength) : trace;
        if (notification != null) {
            int expectedIdx = trace.indexOf(expectedPrefix);
            String comparisonFailureMessage = expectedIdx > 0 ? trace.substring(0, expectedIdx) : (failureIdx > -1 ? trace.substring(0, failureIdx + failureMessageLength) : (failureMessageLength > 0 ? failureMessage + "\n" : "") + comparisonFailurePrefix);
            if (!attrs.containsKey("message")) {
                attrs.put("message", comparisonFailureMessage);
            }
            String filePath = notification.getFilePath();
            String actualFilePath = notification.getActualFilePath();
            String expected = notification.getExpected();
            String actual = notification.getActual();
            int fullLength = (filePath == null && expected != null ? expected.length() : 0) + (actualFilePath == null && actual != null ? actual.length() : 0) + details.length() + comparisonFailureMessage.length() + 100;
            if (filePath != null) {
                attrs.put("expectedFile", filePath);
            } else {
                ComparisonFailureData.writeDiffSide(attrs, "expected", expected, fullLength);
            }
            if (actualFilePath != null) {
                attrs.put("actualFile", actualFilePath);
            } else {
                ComparisonFailureData.writeDiffSide(attrs, "actual", actual, fullLength);
            }
        } else {
            Throwable throwableCause = null;
            try {
                throwableCause = throwable.getCause();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            if (!ComparisonFailureData.isAssertionError(throwable.getClass()) && !ComparisonFailureData.isAssertionError(throwableCause != null ? throwableCause.getClass() : null)) {
                attrs.put("error", "true");
            }
            attrs.put("message", failureIdx > -1 ? trace.substring(0, failureIdx + failureMessageLength) : (failureMessage != null ? failureMessage : ""));
        }
        attrs.put("details", details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDiffSide(Map attrs, String expectedOrActualPrefix, String text, int fullLength) {
        int threshold;
        String property = System.getProperty("idea.test.cyclic.buffer.size");
        try {
            threshold = Integer.parseInt(property);
        }
        catch (NumberFormatException ignored) {
            threshold = -1;
        }
        if (threshold > 0 && fullLength > threshold) {
            try {
                File tempFile = File.createTempFile(expectedOrActualPrefix, "");
                try (FileOutputStream stream = new FileOutputStream(tempFile);){
                    ((OutputStream)stream).write(text.getBytes(StandardCharsets.UTF_8), 0, text.length());
                }
                attrs.put(expectedOrActualPrefix + "File", tempFile.getAbsolutePath());
                attrs.put(expectedOrActualPrefix + "IsTempFile", "true");
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        attrs.put(expectedOrActualPrefix, text);
    }

    public static boolean isAssertionError(Class throwableClass) {
        if (throwableClass == null) {
            return false;
        }
        String throwableClassName = throwableClass.getName();
        if (throwableClassName.equals(ASSERTION_CLASS_NAME) || throwableClassName.equals(ASSERTION_FAILED_CLASS_NAME) || throwableClassName.equals(OPENTEST4J_ASSERTION)) {
            return true;
        }
        return ComparisonFailureData.isAssertionError(throwableClass.getSuperclass());
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    public String getExpected() {
        return this.myExpected;
    }

    public String getActual() {
        return this.myActual;
    }

    public static ComparisonFailureData create(Throwable assertion) {
        ComparisonFailureData commonAssertion;
        String expected;
        String actual;
        FileComparisonData comparisonFailure;
        if (assertion instanceof FileComparisonData) {
            comparisonFailure = (FileComparisonData)((Object)assertion);
            actual = comparisonFailure.getActualStringPresentation();
            expected = comparisonFailure.getExpectedStringPresentation();
            if (actual != null && expected != null) {
                return new ComparisonFailureData(expected, actual, comparisonFailure.getFilePath(), comparisonFailure.getActualFilePath());
            }
        }
        if (assertion instanceof FileComparisonFailure) {
            comparisonFailure = (FileComparisonFailure)((Object)assertion);
            actual = ((FileComparisonFailure)comparisonFailure).getActual();
            expected = ((FileComparisonFailure)comparisonFailure).getExpected();
            if (actual != null && expected != null) {
                return new ComparisonFailureData(expected, actual, ((FileComparisonFailure)comparisonFailure).getFilePath(), ((FileComparisonFailure)comparisonFailure).getActualFilePath());
            }
        }
        if ((commonAssertion = ComparisonFailureData.createCommonAssertion(assertion)) != null) {
            return commonAssertion;
        }
        try {
            return new ComparisonFailureData(ComparisonFailureData.getExpected(assertion), ComparisonFailureData.getActual(assertion));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static ComparisonFailureData createCommonAssertion(Throwable assertion) {
        try {
            Class<?> assertionClass = assertion.getClass();
            if (!assertionClass.getName().equals(OPENTEST4J_ASSERTION)) break block4;
            Class[] parameterTypes = new Class[]{};
            Object[] args = new Object[]{};
            if (!((Boolean)assertionClass.getDeclaredMethod("isExpectedDefined", parameterTypes).invoke((Object)assertion, args)).booleanValue()) break block5;
            if (((Boolean)assertionClass.getDeclaredMethod("isActualDefined", parameterTypes).invoke((Object)assertion, args)).booleanValue()) {
                Object expected = assertionClass.getDeclaredMethod("getExpected", parameterTypes).invoke((Object)assertion, args);
                Object expectedString = expected.getClass().getDeclaredMethod("getStringRepresentation", parameterTypes).invoke(expected, args);
                Object actual = assertionClass.getDeclaredMethod("getActual", parameterTypes).invoke((Object)assertion, args);
                Object actualString = actual.getClass().getDeclaredMethod("getStringRepresentation", parameterTypes).invoke(actual, args);
                return new ComparisonFailureData((String)expectedString, (String)actualString);
            }
        }
        finally {
            return null;
        }
        {
            block4: {
                block5: {
                }
            }
        }
    }

    public static String getActual(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, ACTUAL, "fActual");
    }

    public static String getExpected(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, EXPECTED, "fExpected");
    }

    private static String get(Throwable assertion, Map<Class<?>, Field> staticMap, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Class<?> assertionClass = assertion.getClass();
        for (Class<?> comparisonClass : staticMap.keySet()) {
            if (!comparisonClass.isAssignableFrom(assertionClass)) continue;
            return (String)staticMap.get(comparisonClass).get(assertion);
        }
        Field field = assertionClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (String)field.get(assertion);
    }

    static {
        try {
            for (String failure : COMPARISON_FAILURES) {
                ComparisonFailureData.init(failure);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

