/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.studioclient;

import com.appspot.cluestick_server.search.model.Result;
import com.google.devrel.cluestick.searchservice.CluestickSearch;
import com.google.devrel.cluestick.searchservice.EventLog;
import com.google.devrel.cluestick.studioclient.Browser;
import com.google.devrel.cluestick.studioclient.CodeBrowser;
import com.google.devrel.cluestick.studioclient.SearchResultsNode;
import com.google.devrel.cluestick.studioclient.SearchResultsTree;
import com.google.devrel.cluestick.studioclient.Symbol;
import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchResultsView
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.google.devrel.cluestick.studioclient.SearchResultsView");
    private final EventLog eventLog = new EventLog((CluestickSearch)ApplicationManager.getApplication().getService(CluestickSearch.class));
    private final Splitter splitter;
    private final SearchResultsTree tree;
    private final Browser browser;
    private final JComponent secondComponent;
    private Runnable closeAction;

    public SearchResultsView(@NotNull Project project, @NotNull Symbol symbol, @NotNull List<Result> results) {
        this.setLayout(new BorderLayout());
        this.tree = new SearchResultsTree(symbol, results);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SearchResultsView.this.syncBrowser();
            }
        });
        SmartExpander.installOn((JTree)((Object)this.tree));
        this.browser = new CodeBrowser(project, this.eventLog);
        this.splitter = new OnePixelSplitter(false, 0.5f);
        this.splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.tree)));
        this.secondComponent = ScrollPaneFactory.createScrollPane((Component)this.browser.getPanel());
        this.splitter.setSecondComponent(this.secondComponent);
        this.secondComponent.setVisible(false);
        this.add((Component)this.splitter, "Center");
        this.createActionsPanel();
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                TreeNode node = SearchResultsView.this.getSingleSelectedNode();
                TreePath path = SearchResultsView.this.tree.getClosestPathForLocation(event.getX(), event.getY());
                if (node != null && node.isLeaf() && path != null && SearchResultsView.this.tree.isPathSelected(path)) {
                    SearchResultsView.this.invokeSelectAction(node);
                    return true;
                }
                return false;
            }
        }.installOn((Component)((Object)this.tree));
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreeNode node = SearchResultsView.this.getSingleSelectedNode();
                if (node != null && node.isLeaf() && e.getKeyCode() == 10) {
                    SearchResultsView.this.invokeSelectAction(node);
                }
            }
        });
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new OpenURLAction());
        PopupHandler.installPopupMenu((JComponent)((Object)this.tree), (ActionGroup)actionGroup, (String)"UsageViewPopup");
        TreeUtil.expandAll((JTree)((Object)this.tree));
    }

    public void setClose(Runnable close) {
        this.closeAction = close;
    }

    private void invokeSelectAction(@Nullable TreeNode node) {
        String url = this.getURLForNode(node);
        if (url != null) {
            this.openExternalBrowser(url);
        }
    }

    @Nullable
    private String getURLForNode(@Nullable TreeNode node) {
        String url;
        if (node instanceof SearchResultsNode && !StringUtil.isEmpty((String)(url = ((SearchResultsNode)((Object)node)).getURL()))) {
            return url;
        }
        return null;
    }

    private void openExternalBrowser(@NotNull String url) {
        LOG.info(String.format("Opening URL: `%s`", url));
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void createActionsPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new CloseAction());
        ActionManager actionManager = ActionManager.getInstance();
        JComponent actionsToolbar = actionManager.createActionToolbar("CodeInspection", (ActionGroup)group, false).getComponent();
        JPanel actionsPanel = new JPanel(new BorderLayout());
        actionsPanel.add((Component)actionsToolbar, "West");
        this.add((Component)actionsPanel, "West");
    }

    public void dispose() {
        this.splitter.dispose();
        this.eventLog.cancel();
        if (this.browser instanceof Disposable) {
            ((Disposable)this.browser).dispose();
        }
    }

    private TreeNode getSingleSelectedNode() {
        TreePath pathSelected;
        TreeSelectionModel selectionModel = this.tree.getSelectionModel();
        if (selectionModel.getSelectionCount() == 1 && (pathSelected = this.tree.getSelectionModel().getLeadSelectionPath()) != null) {
            return (TreeNode)pathSelected.getLastPathComponent();
        }
        return null;
    }

    private void syncBrowser() {
        Result result;
        boolean visible = false;
        TreeNode node = this.getSingleSelectedNode();
        if (node instanceof SearchResultsNode && (result = ((SearchResultsNode)((Object)node)).getSearchResult()) != null && this.showInBrowser(result)) {
            visible = true;
        }
        if (!visible) {
            this.browser.showEmpty();
        }
        if (this.secondComponent.isVisible() != visible) {
            this.secondComponent.setVisible(visible);
            this.splitter.doLayout();
            this.splitter.doLayout();
        }
    }

    private boolean showInBrowser(@NotNull Result result) {
        if (result.getCode() == null) {
            return false;
        }
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.browser.showResult(result);
        this.setCursor(currentCursor);
        return true;
    }

    private class OpenURLAction
    extends AnAction {
        private OpenURLAction() {
            super(IdeBundle.message((String)"open.url.in.browser.tooltip", (Object[])new Object[0]), null, null);
        }

        public void update(AnActionEvent e) {
            String url = SearchResultsView.this.getURLForNode(SearchResultsView.this.getSingleSelectedNode());
            e.getPresentation().setVisible(url != null);
        }

        public void actionPerformed(AnActionEvent e) {
            SearchResultsView.this.invokeSelectAction(SearchResultsView.this.getSingleSelectedNode());
        }
    }

    private class CloseAction
    extends AnAction
    implements DumbAware {
        private CloseAction() {
            super(CommonBundle.message((String)"action.close", (Object[])new Object[0]), null, AllIcons.Actions.Cancel);
        }

        public void actionPerformed(AnActionEvent e) {
            if (SearchResultsView.this.closeAction != null) {
                SearchResultsView.this.closeAction.run();
            }
        }
    }
}

