/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.studioclient;

import com.google.devrel.cluestick.studioclient.Symbol;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiHelpers {
    private PsiHelpers() {
    }

    @NotNull
    public static Collection<Symbol> findSymbols(@Nullable PsiElement targetElement) {
        if (targetElement == null) {
            return Collections.emptyList();
        }
        Helper helper = new Helper(targetElement);
        return helper.symbols;
    }

    @Nullable
    public static PsiClass nearestBinaryClass(@Nullable PsiClass c) {
        while (c != null && !PsiHelpers.classIsObject(c)) {
            if (PsiHelpers.elementInBinaryClass((PsiElement)c)) {
                return c;
            }
            c = c.getSuperClass();
        }
        return null;
    }

    public static boolean classIsObject(@Nullable PsiClass c) {
        return c.getSuperClass() == null;
    }

    public static boolean elementInBinaryClass(@Nullable PsiElement targetElement) {
        String name;
        if (targetElement == null) {
            return false;
        }
        targetElement = targetElement.getOriginalElement();
        PsiFile file = null;
        try {
            file = targetElement.getContainingFile();
        }
        catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
            // empty catch block
        }
        if (file != null && file.getFileType().isBinary()) {
            return true;
        }
        if (!targetElement.isWritable()) {
            return true;
        }
        PsiClass relatedClass = PsiHelpers.classForElement(targetElement);
        if (relatedClass != null && (name = relatedClass.getQualifiedName()) != null) {
            boolean isInternal;
            boolean bl = isInternal = name.startsWith("java.") || name.startsWith("android.");
            if (isInternal) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiClass classForElement(@Nullable PsiElement element) {
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        if (element instanceof PsiMember) {
            return ((PsiMember)element).getContainingClass();
        }
        if (element instanceof PsiVariable) {
            element = ((PsiVariable)element).getTypeElement();
        }
        if (element instanceof PsiTypeElement) {
            PsiType type = ((PsiTypeElement)element).getType();
            if (type instanceof PsiArrayType) {
                type = ((PsiArrayType)type).getComponentType();
            }
            if (type instanceof PsiClassType) {
                return ((PsiClassType)type).resolve();
            }
        }
        return null;
    }

    private static class Helper {
        final List<Symbol> symbols = new ArrayList<Symbol>();

        Helper(@NotNull PsiElement targetElement) {
            if (targetElement instanceof PsiMember) {
                this.yield((PsiMember)targetElement);
            }
            if (targetElement instanceof PsiMethod) {
                ArrayList<PsiMethod> queue = new ArrayList<PsiMethod>();
                queue.add((PsiMethod)targetElement);
                for (int i = 0; i < queue.size(); ++i) {
                    PsiMethod method = (PsiMethod)queue.get(i);
                    if (i > 0 && !this.yield((PsiMember)method)) continue;
                    List supers = method.findSuperMethodSignaturesIncludingStatic(false);
                    for (MethodSignatureBackedByPsiMethod sig : supers) {
                        queue.add(sig.getMethod());
                    }
                }
            }
            if (targetElement instanceof PsiVariable) {
                targetElement = ((PsiVariable)targetElement).getTypeElement();
            }
            if (targetElement instanceof PsiTypeElement) {
                PsiType type = ((PsiTypeElement)targetElement).getType();
                if (type instanceof PsiArrayType) {
                    type = ((PsiArrayType)type).getComponentType();
                }
                if (type instanceof PsiClassType) {
                    targetElement = ((PsiClassType)type).resolve();
                } else {
                    this.yield(type.getCanonicalText());
                }
            }
            PsiClass targetClass = null;
            if (targetElement instanceof PsiClass) {
                targetClass = (PsiClass)targetElement;
            } else if (this.symbols.isEmpty()) {
                targetClass = PsiHelpers.classForElement(targetElement);
            }
            if (targetClass != null) {
                PsiClass[] interfaces;
                PsiClass current = targetClass;
                while ((current = PsiHelpers.nearestBinaryClass(current)) != null) {
                    this.yield(current);
                    current = current.getSuperClass();
                }
                for (PsiClass i : interfaces = targetClass.getInterfaces()) {
                    this.yield(i);
                }
            }
        }

        private boolean yield(@Nullable String s) {
            if (s != null && !s.isEmpty()) {
                this.symbols.add(new Symbol(s));
                return true;
            }
            return false;
        }

        private boolean yield(@Nullable PsiClass c) {
            if (PsiHelpers.elementInBinaryClass((PsiElement)c)) {
                return this.yield(c.getQualifiedName());
            }
            return false;
        }

        private boolean yield(@Nullable PsiMember m) {
            String qualifiedName;
            if (m.hasModifierProperty("private")) {
                return false;
            }
            PsiClass containingClass = m.getContainingClass();
            String classPrefix = "";
            if (PsiHelpers.elementInBinaryClass((PsiElement)containingClass) && (qualifiedName = containingClass.getQualifiedName()) != null) {
                classPrefix = String.format("%s.", qualifiedName);
            }
            return this.yield(String.format("%s%s", classPrefix, m.getName()));
        }
    }
}

