/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.searchservice;

import com.appspot.cluestick_server.search.Search;
import com.appspot.cluestick_server.search.model.EventReq;
import com.appspot.cluestick_server.search.model.Result;
import com.appspot.cluestick_server.search.model.SearchResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.devrel.cluestick.studioclient.Symbol;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CluestickSearch {
    private static final Logger LOG = Logger.getInstance((String)"#com.google.devrel.cluestick.searchservice.CluestickSearch");
    private final Search searchService;
    private String sessionId;

    public CluestickSearch() {
        this.searchService = new Search((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), null);
    }

    public CluestickSearch(HttpTransport transport, JsonFactory jsonFactory) {
        this.searchService = new Search(transport, jsonFactory, null);
    }

    public void logEvent(@Nullable String action, @Nullable String resultKey, int signal) {
        EventReq event = new EventReq();
        event.setAction(action);
        event.setSessionId(this.sessionId);
        event.setResultKey(resultKey);
        event.setSignal(signal);
        event.setSignal(event.getSignal() + signal);
        try {
            LOG.info("Logging event: " + event);
            Search.Event request = this.searchService.event(event);
            request.execute();
        }
        catch (IOException e) {
            LOG.info("Log error: " + e);
        }
    }

    public List<Result> performSearch(Symbol symbol, @Nullable String userAgent) throws IOException {
        Search.SearchOperation request = this.searchService.search();
        request.setSessionId(this.sessionId);
        request.setSymbol(symbol.symbolName);
        request.setPackage(symbol.packageName);
        request.setLang("java");
        request.setAllContext(true);
        request.setUserAgent(userAgent);
        SearchResponse response = (SearchResponse)((Object)request.execute());
        if (response.getSessionId() != null) {
            this.sessionId = response.getSessionId();
            LOG.info("Using updated sessionId: " + this.sessionId);
        }
        return response.getResults();
    }
}

