/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.collect.ImmutableList;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceString;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.SerializableResource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class StringPoolChunk
extends Chunk {
    private static final int SORTED_FLAG = 1;
    private static final int UTF8_FLAG = 256;
    private static final int STYLE_START_OFFSET = 24;
    private final int flags;
    private final int stringsStart;
    private final int stylesStart;
    private final int stringCount;
    private final int styleCount;
    private final List<String> strings = new ArrayList<String>();
    private final List<StringPoolStyle> styles = new ArrayList<StringPoolStyle>();
    private boolean isOriginalDeduped = false;

    protected StringPoolChunk(ByteBuffer buffer2, Chunk parent) {
        super(buffer2, parent);
        this.stringCount = buffer2.getInt();
        this.styleCount = buffer2.getInt();
        this.flags = buffer2.getInt();
        this.stringsStart = buffer2.getInt();
        this.stylesStart = buffer2.getInt();
    }

    @Override
    protected void init(ByteBuffer buffer2) {
        super.init(buffer2);
        this.strings.addAll(this.readStrings(buffer2, this.offset + this.stringsStart, this.stringCount));
        this.styles.addAll(this.readStyles(buffer2, this.offset + this.stylesStart, this.styleCount));
    }

    public int indexOf(String string) {
        return this.strings.indexOf(string);
    }

    public String getString(int index2) {
        return this.strings.get(index2);
    }

    public int getStringCount() {
        return this.strings.size();
    }

    public StringPoolStyle getStyle(int index2) {
        return this.styles.get(index2);
    }

    public int getStyleCount() {
        return this.styles.size();
    }

    public BinaryResourceString.Type getStringType() {
        return this.isUTF8() ? BinaryResourceString.Type.UTF8 : BinaryResourceString.Type.UTF16;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.STRING_POOL;
    }

    private int getOffsetSize() {
        return (this.strings.size() + this.styles.size()) * 4;
    }

    public boolean isUTF8() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isSorted() {
        return (this.flags & 1) != 0;
    }

    private List<String> readStrings(ByteBuffer buffer2, int offset, int count) {
        ArrayList<String> result = new ArrayList<String>();
        int previousOffset = -1;
        for (int i = 0; i < count; ++i) {
            int stringOffset = offset + buffer2.getInt();
            result.add(BinaryResourceString.decodeString(buffer2, stringOffset, this.getStringType()));
            if (stringOffset <= previousOffset) {
                this.isOriginalDeduped = true;
            }
            previousOffset = stringOffset;
        }
        return result;
    }

    private List<StringPoolStyle> readStyles(ByteBuffer buffer2, int offset, int count) {
        ArrayList<StringPoolStyle> result = new ArrayList<StringPoolStyle>();
        for (int i = 0; i < count; ++i) {
            int styleOffset = offset + buffer2.getInt();
            result.add(StringPoolStyle.create(buffer2, styleOffset, this));
        }
        return result;
    }

    private int writeStrings(DataOutput payload, ByteBuffer offsets, boolean shrink) throws IOException {
        int stringOffset = 0;
        HashMap<String, Integer> used = new HashMap<String, Integer>();
        for (String string : this.strings) {
            if (used.containsKey(string) && (shrink || this.isOriginalDeduped)) {
                Integer offset = (Integer)used.get(string);
                offsets.putInt(offset == null ? 0 : offset);
                continue;
            }
            byte[] encodedString = BinaryResourceString.encodeString(string, this.getStringType());
            payload.write(encodedString);
            used.put(string, stringOffset);
            offsets.putInt(stringOffset);
            stringOffset += encodedString.length;
        }
        stringOffset = this.writePad(payload, stringOffset);
        return stringOffset;
    }

    private int writeStyles(DataOutput payload, ByteBuffer offsets, boolean shrink) throws IOException {
        int styleOffset = 0;
        if (!this.styles.isEmpty()) {
            HashMap<StringPoolStyle, Integer> used = new HashMap<StringPoolStyle, Integer>();
            for (StringPoolStyle style : this.styles) {
                if (!used.containsKey(style) || !shrink) {
                    byte[] encodedStyle = style.toByteArray(shrink);
                    payload.write(encodedStyle);
                    used.put(style, styleOffset);
                    offsets.putInt(styleOffset);
                    styleOffset += encodedStyle.length;
                    continue;
                }
                Integer offset = (Integer)used.get(style);
                offsets.putInt(offset == null ? 0 : offset);
            }
            payload.writeInt(-1);
            styleOffset += 4;
            payload.writeInt(-1);
            styleOffset += 4;
            styleOffset = this.writePad(payload, styleOffset);
        }
        return styleOffset;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        int stringsStart = this.getHeaderSize() + this.getOffsetSize();
        output.putInt(this.strings.size());
        output.putInt(this.styles.size());
        output.putInt(this.flags);
        output.putInt(this.strings.isEmpty() ? 0 : stringsStart);
        output.putInt(0);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int stringOffset = 0;
        ByteBuffer offsets = ByteBuffer.allocate(this.getOffsetSize());
        offsets.order(ByteOrder.LITTLE_ENDIAN);
        try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream((OutputStream)baos);){
            stringOffset = this.writeStrings((DataOutput)payload, offsets, shrink);
            this.writeStyles((DataOutput)payload, offsets, shrink);
        }
        output.write(offsets.array());
        output.write(baos.toByteArray());
        if (!this.styles.isEmpty()) {
            header.putInt(24, this.getHeaderSize() + this.getOffsetSize() + stringOffset);
        }
    }

    public static class StringPoolStyle
    implements SerializableResource {
        static final int RES_STRING_POOL_SPAN_END = -1;
        private final List<StringPoolSpan> spans;

        static StringPoolStyle create(ByteBuffer buffer2, int offset, StringPoolChunk parent) {
            ImmutableList.Builder spans = ImmutableList.builder();
            int nameIndex = buffer2.getInt(offset);
            while (nameIndex != -1) {
                spans.add((Object)StringPoolSpan.create(buffer2, offset, parent));
                nameIndex = buffer2.getInt(offset += 12);
            }
            return new StringPoolStyle((List<StringPoolSpan>)spans.build());
        }

        private StringPoolStyle(List<StringPoolSpan> spans) {
            this.spans = spans;
        }

        @Override
        public byte[] toByteArray() throws IOException {
            return this.toByteArray(false);
        }

        @Override
        public byte[] toByteArray(boolean shrink) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream((OutputStream)baos);){
                for (StringPoolSpan span : this.spans) {
                    byte[] encodedSpan = span.toByteArray(shrink);
                    if (encodedSpan.length != 12) {
                        throw new IllegalStateException("Encountered a span of invalid length.");
                    }
                    payload.write(encodedSpan);
                }
                payload.writeInt(-1);
            }
            return baos.toByteArray();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringPoolStyle that = (StringPoolStyle)o;
            return Objects.equals(this.spans, that.spans);
        }

        public int hashCode() {
            return Objects.hash(this.spans);
        }

        public String toString() {
            return String.format("StringPoolStyle{spans=%s}", this.spans);
        }
    }

    private static class StringPoolSpan
    implements SerializableResource {
        static final int SPAN_LENGTH = 12;
        private final int nameIndex;
        private final int start;
        private final int stop;
        private final StringPoolChunk parent;

        static StringPoolSpan create(ByteBuffer buffer2, int offset, StringPoolChunk parent) {
            int nameIndex = buffer2.getInt(offset);
            int start2 = buffer2.getInt(offset + 4);
            int stop2 = buffer2.getInt(offset + 8);
            return new StringPoolSpan(nameIndex, start2, stop2, parent);
        }

        private StringPoolSpan(int nameIndex, int start2, int stop2, StringPoolChunk parent) {
            this.nameIndex = nameIndex;
            this.start = start2;
            this.stop = stop2;
            this.parent = parent;
        }

        @Override
        public final byte[] toByteArray() {
            return this.toByteArray(false);
        }

        @Override
        public final byte[] toByteArray(boolean shrink) {
            ByteBuffer buffer2 = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
            buffer2.putInt(this.nameIndex);
            buffer2.putInt(this.start);
            buffer2.putInt(this.stop);
            return buffer2.array();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringPoolSpan that = (StringPoolSpan)o;
            return this.nameIndex == that.nameIndex && this.start == that.start && this.stop == that.stop && Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            return Objects.hash(this.nameIndex, this.start, this.stop, this.parent);
        }

        public String toString() {
            return String.format("StringPoolSpan{%s, start=%d, stop=%d}", this.parent.getString(this.nameIndex), this.start, this.stop);
        }
    }
}

