/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.ChunkWithChunks;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ResourceTableChunk
extends ChunkWithChunks {
    private StringPoolChunk stringPool;
    private final Map<String, PackageChunk> packages = new HashMap<String, PackageChunk>();

    protected ResourceTableChunk(ByteBuffer buffer2, Chunk parent) {
        super(buffer2, parent);
        Preconditions.checkState((buffer2.getInt() >= 1 ? 1 : 0) != 0, (Object)"ResourceTableChunk package count was < 1.");
    }

    @Override
    protected void init(ByteBuffer buffer2) {
        super.init(buffer2);
        this.packages.clear();
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk instanceof PackageChunk) {
                PackageChunk packageChunk = (PackageChunk)chunk;
                this.packages.put(packageChunk.getPackageName(), packageChunk);
                continue;
            }
            if (!(chunk instanceof StringPoolChunk)) continue;
            this.stringPool = (StringPoolChunk)chunk;
        }
        Preconditions.checkNotNull((Object)this.stringPool, (Object)"ResourceTableChunk must have a string pool.");
    }

    public StringPoolChunk getStringPool() {
        return this.stringPool;
    }

    public PackageChunk getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    public Collection<PackageChunk> getPackages() {
        return Collections.unmodifiableCollection(this.packages.values());
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.packages.size());
    }
}

