/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.common.primitives.Shorts;
import com.google.devrel.gmscore.tools.apk.arsc.LibraryChunk;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceTableChunk;
import com.google.devrel.gmscore.tools.apk.arsc.SerializableResource;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import com.google.devrel.gmscore.tools.apk.arsc.UnknownChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlCdataChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlEndElementChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceEndChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceStartChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlResourceMapChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public abstract class Chunk
implements SerializableResource {
    public static final int PAD_BOUNDARY = 4;
    public static final int METADATA_SIZE = 8;
    private static final int CHUNK_SIZE_OFFSET = 4;
    private final Chunk parent;
    protected final int headerSize;
    protected final int chunkSize;
    protected final int offset;

    protected Chunk(ByteBuffer buffer2, Chunk parent) {
        this.parent = parent;
        this.offset = buffer2.position() - 2;
        this.headerSize = buffer2.getShort() & 0xFFFF;
        this.chunkSize = buffer2.getInt();
    }

    protected void init(ByteBuffer buffer2) {
    }

    public Chunk getParent() {
        return this.parent;
    }

    protected abstract Type getType();

    public final int getHeaderSize() {
        return this.headerSize;
    }

    public final int getOriginalChunkSize() {
        return this.chunkSize;
    }

    private final void seekToEndOfChunk(ByteBuffer buffer2) {
        buffer2.position(this.offset + this.chunkSize);
    }

    protected final void writeHeader(ByteBuffer output, int chunkSize) {
        int start2 = output.position();
        output.putShort(this.getType().code());
        output.putShort((short)this.headerSize);
        output.putInt(chunkSize);
        this.writeHeader(output);
        int headerBytes = output.position() - start2;
        Preconditions.checkState((headerBytes == this.getHeaderSize() ? 1 : 0) != 0, (String)"Written header is wrong size. Got %s, want %s", (int)headerBytes, (int)this.getHeaderSize());
    }

    protected void writeHeader(ByteBuffer output) {
    }

    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
    }

    protected int writePad(DataOutput output, int currentLength) throws IOException {
        while (currentLength % 4 != 0) {
            output.write(0);
            ++currentLength;
        }
        return currentLength;
    }

    @Override
    public final byte[] toByteArray() throws IOException {
        return this.toByteArray(false);
    }

    @Override
    public final byte[] toByteArray(boolean shrink) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(this.getHeaderSize()).order(ByteOrder.LITTLE_ENDIAN);
        this.writeHeader(header, 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream((OutputStream)baos);){
            this.writePayload((DataOutput)payload, header, shrink);
        }
        byte[] payloadBytes = baos.toByteArray();
        int chunkSize = this.getHeaderSize() + payloadBytes.length;
        header.putInt(4, chunkSize);
        ByteBuffer result = ByteBuffer.allocate(chunkSize).order(ByteOrder.LITTLE_ENDIAN);
        result.put(header.array());
        result.put(payloadBytes);
        return result.array();
    }

    public static Chunk newInstance(ByteBuffer buffer2) {
        return Chunk.newInstance(buffer2, null);
    }

    public static Chunk newInstance(ByteBuffer buffer2, Chunk parent) {
        Type type2 = Type.fromCode(buffer2.getShort());
        Chunk result = switch (type2) {
            case Type.STRING_POOL -> new StringPoolChunk(buffer2, parent);
            case Type.TABLE -> new ResourceTableChunk(buffer2, parent);
            case Type.XML -> new XmlChunk(buffer2, parent);
            case Type.XML_START_NAMESPACE -> new XmlNamespaceStartChunk(buffer2, parent);
            case Type.XML_END_NAMESPACE -> new XmlNamespaceEndChunk(buffer2, parent);
            case Type.XML_START_ELEMENT -> new XmlStartElementChunk(buffer2, parent);
            case Type.XML_END_ELEMENT -> new XmlEndElementChunk(buffer2, parent);
            case Type.XML_CDATA -> new XmlCdataChunk(buffer2, parent);
            case Type.XML_RESOURCE_MAP -> new XmlResourceMapChunk(buffer2, parent);
            case Type.TABLE_PACKAGE -> new PackageChunk(buffer2, parent);
            case Type.TABLE_TYPE -> new TypeChunk(buffer2, parent);
            case Type.TABLE_TYPE_SPEC -> new TypeSpecChunk(buffer2, parent);
            case Type.TABLE_LIBRARY -> new LibraryChunk(buffer2, parent);
            default -> new UnknownChunk(buffer2, parent);
        };
        result.init(buffer2);
        result.seekToEndOfChunk(buffer2);
        return result;
    }

    public static enum Type {
        NULL(0),
        STRING_POOL(1),
        TABLE(2),
        XML(3),
        XML_START_NAMESPACE(256),
        XML_END_NAMESPACE(257),
        XML_START_ELEMENT(258),
        XML_END_ELEMENT(259),
        XML_CDATA(260),
        XML_RESOURCE_MAP(384),
        TABLE_PACKAGE(512),
        TABLE_TYPE(513),
        TABLE_TYPE_SPEC(514),
        TABLE_LIBRARY(515);

        private final short code;
        private static final Map<Short, Type> FROM_SHORT;

        private Type(int code) {
            this.code = Shorts.checkedCast((long)code);
        }

        public short code() {
            return this.code;
        }

        public static Type fromCode(short code) {
            return (Type)((Object)Preconditions.checkNotNull((Object)((Object)FROM_SHORT.get(code)), (String)"Unknown chunk type: %s", (int)code));
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Type type2 : Type.values()) {
                builder.put((Object)type2.code(), (Object)type2);
            }
            FROM_SHORT = builder.build();
        }
    }
}

