/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.EndOfCentralDirectory;
import com.android.zipflinger.Ints;
import com.android.zipflinger.Location;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class Zip64Locator {
    private static final int SIGNATURE = 117853008;
    public static final int SIZE = 20;
    static final int TOTAL_NUMBER_DISK = 1;
    private Location location = Location.INVALID;
    private long offsetToEOCD64 = 0L;

    private Zip64Locator() {
    }

    public Location getLocation() {
        return this.location;
    }

    public long getOffsetToEOCD64() {
        return this.offsetToEOCD64;
    }

    public static Location write(ZipWriter writer, Location eocdLocation) throws IOException {
        ByteBuffer buffer2 = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer2.putInt(117853008);
        buffer2.putInt(0);
        buffer2.putLong(eocdLocation.first);
        buffer2.putInt(1);
        buffer2.rewind();
        long position = writer.position();
        writer.write(buffer2);
        return new Location(position, 20L);
    }

    static Zip64Locator find(FileChannel channel, EndOfCentralDirectory eocd) throws IOException {
        Zip64Locator locator = new Zip64Locator();
        Location locatorLocation = new Location(eocd.getLocation().first - 20L, 20L);
        long fileSize = channel.size();
        if (locatorLocation.last >= fileSize) {
            return locator;
        }
        if (locatorLocation.first < 0L) {
            return locator;
        }
        ByteBuffer locatorBuffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(locatorBuffer, locatorLocation.first);
        locatorBuffer.rewind();
        if (locator.parse(locatorBuffer)) {
            locator.location = locatorLocation;
        }
        return locator;
    }

    private boolean parse(ByteBuffer buffer2) {
        int signature = buffer2.getInt();
        if (signature != 117853008) {
            return false;
        }
        buffer2.position(buffer2.position() + 4);
        this.offsetToEOCD64 = Ints.ulongToLong(buffer2.getLong());
        return true;
    }
}

