/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelBuildFeatures;
import com.android.tools.lint.model.LintModelDependenciesWriter;
import com.android.tools.lint.model.LintModelJavaArtifact;
import com.android.tools.lint.model.LintModelLibrariesWriter;
import com.android.tools.lint.model.LintModelNamespacingMode;
import com.android.tools.lint.model.LintModelResourceField;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.lint.model.LintModelWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0015\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0018\u001a\u00020\n2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/model/LintModelVariantWriter;", "Lcom/android/tools/lint/model/LintModelWriter;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "variantName", "", "writer", "Ljava/io/Writer;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/lang/String;Ljava/io/Writer;)V", "writeArtifact", "", "artifact", "Lcom/android/tools/lint/model/LintModelArtifact;", "tag", "indent", "", "writeDependencies", "", "writeBuildFeatures", "buildFeatures", "Lcom/android/tools/lint/model/LintModelBuildFeatures;", "writeManifestPlaceholders", "manifestPlaceholders", "", "writeResValues", "resValues", "Lcom/android/tools/lint/model/LintModelResourceField;", "writeVariant", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "createdBy", "android.sdktools.lint-model"})
@SourceDebugExtension(value={"SMAP\nLintModelSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelVariantWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1954:1\n1#2:1955\n603#3:1956\n1291#3,2:1957\n603#3:1959\n1291#3,2:1960\n*S KotlinDebug\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelVariantWriter\n*L\n799#1:1956\n800#1:1957,2\n821#1:1959\n822#1:1960,2\n*E\n"})
final class LintModelVariantWriter
extends LintModelWriter {
    @NotNull
    private final String variantName;

    public LintModelVariantWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @NotNull String variantName, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(adapter, new PrintWriter(writer));
        this.variantName = variantName;
    }

    public /* synthetic */ LintModelVariantWriter(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, String string, Writer writer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            writer = LintModelSerialization.LintModelSerializationAdapter.getWriter$default(lintModelSerializationAdapter, LintModelSerialization.TargetFile.VARIANT, string, null, 4, null);
        }
        this(lintModelSerializationAdapter, string, writer);
    }

    public final void writeVariant(@NotNull LintModelVariant variant, boolean writeDependencies, @Nullable String createdBy) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.setRoot(variant.getModule().getDir());
        int indent2 = 0;
        this.indent(indent2);
        this.getPrinter().print("<variant");
        this.printName(this.getPrinter(), variant.getName(), indent2);
        String string = createdBy;
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.printAttribute(this.getPrinter(), "createdBy", it, indent2);
        }
        if (variant.getUseSupportLibraryVectorDrawables()) {
            this.printAttribute(this.getPrinter(), "useSupportLibraryVectorDrawables", "true", indent2);
        }
        String string2 = variant.getPackage();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.printAttribute(this.getPrinter(), "package", it, indent2);
        }
        AndroidVersion androidVersion = variant.getMinSdkVersion();
        if (androidVersion != null) {
            AndroidVersion it = androidVersion;
            boolean bl = false;
            PrintWriter printWriter = this.getPrinter();
            String string3 = it.getApiString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.apiString");
            this.printAttribute(printWriter, "minSdkVersion", string3, indent2);
        }
        AndroidVersion androidVersion2 = variant.getTargetSdkVersion();
        if (androidVersion2 != null) {
            AndroidVersion it = androidVersion2;
            boolean bl = false;
            PrintWriter printWriter = this.getPrinter();
            String string4 = it.getApiString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.apiString");
            this.printAttribute(printWriter, "targetSdkVersion", string4, indent2);
        }
        if (variant.getDebuggable()) {
            this.printAttribute(this.getPrinter(), "debuggable", "true", indent2);
        }
        if (variant.getShrinkable()) {
            this.printAttribute(this.getPrinter(), "shrinking", "true", indent2);
        }
        File file = variant.getMergedManifest();
        if (file != null) {
            File it = file;
            boolean bl = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "mergedManifest", it, indent2, null, 8, null);
        }
        File file2 = variant.getManifestMergeReport();
        if (file2 != null) {
            File it = file2;
            boolean bl = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "manifestMergeReport", it, indent2, null, 8, null);
        }
        LintModelWriter.printFiles$default(this, this.getPrinter(), "proguardFiles", variant.getProguardFiles(), indent2, null, 8, null);
        LintModelWriter.printFiles$default(this, this.getPrinter(), "consumerProguardFiles", variant.getConsumerProguardFiles(), indent2, null, 8, null);
        LintModelWriter.printStrings$default(this, this.getPrinter(), "resourceConfigurations", variant.getResourceConfigurations(), indent2, null, 8, null);
        File file3 = variant.getPartialResultsDir();
        if (file3 != null) {
            File it = file3;
            boolean bl = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "partialResultsDir", it, indent2, null, 8, null);
        }
        LintModelWriter.printFiles$default(this, this.getPrinter(), "desugaredMethodsFiles", variant.getDesugaredMethodsFiles(), indent2, null, 8, null);
        this.getPrinter().println(">");
        this.writeBuildFeatures(variant.getBuildFeatures(), indent2 + 1);
        this.writeSourceProviders(variant.getSourceProviders(), "sourceProviders", indent2 + 1);
        this.writeSourceProviders(variant.getTestSourceProviders(), "testSourceProviders", indent2 + 1);
        this.writeSourceProviders(variant.getTestFixturesSourceProviders(), "testFixturesSourceProviders", indent2 + 1);
        this.writeResValues(variant.getResValues(), indent2 + 1);
        this.writeManifestPlaceholders(variant.getManifestPlaceholders(), indent2 + 1);
        this.writeArtifact(variant.getMainArtifact(), "mainArtifact", indent2 + 1, writeDependencies);
        LintModelAndroidArtifact lintModelAndroidArtifact = variant.getAndroidTestArtifact();
        if (lintModelAndroidArtifact != null) {
            LintModelAndroidArtifact artifact = lintModelAndroidArtifact;
            boolean bl = false;
            this.writeArtifact(artifact, "androidTestArtifact", indent2 + 1, writeDependencies);
        }
        LintModelAndroidArtifact lintModelAndroidArtifact2 = variant.getTestFixturesArtifact();
        if (lintModelAndroidArtifact2 != null) {
            LintModelAndroidArtifact artifact = lintModelAndroidArtifact2;
            boolean bl = false;
            this.writeArtifact(artifact, "testFixturesArtifact", indent2 + 1, writeDependencies);
        }
        LintModelJavaArtifact lintModelJavaArtifact = variant.getTestArtifact();
        if (lintModelJavaArtifact != null) {
            LintModelJavaArtifact artifact = lintModelJavaArtifact;
            boolean bl = false;
            this.writeArtifact(artifact, "testArtifact", indent2 + 1, writeDependencies);
        }
        this.indent(indent2);
        this.getPrinter().println("</variant>");
        this.getPrinter().close();
    }

    public static /* synthetic */ void writeVariant$default(LintModelVariantWriter lintModelVariantWriter, LintModelVariant lintModelVariant, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        lintModelVariantWriter.writeVariant(lintModelVariant, bl, string);
    }

    private final void writeBuildFeatures(LintModelBuildFeatures buildFeatures, int indent2) {
        this.indent(indent2);
        this.getPrinter().print("<buildFeatures");
        if (buildFeatures.getCoreLibraryDesugaringEnabled()) {
            this.printAttribute(this.getPrinter(), "coreLibraryDesugaring", "true", indent2);
        }
        if (buildFeatures.getViewBinding()) {
            this.printAttribute(this.getPrinter(), "viewBinding", "true", indent2);
        }
        if (buildFeatures.getNamespacingMode() != LintModelNamespacingMode.DISABLED) {
            this.printAttribute(this.getPrinter(), "namespacing", buildFeatures.getNamespacingMode().name(), indent2);
        }
        this.getPrinter().println("/>");
    }

    private final void writeManifestPlaceholders(Map<String, String> manifestPlaceholders, int indent2) {
        if (manifestPlaceholders.isEmpty()) {
            return;
        }
        this.indent(indent2);
        this.getPrinter().println("<manifestPlaceholders>");
        Sequence $this$sortedBy$iv = MapsKt.asSequence(manifestPlaceholders);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            String key2 = (String)it.getKey();
            String value = (String)it.getValue();
            this.indent(indent2 + 1);
            this.getPrinter().print("<placeholder");
            this.printName(this.getPrinter(), key2, indent2 + 1);
            this.printAttribute(this.getPrinter(), "value", value, indent2 + 1);
            this.getPrinter().println(" />");
        }
        this.indent(indent2);
        this.getPrinter().println("</manifestPlaceholders>");
    }

    private final void writeResValues(Map<String, ? extends LintModelResourceField> resValues, int indent2) {
        if (resValues.isEmpty()) {
            return;
        }
        this.indent(indent2);
        this.getPrinter().println("<resValues>");
        Sequence $this$sortedBy$iv = MapsKt.asSequence(resValues);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.indent(indent2 + 1);
            this.getPrinter().print("<resValue");
            LintModelResourceField resourceField = (LintModelResourceField)it.getValue();
            this.printAttribute(this.getPrinter(), "type", resourceField.getType(), indent2 + 1);
            this.printName(this.getPrinter(), resourceField.getName(), indent2 + 1);
            this.printAttribute(this.getPrinter(), "value", resourceField.getValue(), indent2 + 1);
            this.getPrinter().println(" />");
        }
        this.indent(indent2);
        this.getPrinter().println("</resValues>");
    }

    private final void writeArtifact(LintModelArtifact artifact, String tag, int indent2, boolean writeDependencies) {
        this.indent(indent2);
        this.getPrinter().print("<");
        this.getPrinter().print(tag);
        LintModelWriter.printFiles$default(this, this.getPrinter(), "classOutputs", artifact.getClassOutputs(), indent2, null, 8, null);
        if (artifact instanceof LintModelAndroidArtifact) {
            this.printAttribute(this.getPrinter(), "applicationId", ((LintModelAndroidArtifact)artifact).getApplicationId(), indent2);
            LintModelWriter.printFiles$default(this, this.getPrinter(), "generatedSourceFolders", ((LintModelAndroidArtifact)artifact).getGeneratedSourceFolders(), indent2, null, 8, null);
            LintModelWriter.printFiles$default(this, this.getPrinter(), "generatedResourceFolders", ((LintModelAndroidArtifact)artifact).getGeneratedResourceFolders(), indent2, null, 8, null);
            LintModelWriter.printFiles$default(this, this.getPrinter(), "desugaredMethodsFiles", ((LintModelAndroidArtifact)artifact).getDesugaredMethodsFiles(), indent2, null, 8, null);
        }
        this.getPrinter().println(">");
        this.indent(indent2);
        this.getPrinter().print("</");
        this.getPrinter().print(tag);
        this.getPrinter().println(">");
        if (writeDependencies) {
            LintModelDependenciesWriter dependencyWriter = new LintModelDependenciesWriter(this.getAdapter(), this.variantName, tag, null, 8, null);
            dependencyWriter.writeDependencies(artifact.getDependencies());
            LintModelLibrariesWriter libraryWriter = new LintModelLibrariesWriter(this.getAdapter(), this.variantName, tag, null, 8, null);
            libraryWriter.writeLibraries(artifact.getDependencies().getLibraryResolver(), artifact.getDependencies());
        }
    }
}

