/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSeverity;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.lint.model.LintModelWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J4\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J&\u0010\u0015\u001a\u00020\u00122\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/model/LintModelModuleWriter;", "Lcom/android/tools/lint/model/LintModelWriter;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;)V", "writeLintOptions", "", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "indent", "", "writeModule", "module", "Lcom/android/tools/lint/model/LintModelModule;", "writeVariants", "", "Lcom/android/tools/lint/model/LintModelVariant;", "writeDependencies", "", "createdBy", "", "writeSeverityOverrides", "severityOverrides", "", "Lcom/android/tools/lint/model/LintModelSeverity;", "writeVariantReference", "variant", "android.sdktools.lint-model"})
@SourceDebugExtension(value={"SMAP\nLintModelSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelModuleWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1954:1\n1#2:1955\n603#3:1956\n1291#3,2:1957\n*S KotlinDebug\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelModuleWriter\n*L\n693#1:1956\n694#1:1957,2\n*E\n"})
final class LintModelModuleWriter
extends LintModelWriter {
    public LintModelModuleWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        super(adapter, new PrintWriter(LintModelSerialization.LintModelSerializationAdapter.getWriter$default(adapter, LintModelSerialization.TargetFile.MODULE, null, null, 6, null)));
    }

    public final void writeModule(@NotNull LintModelModule module, @Nullable List<? extends LintModelVariant> writeVariants, boolean writeDependencies, @Nullable String createdBy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.setRoot(module.getDir());
        int indent2 = 0;
        this.getPrinter().print("<lint-module");
        this.printAttribute(this.getPrinter(), "format", "1", indent2);
        PrintWriter printWriter = this.getPrinter();
        String string = module.getDir().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.dir.path");
        this.printAttribute(printWriter, "dir", string, indent2);
        this.printName(this.getPrinter(), module.getModulePath(), indent2);
        this.printAttribute(this.getPrinter(), "type", module.getType().name(), indent2);
        String string2 = createdBy;
        if (string2 != null) {
            String string3 = string2;
            boolean bl2 = false;
            this.printAttribute(this.getPrinter(), "createdBy", string3, indent2);
        }
        LintModelMavenName lintModelMavenName = module.getMavenName();
        if (lintModelMavenName != null) {
            LintModelMavenName it = lintModelMavenName;
            bl = false;
            this.printAttribute(this.getPrinter(), "maven", it.toString(), indent2);
        }
        AgpVersion agpVersion = module.getAgpVersion();
        if (agpVersion != null) {
            AgpVersion it = agpVersion;
            bl = false;
            this.printAttribute(this.getPrinter(), "agpVersion", it.toString(), indent2);
        }
        LintModelWriter.printFile$default(this, this.getPrinter(), "buildFolder", module.getBuildFolder(), indent2, null, 8, null);
        String string4 = module.getResourcePrefix();
        if (string4 != null) {
            String it = string4;
            bl = false;
            this.printAttribute(this.getPrinter(), "resourcePrefix", it, indent2);
        }
        LintModelWriter.printStrings$default(this, this.getPrinter(), "dynamicFeatures", module.getDynamicFeatures(), indent2, null, 8, null);
        LintModelWriter.printFiles$default(this, this.getPrinter(), "bootClassPath", module.getBootClassPath(), indent2, null, 8, null);
        this.printAttribute(this.getPrinter(), "javaSourceLevel", module.getJavaSourceLevel(), indent2);
        this.printAttribute(this.getPrinter(), "compileTarget", module.getCompileTarget(), indent2);
        if (module.neverShrinking()) {
            this.printAttribute(this.getPrinter(), "neverShrinking", "true", indent2);
        }
        LintModelWriter.printFiles$default(this, this.getPrinter(), "lintRuleJars", module.getLintRuleJars(), indent2, null, 8, null);
        this.getPrinter().println(">");
        this.writeLintOptions(module.getLintOptions(), indent2 + 1);
        if (writeVariants != null) {
            for (LintModelVariant lintModelVariant : writeVariants) {
                this.writeVariantReference(lintModelVariant, indent2 + 1);
                LintModelSerialization.INSTANCE.writeVariant(lintModelVariant, this.getAdapter(), writeDependencies, createdBy);
            }
        }
        this.getPrinter().println("</lint-module>");
        this.getPrinter().close();
    }

    public static /* synthetic */ void writeModule$default(LintModelModuleWriter lintModelModuleWriter, LintModelModule lintModelModule, List list2, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = lintModelModule.getVariants();
        }
        if ((n & 8) != 0) {
            string = null;
        }
        lintModelModuleWriter.writeModule(lintModelModule, list2, bl, string);
    }

    private final void writeVariantReference(LintModelVariant variant, int indent2) {
        this.indent(indent2);
        this.getPrinter().print("<variant name=\"");
        this.getPrinter().print(variant.getName());
        this.getPrinter().println("\"/>");
    }

    private final void writeLintOptions(LintModelLintOptions lintOptions, int indent2) {
        File it;
        this.indent(indent2);
        this.getPrinter().print("<lintOptions");
        LintModelWriter.printFile$default(this, this.getPrinter(), "lintConfig", lintOptions.getLintConfig(), indent2, null, 8, null);
        LintModelWriter.printFile$default(this, this.getPrinter(), "baselineFile", lintOptions.getBaselineFile(), indent2, null, 8, null);
        if (lintOptions.getCheckDependencies()) {
            this.printAttribute(this.getPrinter(), "checkDependencies", "true", indent2);
        }
        if (lintOptions.getCheckTestSources()) {
            this.printAttribute(this.getPrinter(), "checkTestSources", "true", indent2);
        }
        if (!((Collection)lintOptions.getDisable()).isEmpty()) {
            LintModelWriter.printStrings$default(this, this.getPrinter(), "disable", lintOptions.getDisable(), indent2, null, 8, null);
        }
        if (!((Collection)lintOptions.getEnable()).isEmpty()) {
            LintModelWriter.printStrings$default(this, this.getPrinter(), "enable", lintOptions.getEnable(), indent2, null, 8, null);
        }
        Set<String> set = lintOptions.getCheck();
        boolean bl = set != null ? !((Collection)set).isEmpty() : false;
        if (bl) {
            LintModelWriter.printStrings$default(this, this.getPrinter(), "check", lintOptions.getDisable(), indent2, null, 8, null);
        }
        if (lintOptions.getAbortOnError()) {
            this.printAttribute(this.getPrinter(), "abortOnError", "true", indent2);
        }
        if (lintOptions.getAbsolutePaths()) {
            this.printAttribute(this.getPrinter(), "absolutePaths", "true", indent2);
        }
        if (lintOptions.getNoLines()) {
            this.printAttribute(this.getPrinter(), "noLines", "true", indent2);
        }
        if (lintOptions.getQuiet()) {
            this.printAttribute(this.getPrinter(), "quiet", "true", indent2);
        }
        if (lintOptions.getCheckAllWarnings()) {
            this.printAttribute(this.getPrinter(), "checkAllWarnings", "true", indent2);
        }
        if (lintOptions.getIgnoreWarnings()) {
            this.printAttribute(this.getPrinter(), "ignoreWarnings", "true", indent2);
        }
        if (lintOptions.getWarningsAsErrors()) {
            this.printAttribute(this.getPrinter(), "warningsAsErrors", "true", indent2);
        }
        if (lintOptions.getIgnoreTestSources()) {
            this.printAttribute(this.getPrinter(), "ignoreTestSources", "true", indent2);
        }
        if (lintOptions.getIgnoreTestFixturesSources()) {
            this.printAttribute(this.getPrinter(), "ignoreTestFixturesSources", "true", indent2);
        }
        if (lintOptions.getCheckGeneratedSources()) {
            this.printAttribute(this.getPrinter(), "checkGeneratedSources", "true", indent2);
        }
        if (lintOptions.getCheckReleaseBuilds()) {
            this.printAttribute(this.getPrinter(), "checkReleaseBuilds", "true", indent2);
        }
        if (lintOptions.getExplainIssues()) {
            this.printAttribute(this.getPrinter(), "explainIssues", "true", indent2);
        }
        if (lintOptions.getShowAll()) {
            this.printAttribute(this.getPrinter(), "showAll", "true", indent2);
        }
        if (lintOptions.getTextReport()) {
            this.printAttribute(this.getPrinter(), "textReport", "true", indent2);
        }
        LintModelWriter.printFile$default(this, this.getPrinter(), "textOutput", lintOptions.getTextOutput(), indent2, null, 8, null);
        if (lintOptions.getHtmlReport()) {
            this.printAttribute(this.getPrinter(), "htmlReport", "true", indent2);
        }
        File file = lintOptions.getHtmlOutput();
        if (file != null) {
            it = file;
            boolean bl2 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "htmlOutput", it, indent2, null, 8, null);
        }
        if (lintOptions.getXmlReport()) {
            this.printAttribute(this.getPrinter(), "xmlReport", "true", indent2);
        }
        File file2 = lintOptions.getXmlOutput();
        if (file2 != null) {
            it = file2;
            boolean bl3 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "xmlOutput", it, indent2, null, 8, null);
        }
        if (lintOptions.getSarifReport()) {
            this.printAttribute(this.getPrinter(), "sarifReport", "true", indent2);
        }
        File file3 = lintOptions.getSarifOutput();
        if (file3 != null) {
            it = file3;
            boolean bl4 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "sarifOutput", it, indent2, null, 8, null);
        }
        if (!this.writeSeverityOverrides(lintOptions.getSeverityOverrides(), indent2 + 1)) {
            this.getPrinter().println("/>");
        } else {
            this.indent(indent2);
            this.getPrinter().println("</lintOptions>");
        }
    }

    private final boolean writeSeverityOverrides(Map<String, ? extends LintModelSeverity> severityOverrides, int indent2) {
        if (severityOverrides == null) {
            return false;
        }
        if (severityOverrides.isEmpty()) {
            return false;
        }
        this.getPrinter().println(">");
        this.indent(indent2);
        this.getPrinter().println("<severities>");
        Sequence $this$sortedBy$iv = MapsKt.asSequence(severityOverrides);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String id = (String)entry.getKey();
            LintModelSeverity severity = (LintModelSeverity)((Object)entry.getValue());
            this.indent(indent2 + 1);
            this.getPrinter().print("<severity");
            this.printAttribute(this.getPrinter(), "id", id, indent2);
            this.printAttribute(this.getPrinter(), "severity", severity.name(), indent2);
            this.getPrinter().println(" />");
        }
        this.indent(indent2);
        this.getPrinter().println("</severities>");
        return true;
    }
}

