/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.DefaultLintModelAndroidLibrary;
import com.android.tools.lint.model.DefaultLintModelJavaLibrary;
import com.android.tools.lint.model.DefaultLintModelLibraryResolver;
import com.android.tools.lint.model.DefaultLintModelModuleLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelReader;
import com.android.tools.lint.model.LintModelSerialization;
import java.io.File;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0015\u001a\u00020\u0010H\u0002R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/model/LintModelLibrariesReader;", "Lcom/android/tools/lint/model/LintModelReader;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "libraryResolver", "Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;", "root", "Ljava/io/File;", "variantName", "", "artifactName", "reader", "Ljava/io/Reader;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/io/Reader;)V", "libraryResolverMap", "", "Lcom/android/tools/lint/model/LintModelLibrary;", "path", "getPath", "()Ljava/lang/String;", "readLibraries", "readLibrary", "android.sdktools.lint-model"})
final class LintModelLibrariesReader
extends LintModelReader {
    @NotNull
    private final String variantName;
    @NotNull
    private final String artifactName;
    @NotNull
    private final Map<String, LintModelLibrary> libraryResolverMap;
    @NotNull
    private final DefaultLintModelLibraryResolver libraryResolver;

    public LintModelLibrariesReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @Nullable DefaultLintModelLibraryResolver libraryResolver, @Nullable File root, @NotNull String variantName, @NotNull String artifactName, @NotNull Reader reader) {
        DefaultLintModelLibraryResolver defaultLintModelLibraryResolver;
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(adapter, root, reader);
        this.variantName = variantName;
        this.artifactName = artifactName;
        DefaultLintModelLibraryResolver defaultLintModelLibraryResolver2 = libraryResolver;
        Map map2 = defaultLintModelLibraryResolver2 != null ? defaultLintModelLibraryResolver2.getLibraryMap() : null;
        Map<Object, Object> map3 = TypeIntrinsics.isMutableMap(map2) ? map2 : null;
        if (map3 == null) {
            map3 = this.libraryResolverMap = (Map)new LinkedHashMap();
        }
        if ((defaultLintModelLibraryResolver = libraryResolver) == null) {
            defaultLintModelLibraryResolver = new DefaultLintModelLibraryResolver(this.libraryResolverMap);
        }
        this.libraryResolver = defaultLintModelLibraryResolver;
    }

    public /* synthetic */ LintModelLibrariesReader(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, DefaultLintModelLibraryResolver defaultLintModelLibraryResolver, File file, String string, String string2, Reader reader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            defaultLintModelLibraryResolver = null;
        }
        if ((n & 0x20) != 0) {
            reader = lintModelSerializationAdapter.getReader(LintModelSerialization.TargetFile.LIBRARY_TABLE, string, string2);
        }
        this(lintModelSerializationAdapter, defaultLintModelLibraryResolver, file, string, string2, reader);
    }

    @Override
    @NotNull
    protected String getPath() {
        File file = this.getAdapter().file(LintModelSerialization.TargetFile.DEPENDENCIES, this.variantName, this.artifactName);
        String string = file != null ? file.getPath() : null;
        if (string == null) {
            string = "<unknown>";
        }
        return string;
    }

    @NotNull
    public final DefaultLintModelLibraryResolver readLibraries() {
        this.getParser().nextTag();
        this.expectTag("libraries");
        block4: while (this.getParser().next() != 1) {
            int eventType = this.getParser().getEventType();
            switch (eventType) {
                case 2: {
                    if (Intrinsics.areEqual((Object)this.getParser().getName(), (Object)"library")) {
                        LintModelLibrary library2 = this.readLibrary();
                        this.libraryResolverMap.put(library2.getIdentifier(), library2);
                        continue block4;
                    }
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag("libraries");
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return this.libraryResolver;
    }

    private final LintModelLibrary readLibrary() {
        LintModelLibrary lintModelLibrary;
        this.expectTag("library");
        boolean android2 = false;
        String identifier = this.getName();
        List<File> jars = this.getFiles("jars");
        String project = this.getOptionalAttribute("project");
        String string = this.getOptionalAttribute("resolved");
        LintModelMavenName resolved = string != null ? this.toMavenCoordinate(string) : null;
        boolean provided = this.getOptionalBoolean("provided", false);
        File manifestFile = null;
        File resFolder = null;
        File assetsFolder = null;
        File lintJar = null;
        File publicResources = null;
        File symbolFile = null;
        File externalAnnotations = null;
        File proguardRules = null;
        File folder = this.getOptionalFile("folder");
        if (folder != null) {
            android2 = true;
            resFolder = this.getRequiredFile("resFolder", folder);
            assetsFolder = this.getRequiredFile("assetsFolder", folder);
            lintJar = this.getRequiredFile("lintJar", folder);
            publicResources = this.getRequiredFile("publicResources", folder);
            symbolFile = this.getRequiredFile("symbolFile", folder);
            manifestFile = this.getRequiredFile("manifest", folder);
            externalAnnotations = this.getRequiredFile("externalAnnotations", folder);
            proguardRules = this.getRequiredFile("proguardRules", folder);
        }
        this.finishTag("library");
        if (project != null) {
            lintModelLibrary = new DefaultLintModelModuleLibrary(identifier, project, lintJar, provided);
        } else if (android2) {
            File file = manifestFile;
            Intrinsics.checkNotNull(file);
            File file2 = folder;
            Intrinsics.checkNotNull((Object)file2);
            File file3 = resFolder;
            Intrinsics.checkNotNull((Object)file3);
            File file4 = assetsFolder;
            Intrinsics.checkNotNull((Object)file4);
            File file5 = publicResources;
            Intrinsics.checkNotNull((Object)file5);
            File file6 = symbolFile;
            Intrinsics.checkNotNull((Object)file6);
            File file7 = externalAnnotations;
            Intrinsics.checkNotNull(file7);
            File file8 = proguardRules;
            Intrinsics.checkNotNull(file8);
            LintModelMavenName lintModelMavenName = resolved;
            Intrinsics.checkNotNull((Object)lintModelMavenName);
            lintModelLibrary = new DefaultLintModelAndroidLibrary(identifier, jars, file, file2, file3, file4, lintJar, file5, file6, file7, file8, provided, lintModelMavenName);
        } else {
            LintModelMavenName lintModelMavenName = resolved;
            Intrinsics.checkNotNull((Object)lintModelMavenName);
            LintModelMavenName lintModelMavenName2 = lintModelMavenName;
            lintModelLibrary = new DefaultLintModelJavaLibrary(identifier, jars, lintModelMavenName2, provided);
        }
        return lintModelLibrary;
    }
}

