/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001a\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"B+\b\u0004\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0000J\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/detector/api/LintFix;", "", "displayName", "", "familyName", "range", "Lcom/android/tools/lint/detector/api/Location;", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;)V", "independent", "", "getRange", "()Lcom/android/tools/lint/detector/api/Location;", "setRange", "(Lcom/android/tools/lint/detector/api/Location;)V", "robot", "autoFix", "getDisplayName", "getFamilyName", "AnnotateBuilder", "AnnotateFix", "Builder", "Companion", "CreateFileBuilder", "CreateFileFix", "DataMap", "FixMapBuilder", "GroupBuilder", "GroupType", "LintFixGroup", "ReplaceString", "ReplaceStringBuilder", "SetAttribute", "SetAttributeBuilder", "ShowUrl", "UrlBuilder", "android.sdktools.lint-api"})
public class LintFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nls
    @Nullable
    private String displayName;
    @Nls
    @Nullable
    private String familyName;
    @Nullable
    private Location range;
    @JvmField
    public boolean robot;
    @JvmField
    public boolean independent;
    @NotNull
    public static final String TODO = "TODO";

    protected LintFix(@Nullable String displayName, @Nullable String familyName, @Nullable Location range) {
        this.displayName = displayName;
        this.familyName = familyName;
        this.range = range;
    }

    public /* synthetic */ LintFix(String string, String string2, Location location2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            location2 = null;
        }
        this(string, string2, location2);
    }

    @Nullable
    public Location getRange() {
        return this.range;
    }

    public void setRange(@Nullable Location location2) {
        this.range = location2;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public final String getFamilyName() {
        return this.familyName;
    }

    @NotNull
    public LintFix autoFix(boolean robot, boolean independent) {
        this.robot = robot;
        this.independent = independent;
        return this;
    }

    @NotNull
    public final LintFix autoFix() {
        this.autoFix(true, true);
        return this;
    }

    protected LintFix() {
        this(null, null, null, 7, null);
    }

    @JvmStatic
    @NotNull
    public static final Builder create() {
        return Companion.create();
    }

    @JvmStatic
    @Contract(value="_, _, !null -> !null")
    @Nullable
    public static final String getString(@Nullable LintFix fix, @NotNull String key2, @Nullable String defaultValue) {
        return Companion.getString(fix, key2, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final List<String> getStringList(@Nullable LintFix fix, @NotNull String key2) {
        return Companion.getStringList(fix, key2);
    }

    @JvmStatic
    @Nullable
    public static final Throwable getThrowable(@Nullable LintFix fix, @NotNull String key2) {
        return Companion.getThrowable(fix, key2);
    }

    @JvmStatic
    public static final int getInt(@Nullable LintFix fix, @NotNull String key2, int defaultValue) {
        return Companion.getInt(fix, key2, defaultValue);
    }

    @JvmStatic
    @Contract(value="_, _, !null -> !null")
    @Nullable
    public static final ApiConstraint getApiConstraint(@Nullable LintFix fix, @NotNull String key2, @Nullable ApiConstraint defaultValue) {
        return Companion.getApiConstraint(fix, key2, defaultValue);
    }

    @JvmStatic
    public static final boolean getBoolean(@Nullable LintFix fix, @NotNull String key2, boolean defaultValue) {
        return Companion.getBoolean(fix, key2, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final PsiMethod getMethod(@Nullable LintFix fix, @NotNull String key2) {
        return Companion.getMethod(fix, key2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u0000J\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$AnnotateBuilder;", "", "displayName", "", "familyName", "annotation", "replace", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "independent", "range", "Lcom/android/tools/lint/detector/api/Location;", "robot", "autoFix", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "android.sdktools.lint-api"})
    public static final class AnnotateBuilder {
        @Nls
        @Nullable
        private final String displayName;
        @Nls
        @Nullable
        private String familyName;
        private final boolean replace;
        @NotNull
        private final String annotation;
        @Nullable
        private Location range;
        private boolean robot;
        private boolean independent;

        public AnnotateBuilder(@Nullable String displayName, @Nullable String familyName, @NotNull String annotation, boolean replace) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            this.displayName = displayName;
            this.familyName = familyName;
            this.replace = replace;
            this.annotation = StringsKt.startsWith$default((String)annotation, (String)"@", (boolean)false, (int)2, null) ? annotation : "@" + annotation;
        }

        @NotNull
        public final AnnotateBuilder range(@NotNull Location range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = Companion.extractOffsets(range);
            return this;
        }

        @NotNull
        public final AnnotateBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final AnnotateBuilder autoFix(boolean robot, boolean independent) {
            this.robot = robot;
            this.independent = independent;
            return this;
        }

        @NotNull
        public final LintFix build() {
            Object desc = null;
            if (this.displayName != null) {
                desc = this.displayName;
            } else {
                Object object;
                int last;
                int index2 = StringsKt.indexOf$default((CharSequence)this.annotation, (char)'(', (int)0, (boolean)false, (int)6, null);
                int n = last = index2 != -1 ? StringsKt.lastIndexOf$default((CharSequence)this.annotation, (char)'.', (int)index2, (boolean)false, (int)4, null) : StringsKt.lastIndexOf$default((CharSequence)this.annotation, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (last != -1) {
                    if (index2 != -1) {
                        String string = this.annotation.substring(last + 1, index2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        object = "@" + string;
                    } else {
                        String string = this.annotation.substring(last + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        object = "@" + string;
                    }
                } else {
                    object = this.annotation;
                }
                String simpleName = object;
                desc = "Annotate with " + simpleName;
            }
            return new AnnotateFix((String)desc, this.familyName, this.annotation, this.replace, this.range, this.robot, this.independent);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BE\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$AnnotateFix;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "annotation", "replace", "", "range", "Lcom/android/tools/lint/detector/api/Location;", "robot", "independent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/android/tools/lint/detector/api/Location;ZZ)V", "getAnnotation", "()Ljava/lang/String;", "getReplace", "()Z", "android.sdktools.lint-api"})
    public static final class AnnotateFix
    extends LintFix {
        @NotNull
        private final String annotation;
        private final boolean replace;

        public AnnotateFix(@Nullable String displayName, @Nullable String familyName, @NotNull String annotation, boolean replace, @Nullable Location range, boolean robot, boolean independent) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            super(displayName, familyName, range);
            this.annotation = annotation;
            this.replace = replace;
            this.robot = robot;
            this.independent = independent;
        }

        @NotNull
        public final String getAnnotation() {
            return this.annotation;
        }

        public final boolean getReplace() {
            return this.replace;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J#\u0010\u0006\u001a\u00020\b2\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\n\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\u0007J#\u0010\u0011\u001a\u00020\b2\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\n\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u0012\u001a\u00020\b2\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\n\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u001a\u001a\u00020\u0007J#\u0010\u001a\u001a\u00020\b2\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\n\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001b\u001a\u00020\u001cJ%\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\n\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0010J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0016\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"J\u0016\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020#J\u0006\u0010$\u001a\u00020%J%\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004H\u0086\u0002J\u0010\u0010)\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0006\u0010*\u001a\u00020%J\u0018\u0010*\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010'\u001a\u00020\u0004J\u0006\u0010+\u001a\u00020,J\u000e\u0010+\u001a\u00020,2\u0006\u0010+\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$Builder;", "", "()V", "displayName", "", "familyName", "alternatives", "Lcom/android/tools/lint/detector/api/LintFix$GroupBuilder;", "Lcom/android/tools/lint/detector/api/LintFix;", "fixes", "", "([Lcom/android/tools/lint/detector/api/LintFix;)Lcom/android/tools/lint/detector/api/LintFix;", "annotate", "Lcom/android/tools/lint/detector/api/LintFix$AnnotateBuilder;", "source", "replace", "", "composite", "data", "args", "([Ljava/lang/Object;)Lcom/android/tools/lint/detector/api/LintFix;", "deleteFile", "Lcom/android/tools/lint/detector/api/LintFix$CreateFileBuilder;", "file", "Ljava/io/File;", "family", "group", "map", "Lcom/android/tools/lint/detector/api/LintFix$FixMapBuilder;", "([Ljava/lang/Object;)Lcom/android/tools/lint/detector/api/LintFix$FixMapBuilder;", "name", "useAsFamilyNameToo", "newFile", "contents", "", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceStringBuilder;", "set", "Lcom/android/tools/lint/detector/api/LintFix$SetAttributeBuilder;", "namespace", "attribute", "value", "sharedName", "unset", "url", "Lcom/android/tools/lint/detector/api/LintFix$UrlBuilder;", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$Builder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1855:1\n37#2,2:1856\n37#2,2:1858\n37#2,2:1860\n*S KotlinDebug\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$Builder\n*L\n231#1:1856,2\n244#1:1858,2\n264#1:1860,2\n*E\n"})
    public static final class Builder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;

        @NotNull
        public final Builder name(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @NotNull
        public final Builder name(@NotNull String displayName, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final Builder name(@NotNull String displayName, boolean useAsFamilyNameToo) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            this.displayName = displayName;
            if (useAsFamilyNameToo) {
                this.familyName = displayName;
            }
            return this;
        }

        @NotNull
        public final Builder sharedName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final Builder family(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final GroupBuilder group() {
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.ALTERNATIVES);
        }

        @NotNull
        public final GroupBuilder alternatives() {
            return this.group();
        }

        @NotNull
        public final GroupBuilder composite() {
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.COMPOSITE);
        }

        @NotNull
        public final LintFix composite(LintFix ... fixes) {
            Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
            Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])fixes);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.COMPOSITE).join(Arrays.copyOf(lintFixArray, lintFixArray.length)).build();
        }

        @NotNull
        public final LintFix group(LintFix ... fixes) {
            Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
            Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])fixes);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
            return new GroupBuilder(this.displayName, this.familyName).join(Arrays.copyOf(lintFixArray, lintFixArray.length)).build();
        }

        @NotNull
        public final LintFix alternatives(LintFix ... fixes) {
            LintFix lintFix;
            Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
            List availableFixes = ArraysKt.filterNotNull((Object[])fixes);
            if (availableFixes.isEmpty()) {
                lintFix = this.map().build();
            } else if (availableFixes.size() == 1) {
                lintFix = (LintFix)availableFixes.get(0);
            } else {
                Collection $this$toTypedArray$iv = availableFixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
                lintFix = this.group(Arrays.copyOf(lintFixArray, lintFixArray.length));
            }
            return lintFix;
        }

        @NotNull
        public final ReplaceStringBuilder replace() {
            return new ReplaceStringBuilder(this.displayName, this.familyName);
        }

        @NotNull
        public final CreateFileBuilder newFile(@NotNull File file, @NotNull String contents) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            return new CreateFileBuilder(this.displayName, this.familyName).file(file).contents(contents);
        }

        @NotNull
        public final CreateFileBuilder newFile(@NotNull File file, @NotNull byte[] contents) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            return new CreateFileBuilder(this.displayName, this.familyName).file(file).contents(contents);
        }

        @NotNull
        public final CreateFileBuilder deleteFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new CreateFileBuilder(this.displayName, this.familyName).delete(file);
        }

        @NotNull
        public final SetAttributeBuilder set() {
            return new SetAttributeBuilder(this.displayName, this.familyName);
        }

        @NotNull
        public final SetAttributeBuilder unset() {
            return new SetAttributeBuilder(this.displayName, this.familyName).value(null);
        }

        @NotNull
        public final SetAttributeBuilder set(@Nullable String namespace, @NotNull String attribute, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return new SetAttributeBuilder(this.displayName, this.familyName).namespace(namespace).attribute(attribute).value(value);
        }

        @NotNull
        public final SetAttributeBuilder unset(@Nullable String namespace, @NotNull String attribute) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return new SetAttributeBuilder(this.displayName, this.familyName).namespace(namespace).attribute(attribute).value(null);
        }

        @NotNull
        public final FixMapBuilder map() {
            return new FixMapBuilder(this.displayName, this.familyName);
        }

        private final FixMapBuilder map(Object ... args) {
            boolean bl;
            FixMapBuilder builder = this.map();
            Map<String, Object> map2 = builder.getMap$android_sdktools_lint_api();
            boolean bl2 = bl = args.length % 2 == 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            for (int i = 0; i < args.length; i += 2) {
                boolean bl3;
                String key2 = String.valueOf(args[i]);
                Object value = args[i + 1];
                if (value == null) continue;
                Object previous = map2.put(key2, value);
                boolean bl4 = bl3 = previous == null;
                if (!_Assertions.ENABLED || bl3) continue;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return builder;
        }

        @NotNull
        public final LintFix data(Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.map(Arrays.copyOf(args, args.length)).build();
        }

        @NotNull
        public final UrlBuilder url() {
            return new UrlBuilder(this.displayName, this.familyName, null);
        }

        @NotNull
        public final UrlBuilder url(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new UrlBuilder(this.displayName, this.familyName, url);
        }

        @JvmOverloads
        @NotNull
        public final AnnotateBuilder annotate(@NotNull String source, boolean replace) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new AnnotateBuilder(this.displayName, this.familyName, source, replace);
        }

        public static /* synthetic */ AnnotateBuilder annotate$default(Builder builder, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return builder.annotate(string, bl);
        }

        @JvmOverloads
        @NotNull
        public final AnnotateBuilder annotate(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return Builder.annotate$default(this, source, false, 2, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J(\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0007J\"\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0011H\u0007J\"\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0013H\u0007J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J&\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00182\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$Companion;", "", "()V", "TODO", "", "create", "Lcom/android/tools/lint/detector/api/LintFix$Builder;", "extractOffsets", "Lcom/android/tools/lint/detector/api/Location;", "range", "getApiConstraint", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "key", "defaultValue", "getBoolean", "", "getInt", "", "getMethod", "Lcom/intellij/psi/PsiMethod;", "getString", "getStringList", "", "getThrowable", "", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder create() {
            return new Builder();
        }

        @JvmStatic
        @Contract(value="_, _, !null -> !null")
        @Nullable
        public final String getString(@Nullable LintFix fix, @NotNull String key2, @Nullable String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getString(key2, defaultValue) : defaultValue;
        }

        @JvmStatic
        @Nullable
        public final List<String> getStringList(@Nullable LintFix fix, @NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getStringList(key2) : null;
        }

        @JvmStatic
        @Nullable
        public final Throwable getThrowable(@Nullable LintFix fix, @NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getThrowable(key2) : null;
        }

        @JvmStatic
        public final int getInt(@Nullable LintFix fix, @NotNull String key2, int defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getInt(key2, defaultValue) : defaultValue;
        }

        @JvmStatic
        @Contract(value="_, _, !null -> !null")
        @Nullable
        public final ApiConstraint getApiConstraint(@Nullable LintFix fix, @NotNull String key2, @Nullable ApiConstraint defaultValue) {
            ApiConstraint apiConstraint;
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            if (fix instanceof DataMap) {
                apiConstraint = ((DataMap)fix).getApiConstraint(key2);
                if (apiConstraint == null) {
                    apiConstraint = defaultValue;
                }
            } else {
                apiConstraint = defaultValue;
            }
            return apiConstraint;
        }

        public static /* synthetic */ ApiConstraint getApiConstraint$default(Companion companion, LintFix lintFix, String string, ApiConstraint apiConstraint, int n, Object object) {
            if ((n & 4) != 0) {
                apiConstraint = ApiConstraint.UNKNOWN;
            }
            return companion.getApiConstraint(lintFix, string, apiConstraint);
        }

        @JvmStatic
        public final boolean getBoolean(@Nullable LintFix fix, @NotNull String key2, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getBoolean(key2, defaultValue) : defaultValue;
        }

        @JvmStatic
        @Nullable
        public final PsiMethod getMethod(@Nullable LintFix fix, @NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return fix instanceof DataMap ? ((DataMap)fix).getMethod(key2) : null;
        }

        private final Location extractOffsets(Location range) {
            Location location2;
            Position start2 = range.getStart();
            Position end2 = range.getEnd();
            if (start2 != null && end2 != null) {
                location2 = Location.Companion.create(range.getFile(), new DefaultPosition(-1, -1, start2.getOffset()), new DefaultPosition(-1, -1, end2.getOffset()));
            } else {
                DefaultPosition pos = new DefaultPosition(-1, -1, 0);
                location2 = Location.Companion.create(range.getFile(), pos, pos);
            }
            return location2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0000J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\tJ\u001e\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\tJ\u0012\u0010\u0016\u001a\u00020\u00002\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$CreateFileBuilder;", "", "displayName", "", "familyName", "(Ljava/lang/String;Ljava/lang/String;)V", "binary", "", "delete", "", "file", "Ljava/io/File;", "independent", "reformat", "robot", "selectPattern", "text", "autoFix", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "contents", "name", "select", "android.sdktools.lint-api"})
    public static final class CreateFileBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @Nullable
        private String selectPattern;
        private boolean delete;
        @Nullable
        private File file;
        @Nullable
        private byte[] binary;
        @Nullable
        private String text;
        private boolean reformat;
        private boolean robot;
        private boolean independent;

        public CreateFileBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
        }

        @NotNull
        public final CreateFileBuilder name(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        public static /* synthetic */ CreateFileBuilder name$default(CreateFileBuilder createFileBuilder, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            return createFileBuilder.name(string, string2);
        }

        @NotNull
        public final CreateFileBuilder file(@NotNull File file) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            boolean bl2 = bl = this.file == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.file = file;
            return this;
        }

        @NotNull
        public final CreateFileBuilder delete(@NotNull File file) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            boolean bl2 = bl = this.file == null && this.binary == null && this.text == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.file = file;
            this.delete = true;
            return this;
        }

        @NotNull
        public final CreateFileBuilder contents(@NotNull String contents) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            boolean bl2 = bl = this.binary == null && !this.delete;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.text = contents;
            return this;
        }

        @NotNull
        public final CreateFileBuilder contents(@NotNull byte[] contents) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            boolean bl2 = bl = this.text == null && !this.delete;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.binary = contents;
            return this;
        }

        @NotNull
        public final CreateFileBuilder select(@RegExp @Nullable String selectPattern) {
            this.selectPattern = selectPattern;
            return this;
        }

        @NotNull
        public final CreateFileBuilder reformat(boolean reformat) {
            this.reformat = reformat;
            return this;
        }

        @NotNull
        public final CreateFileBuilder robot(boolean robot) {
            this.robot = robot;
            return this;
        }

        @NotNull
        public final CreateFileBuilder independent(boolean independent) {
            this.independent = independent;
            return this;
        }

        @NotNull
        public final CreateFileBuilder autoFix(boolean robot, boolean independent) {
            this.robot(robot);
            this.independent(independent);
            return this;
        }

        @NotNull
        public final CreateFileBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final LintFix build() {
            File file = this.file;
            Intrinsics.checkNotNull((Object)file);
            return new CreateFileFix(this.displayName, this.familyName, this.selectPattern, this.delete, file, this.binary, this.text, this.reformat, this.robot, this.independent);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0011\u0018\u00002\u00020\u0001B_\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$CreateFileFix;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "selectPattern", "delete", "", "file", "Ljava/io/File;", "binary", "", "text", "reformat", "robot", "independent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/io/File;[BLjava/lang/String;ZZZ)V", "getBinary", "()[B", "getDelete", "()Z", "getFile", "()Ljava/io/File;", "getReformat", "getSelectPattern", "()Ljava/lang/String;", "getText", "getDisplayName", "android.sdktools.lint-api"})
    public static final class CreateFileFix
    extends LintFix {
        @Nullable
        private final String selectPattern;
        private final boolean delete;
        @NotNull
        private final File file;
        @Nullable
        private final byte[] binary;
        @Nullable
        private final String text;
        private final boolean reformat;

        public CreateFileFix(@Nullable String displayName, @Nullable String familyName, @Nullable String selectPattern, boolean delete, @NotNull File file, @Nullable byte[] binary, @Nullable String text, boolean reformat, boolean robot, boolean independent) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(displayName, familyName, Location.Companion.create(file));
            this.selectPattern = selectPattern;
            this.delete = delete;
            this.file = file;
            this.binary = binary;
            this.text = text;
            this.reformat = reformat;
            this.robot = robot;
            this.independent = independent;
        }

        @Nullable
        public final String getSelectPattern() {
            return this.selectPattern;
        }

        public final boolean getDelete() {
            return this.delete;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @Nullable
        public final byte[] getBinary() {
            return this.binary;
        }

        @Nullable
        public final String getText() {
            return this.text;
        }

        public final boolean getReformat() {
            return this.reformat;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = super.getDisplayName();
            if (string == null) {
                return this.delete ? "Delete " + this.file.getName() : "Create " + this.file.getName();
            }
            return string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0003J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000eJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0011H\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u0003J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0007J\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0003J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dJ\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$DataMap;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "map", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "get", "key", "getApiConstraint", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "getBoolean", "", "defaultValue", "getFile", "Ljava/io/File;", "getInt", "", "getMethod", "Lcom/intellij/psi/PsiMethod;", "getString", "getStringList", "", "getThrowable", "", "hasKey", "keys", "", "toString", "android.sdktools.lint-api"})
    public static final class DataMap
    extends LintFix {
        @NotNull
        private final Map<String, Object> map;

        public DataMap(@Nullable String displayName, @Nullable String familyName, @NotNull Map<String, ? extends Object> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            super(displayName, familyName, null, 4, null);
            this.map = map2;
        }

        public final boolean hasKey(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return this.map.containsKey(key2);
        }

        @Nullable
        public final Object get(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return this.map.get(key2);
        }

        @NotNull
        public final Set<String> keys() {
            return this.map.keySet();
        }

        @NotNull
        public String toString() {
            return this.map.toString();
        }

        @Contract(value="_, !null -> !null")
        @Nullable
        public final String getString(@NotNull String key2, @Nullable String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object value = this.map.get(key2);
            Object object = value;
            if (object == null || (object = object.toString()) == null) {
                object = defaultValue;
            }
            return object;
        }

        @Nullable
        public final List<String> getStringList(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object value = this.map.get(key2);
            if (value instanceof List) {
                return (List)value;
            }
            if (value instanceof String) {
                return Splitter.on((String)",").splitToList((CharSequence)value);
            }
            return null;
        }

        @Contract(value="_, !null -> !null")
        @Nullable
        public final File getFile(@NotNull String key2, @Nullable File defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object value = this.map.get(key2);
            if (value != null) {
                if (value instanceof File) {
                    return (File)value;
                }
                if (value instanceof String) {
                    return new File((String)value);
                }
            }
            return defaultValue;
        }

        public final int getInt(@NotNull String key2, int defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object value = this.map.get(key2);
            if (value != null) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof String) {
                    try {
                        return Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return defaultValue;
        }

        public final boolean getBoolean(@NotNull String key2, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object value = this.map.get(key2);
            if (value != null) {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                if (value instanceof String) {
                    return Intrinsics.areEqual((Object)"true", (Object)value);
                }
            }
            return defaultValue;
        }

        @Nullable
        public final PsiMethod getMethod(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object value = this.map.get(key2);
            return value instanceof PsiMethod ? (PsiMethod)value : null;
        }

        @Nullable
        public final Throwable getThrowable(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object value = this.map.get(key2);
            return value instanceof Throwable ? (Throwable)value : null;
        }

        @Nullable
        public final ApiConstraint getApiConstraint(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Object value = this.map.get(key2);
            if (value instanceof ApiConstraint) {
                return (ApiConstraint)value;
            }
            if (value instanceof String) {
                return ApiConstraint.Companion.deserialize((String)value);
            }
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0010J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0011J\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003J\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0014R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$FixMapBuilder;", "", "displayName", "", "familyName", "(Ljava/lang/String;Ljava/lang/String;)V", "map", "", "getMap$android_sdktools_lint_api", "()Ljava/util/Map;", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "put", "key", "value", "Lcom/intellij/psi/PsiMethod;", "", "", "throwable", "", "", "android.sdktools.lint-api"})
    public static final class FixMapBuilder {
        @Nls
        @Nullable
        private final String displayName;
        @Nls
        @Nullable
        private final String familyName;
        @NotNull
        private final Map<String, Object> map;

        public FixMapBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)4);
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(4)");
            this.map = hashMap;
        }

        @NotNull
        public final Map<String, Object> getMap$android_sdktools_lint_api() {
            return this.map;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key2, @Nullable String value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            if (value == null) {
                return this;
            }
            boolean bl2 = bl = !this.map.containsKey(key2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.map.put(key2, value);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key2, @Nullable PsiMethod value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            if (value == null) {
                return this;
            }
            boolean bl2 = bl = !this.map.containsKey(key2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.map.put(key2, value);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key2, @Nullable Throwable throwable) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            if (throwable == null) {
                return this;
            }
            boolean bl2 = bl = !this.map.containsKey(key2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.map.put(key2, throwable);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key2, int value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            boolean bl2 = bl = !this.map.containsKey(key2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Integer n = value;
            this.map.put(key2, n);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key2, boolean value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            boolean bl2 = bl = !this.map.containsKey(key2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Boolean bl3 = value;
            this.map.put(key2, bl3);
            return this;
        }

        @NotNull
        public final FixMapBuilder put(@NotNull String key2, @NotNull List<String> value) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            boolean bl2 = bl = !this.map.containsKey(key2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.map.put(key2, value);
            return this;
        }

        @NotNull
        public final LintFix build() {
            return new DataMap(this.displayName, this.familyName, this.map);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\u001f\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\b\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$GroupBuilder;", "", "displayName", "", "familyName", "(Ljava/lang/String;Ljava/lang/String;)V", "list", "", "Lcom/android/tools/lint/detector/api/LintFix;", "type", "Lcom/android/tools/lint/detector/api/LintFix$GroupType;", "add", "fix", "build", "join", "fixes", "", "([Lcom/android/tools/lint/detector/api/LintFix;)Lcom/android/tools/lint/detector/api/LintFix$GroupBuilder;", "name", "sharedName", "android.sdktools.lint-api"})
    public static final class GroupBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @NotNull
        private GroupType type;
        @NotNull
        private final List<LintFix> list;

        public GroupBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            this.type = GroupType.ALTERNATIVES;
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)4);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayListWithExpectedSize(4)");
            this.list = arrayList;
        }

        @NotNull
        public final GroupBuilder name(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @NotNull
        public final GroupBuilder name(@NotNull String displayName, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final GroupBuilder sharedName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final GroupBuilder join(LintFix ... fixes) {
            Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
            this.list.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(fixes, fixes.length)));
            return this;
        }

        @NotNull
        public final GroupBuilder add(@NotNull LintFix fix) {
            Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
            this.list.add(fix);
            return this;
        }

        @NotNull
        public final GroupBuilder type(@NotNull GroupType type2) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            this.type = type2;
            return this;
        }

        @NotNull
        public final LintFix build() {
            boolean bl;
            boolean bl2 = bl = !((Collection)this.list).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return new LintFixGroup(this.displayName, this.familyName, this.type, this.list);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$GroupType;", "", "(Ljava/lang/String;I)V", "COMPOSITE", "ALTERNATIVES", "android.sdktools.lint-api"})
    public static final class GroupType
    extends Enum<GroupType> {
        public static final /* enum */ GroupType COMPOSITE = new GroupType();
        public static final /* enum */ GroupType ALTERNATIVES = new GroupType();
        private static final /* synthetic */ GroupType[] $VALUES;

        public static GroupType[] values() {
            return (GroupType[])$VALUES.clone();
        }

        public static GroupType valueOf(String value) {
            return Enum.valueOf(GroupType.class, value);
        }

        static {
            $VALUES = groupTypeArray = new GroupType[]{GroupType.COMPOSITE, GroupType.ALTERNATIVES};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$LintFixGroup;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "type", "Lcom/android/tools/lint/detector/api/LintFix$GroupType;", "fixes", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/LintFix$GroupType;Ljava/util/List;)V", "getFixes", "()Ljava/util/List;", "value", "Lcom/android/tools/lint/detector/api/Location;", "range", "getRange", "()Lcom/android/tools/lint/detector/api/Location;", "setRange", "(Lcom/android/tools/lint/detector/api/Location;)V", "getType", "()Lcom/android/tools/lint/detector/api/LintFix$GroupType;", "autoFix", "robot", "", "independent", "getDisplayName", "android.sdktools.lint-api"})
    public static final class LintFixGroup
    extends LintFix {
        @NotNull
        private final GroupType type;
        @NotNull
        private final List<LintFix> fixes;
        @Nullable
        private Location range;

        public LintFixGroup(@Nullable String displayName, @Nullable String familyName, @NotNull GroupType type2, @NotNull List<? extends LintFix> fixes) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            super(displayName, familyName, null, 4, null);
            this.type = type2;
            this.fixes = fixes;
        }

        @NotNull
        public final GroupType getType() {
            return this.type;
        }

        @NotNull
        public final List<LintFix> getFixes() {
            return this.fixes;
        }

        @Override
        @Nullable
        public Location getRange() {
            return this.range;
        }

        @Override
        public void setRange(@Nullable Location value) {
            this.range = value;
            throw new IllegalStateException("Groups can't define an error range; should be set on each member".toString());
        }

        @Override
        @Nls
        @Nullable
        public String getDisplayName() {
            String displayName = super.getDisplayName();
            if (displayName == null && this.type == GroupType.COMPOSITE) {
                for (LintFix fix : this.fixes) {
                    String name = fix.displayName;
                    if (name == null) continue;
                    return name;
                }
            }
            return displayName;
        }

        @Override
        @NotNull
        public LintFix autoFix(boolean robot, boolean independent) {
            for (LintFix fix : this.fixes) {
                fix.autoFix(robot, independent);
            }
            return super.autoFix(robot, independent);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!By\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0003H\u0016R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "oldString", "oldPattern", "selectPattern", "replacement", "shortenNames", "", "reformat", "imports", "", "range", "Lcom/android/tools/lint/detector/api/Location;", "robot", "independent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLjava/util/List;Lcom/android/tools/lint/detector/api/Location;ZZ)V", "getImports", "()Ljava/util/List;", "getOldPattern", "()Ljava/lang/String;", "getOldString", "getReformat", "()Z", "getReplacement", "getSelectPattern", "getShortenNames", "expandBackReferences", "matcher", "Ljava/util/regex/Matcher;", "getDisplayName", "Companion", "android.sdktools.lint-api"})
    public static final class ReplaceString
    extends LintFix {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String oldString;
        @Nullable
        private final String oldPattern;
        @Nullable
        private final String selectPattern;
        @NotNull
        private final String replacement;
        private final boolean shortenNames;
        private final boolean reformat;
        @NotNull
        private final List<String> imports;
        @NotNull
        public static final String INSERT_BEGINNING = "_lint_insert_begin_";
        @NotNull
        public static final String INSERT_END = "_lint_insert_end_";

        public ReplaceString(@Nullable String displayName, @Nullable String familyName, @Nullable String oldString, @RegExp @Nullable String oldPattern, @Nullable String selectPattern, @NotNull String replacement, boolean shortenNames, boolean reformat, @NotNull List<String> imports, @Nullable Location range, boolean robot, boolean independent) {
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            Intrinsics.checkNotNullParameter(imports, (String)"imports");
            super(displayName, familyName, range);
            this.oldString = oldString;
            this.oldPattern = oldPattern;
            this.selectPattern = selectPattern;
            this.replacement = replacement;
            this.shortenNames = shortenNames;
            this.reformat = reformat;
            this.imports = imports;
            this.robot = robot;
            this.independent = independent;
        }

        @Nullable
        public final String getOldString() {
            return this.oldString;
        }

        @Nullable
        public final String getOldPattern() {
            return this.oldPattern;
        }

        @Nullable
        public final String getSelectPattern() {
            return this.selectPattern;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        public final boolean getShortenNames() {
            return this.shortenNames;
        }

        public final boolean getReformat() {
            return this.reformat;
        }

        @NotNull
        public final List<String> getImports() {
            return this.imports;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            Object object;
            String displayName = super.getDisplayName();
            if (displayName != null) {
                object = displayName;
            } else {
                if (((CharSequence)this.replacement).length() == 0) {
                    return this.oldString != null ? "Delete \"" + this.oldString + "\"" : "Delete";
                }
                Object preview = this.replacement;
                int lineIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)preview), (char)'\n', (int)0, (boolean)false, (int)6, null);
                if (lineIndex != -1) {
                    String string = ((String)preview).substring(0, lineIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    preview = string + "...";
                }
                object = "Replace with " + (String)preview;
            }
            return object;
        }

        @NotNull
        public final String expandBackReferences(@NotNull Matcher matcher) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            return Companion.expandBackReferences(this.replacement, matcher);
        }

        @JvmStatic
        @NotNull
        public static final String expandBackReferences(@NotNull String replacement, @NotNull Matcher matcher) {
            return Companion.expandBackReferences(replacement, matcher);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$ReplaceString$Companion;", "", "()V", "INSERT_BEGINNING", "", "INSERT_END", "expandBackReferences", "replacement", "matcher", "Ljava/util/regex/Matcher;", "android.sdktools.lint-api"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final String expandBackReferences(@NotNull String replacement, @NotNull Matcher matcher) {
                Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
                Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                if (!StringsKt.contains$default((CharSequence)replacement, (CharSequence)"\\k<", (boolean)false, (int)2, null)) {
                    return replacement;
                }
                StringBuilder sb = new StringBuilder();
                int begin = 0;
                while (true) {
                    int end2;
                    if ((end2 = StringsKt.indexOf$default((CharSequence)replacement, (String)"\\k<", (int)begin, (boolean)false, (int)4, null)) == -1) break;
                    int next = StringsKt.indexOf$default((CharSequence)replacement, (char)'>', (int)(end2 + 3), (boolean)false, (int)4, null);
                    if (next != -1 && Character.isDigit(replacement.charAt(end2 + 3))) {
                        String groupString;
                        sb.append(replacement, begin, end2);
                        Intrinsics.checkNotNullExpressionValue((Object)replacement.substring(end2 + 3, next), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        int group = Integer.parseInt(groupString);
                        if (group > matcher.groupCount()) {
                            throw new IllegalStateException(("Invalid backreference " + group + " in `" + replacement + "`: there are only " + matcher.groupCount() + " matches in this matcher, " + matcher).toString());
                        }
                        sb.append(matcher.group(group));
                        begin = next + 1;
                        continue;
                    }
                    sb.append(replacement, begin, end2 += 3);
                    begin = end2;
                }
                String string = replacement.substring(begin);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                sb.append(string);
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
                return string2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0000J\u001f\u0010\u0006\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0019\"\u00020\u0003\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\u001c\u001a\u00020\u00002\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\tJ\u0012\u0010\u001d\u001a\u00020\u00002\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\tJ\u0010\u0010 \u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u0010\u0010!\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0003R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/detector/api/LintFix$ReplaceStringBuilder;", "", "displayName", "", "familyName", "(Ljava/lang/String;Ljava/lang/String;)V", "imports", "", "independent", "", "newText", "oldPattern", "oldText", "range", "Lcom/android/tools/lint/detector/api/Location;", "reformat", "robot", "selectPattern", "shortenNames", "all", "autoFix", "beginning", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "end", "", "([Ljava/lang/String;)Lcom/android/tools/lint/detector/api/LintFix$ReplaceStringBuilder;", "name", "pattern", "select", "sharedName", "shorten", "text", "with", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$ReplaceStringBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1855:1\n1#2:1856\n*E\n"})
    public static final class ReplaceStringBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @Nullable
        private String newText;
        @Nullable
        private String oldText;
        @Nullable
        private String selectPattern;
        private boolean shortenNames;
        private boolean reformat;
        private boolean robot;
        private boolean independent;
        @Nullable
        private List<String> imports;
        @RegExp
        @Nullable
        private String oldPattern;
        @Nullable
        private Location range;

        public ReplaceStringBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
        }

        @NotNull
        public final ReplaceStringBuilder name(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder name(@NotNull String displayName, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder sharedName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder pattern(@RegExp @Nullable String oldPattern) {
            boolean bl;
            if (oldPattern == null) {
                this.oldPattern = null;
                return this;
            }
            boolean bl2 = bl = this.oldText == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = this.oldPattern == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.oldPattern = StringsKt.indexOf$default((CharSequence)oldPattern, (char)'(', (int)0, (boolean)false, (int)6, null) == -1 ? "(" + oldPattern + ")" : oldPattern;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder text(@Nullable String oldText) {
            boolean bl;
            if (oldText == null) {
                this.oldText = null;
                return this;
            }
            boolean bl2 = bl = this.oldText == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Should not call text, beginning or end more than once";
                throw new AssertionError((Object)string);
            }
            boolean bl4 = bl = this.oldPattern == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.oldText = oldText;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder range(@NotNull Location range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = Companion.extractOffsets(range);
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder all() {
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder beginning() {
            this.oldText = "_lint_insert_begin_";
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder end() {
            this.oldText = "_lint_insert_end_";
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder select(@RegExp @Nullable String selectPattern) {
            this.selectPattern = selectPattern;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder with(@Nullable String newText) {
            boolean bl;
            boolean bl2 = bl = this.newText == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.newText = newText;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder imports(String ... imports) {
            Intrinsics.checkNotNullParameter((Object)imports, (String)"imports");
            List list2 = this.imports;
            if (list2 == null) {
                List list3;
                List it = list3 = (List)new ArrayList();
                boolean bl = false;
                this.imports = it;
                list2 = list3;
            }
            List existing = list2;
            CollectionsKt.addAll((Collection)existing, (Object[])imports);
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder shortenNames() {
            this.shortenNames = true;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder shortenNames(boolean shorten) {
            this.shortenNames = shorten;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder reformat(boolean reformat) {
            this.reformat = reformat;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder robot(boolean robot) {
            this.robot = robot;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder independent(boolean independent) {
            this.independent = independent;
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder autoFix(boolean robot, boolean independent) {
            this.robot(robot);
            this.independent(independent);
            return this;
        }

        @NotNull
        public final ReplaceStringBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final LintFix build() {
            List list2;
            String string = this.newText;
            if (string == null) {
                string = "";
            }
            if ((list2 = this.imports) == null) {
                list2 = CollectionsKt.emptyList();
            }
            return new ReplaceString(this.displayName, this.familyName, this.oldText, this.oldPattern, this.selectPattern, string, this.shortenNames, this.reformat, list2, this.range, this.robot, this.independent);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B_\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$SetAttribute;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "namespace", "attribute", "value", "range", "Lcom/android/tools/lint/detector/api/Location;", "dot", "", "mark", "robot", "", "independent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;IIZZ)V", "getAttribute", "()Ljava/lang/String;", "getDot", "()I", "getMark", "getNamespace", "getValue", "getDisplayName", "android.sdktools.lint-api"})
    public static final class SetAttribute
    extends LintFix {
        @Nullable
        private final String namespace;
        @NotNull
        private final String attribute;
        @Nullable
        private final String value;
        private final int dot;
        private final int mark;

        public SetAttribute(@Nullable String displayName, @Nullable String familyName, @Nullable String namespace, @NotNull String attribute, @Nullable String value, @Nullable Location range, int dot, int mark, boolean robot, boolean independent) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            super(displayName, familyName, range);
            this.namespace = namespace;
            this.attribute = attribute;
            this.value = value;
            this.dot = dot;
            this.mark = mark;
            this.robot = robot;
            this.independent = independent;
        }

        @Nullable
        public final String getNamespace() {
            return this.namespace;
        }

        @NotNull
        public final String getAttribute() {
            return this.attribute;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        public final int getDot() {
            return this.dot;
        }

        public final int getMark() {
            return this.mark;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            Object object = super.getDisplayName();
            if (object == null) {
                object = this.value != null ? (((CharSequence)this.value).length() == 0 || this.dot > 0 ? "Set " + this.attribute : "Set " + this.attribute + "=\"" + this.value + "\"") : "Delete " + this.attribute;
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0000J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bJ\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nJ\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bJ\u0006\u0010\u001e\u001a\u00020\u0000J\u0010\u0010\u001f\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J2\u0010 \u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0007J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$SetAttributeBuilder;", "", "displayName", "", "familyName", "(Ljava/lang/String;Ljava/lang/String;)V", "attribute", "dot", "", "independent", "", "mark", "namespace", "range", "Lcom/android/tools/lint/detector/api/Location;", "robot", "value", "android", "autoFix", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "caret", "valueStartDelta", "caretBegin", "caretEnd", "name", "remove", "select", "start", "end", "selectAll", "sharedName", "todo", "prefix", "suffix", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFix.kt\ncom/android/tools/lint/detector/api/LintFix$SetAttributeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1855:1\n1#2:1856\n*E\n"})
    public static final class SetAttributeBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @Nullable
        private String attribute;
        @Nullable
        private String namespace;
        @Nullable
        private String value;
        private int mark;
        private int dot;
        private boolean robot;
        private boolean independent;
        @Nullable
        private Location range;

        public SetAttributeBuilder(@Nullable String displayName, @Nullable String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            this.value = "";
            this.mark = Integer.MIN_VALUE;
            this.dot = Integer.MIN_VALUE;
        }

        @NotNull
        public final SetAttributeBuilder name(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder name(@NotNull String displayName, @NotNull String familyName) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder sharedName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder android() {
            boolean bl;
            boolean bl2 = bl = this.namespace == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.namespace = "http://schemas.android.com/apk/res/android";
            return this;
        }

        @NotNull
        public final SetAttributeBuilder namespace(@Nullable String namespace) {
            boolean bl;
            boolean bl2 = bl = this.namespace == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.namespace = namespace;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder value(@Nullable String value) {
            this.value = value;
            if (value != null && ((CharSequence)value).length() == 0) {
                this.caret(0);
            }
            return this;
        }

        @NotNull
        public final SetAttributeBuilder attribute(@NotNull String attribute) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            boolean bl2 = bl = StringsKt.indexOf$default((CharSequence)attribute, (char)':', (int)0, (boolean)false, (int)6, null) == -1 || StringsKt.startsWith$default((String)attribute, (String)"xmlns:", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = attribute;
                throw new AssertionError((Object)string);
            }
            boolean bl4 = bl = this.attribute == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.attribute = attribute;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder remove(@NotNull String attribute) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            boolean bl2 = bl = this.attribute == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.attribute = attribute;
            this.value = null;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder selectAll() {
            String string = this.value;
            Intrinsics.checkNotNull((Object)string);
            this.dot = string.length();
            this.mark = 0;
            return this;
        }

        @JvmOverloads
        @NotNull
        public final SetAttributeBuilder todo(@Nullable String namespace, @NotNull String attribute, @Nullable String prefix, @Nullable String suffix) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            this.namespace(namespace);
            this.attribute(attribute);
            StringBuilder sb = new StringBuilder();
            if (prefix != null) {
                sb.append(prefix);
            }
            int start2 = sb.length();
            sb.append(LintFix.TODO);
            int end2 = sb.length();
            if (suffix != null) {
                sb.append(suffix);
            }
            this.value(sb.toString());
            this.select(start2, end2);
            return this;
        }

        public static /* synthetic */ SetAttributeBuilder todo$default(SetAttributeBuilder setAttributeBuilder, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            return setAttributeBuilder.todo(string, string2, string3, string4);
        }

        @NotNull
        public final SetAttributeBuilder range(@Nullable Location range) {
            Location location2 = range;
            this.range = location2 != null ? Companion.extractOffsets(location2) : null;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder select(int start2, int end2) {
            this.mark = Math.min(start2, end2);
            this.dot = Math.max(start2, end2);
            return this;
        }

        @NotNull
        public final SetAttributeBuilder caret(int valueStartDelta) {
            this.mark = this.dot = valueStartDelta;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder caretBegin() {
            return this.caret(0);
        }

        @NotNull
        public final SetAttributeBuilder caretEnd() {
            boolean bl;
            boolean bl2 = bl = this.value != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String string = this.value;
            Intrinsics.checkNotNull((Object)string);
            return this.caret(string.length());
        }

        @NotNull
        public final SetAttributeBuilder robot(boolean robot) {
            this.robot = robot;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder independent(boolean independent) {
            this.independent = independent;
            return this;
        }

        @NotNull
        public final SetAttributeBuilder autoFix(boolean robot, boolean independent) {
            this.robot(robot);
            this.independent(independent);
            return this;
        }

        @NotNull
        public final SetAttributeBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        @NotNull
        public final LintFix build() {
            String string = this.attribute;
            Intrinsics.checkNotNull((Object)string);
            return new SetAttribute(this.displayName, this.familyName, this.namespace, string, this.value, this.range, this.dot, this.mark, this.robot, this.independent);
        }

        @JvmOverloads
        @NotNull
        public final SetAttributeBuilder todo(@Nullable String namespace, @NotNull String attribute, @Nullable String prefix) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return SetAttributeBuilder.todo$default(this, namespace, attribute, prefix, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final SetAttributeBuilder todo(@Nullable String namespace, @NotNull String attribute) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return SetAttributeBuilder.todo$default(this, namespace, attribute, null, null, 12, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$ShowUrl;", "Lcom/android/tools/lint/detector/api/LintFix;", "displayName", "", "familyName", "url", "onUrlOpen", "Lkotlin/Function0;", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getOnUrlOpen", "()Lkotlin/jvm/functions/Function0;", "getUrl", "()Ljava/lang/String;", "android.sdktools.lint-api"})
    public static final class ShowUrl
    extends LintFix {
        @NotNull
        private final String url;
        @Nullable
        private final Function0<Unit> onUrlOpen;

        public ShowUrl(@Nullable String displayName, @Nullable String familyName, @NotNull String url, @Nullable Function0<Unit> onUrlOpen) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(displayName, familyName, null, 4, null);
            this.url = url;
            this.onUrlOpen = onUrlOpen;
        }

        public /* synthetic */ ShowUrl(String string, String string2, String string3, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                function0 = null;
            }
            this(string, string2, string3, (Function0<Unit>)function0);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final Function0<Unit> getOnUrlOpen() {
            return this.onUrlOpen;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0005\u001a\u00020\u00002\b\b\u0001\u0010\u0005\u001a\u00020\u0003R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/detector/api/LintFix$UrlBuilder;", "", "displayName", "", "familyName", "url", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "build", "Lcom/android/tools/lint/detector/api/LintFix;", "android.sdktools.lint-api"})
    public static final class UrlBuilder {
        @Nls
        @Nullable
        private String displayName;
        @Nls
        @Nullable
        private String familyName;
        @NonNls
        @Nullable
        private String url;

        public UrlBuilder(@Nullable String displayName, @Nullable String familyName, @Nullable String url) {
            this.displayName = displayName;
            this.familyName = familyName;
            this.url = url;
        }

        @NotNull
        public final UrlBuilder url(@NonNls @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            return this;
        }

        @NotNull
        public final LintFix build() {
            String string = this.url;
            Intrinsics.checkNotNull((Object)string);
            return new ShowUrl(this.displayName, this.familyName, string, null, 8, null);
        }
    }
}

