/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UnusedResourceDetector$afterCheckRootProject$;
import com.android.tools.lint.checks.UnusedResourceDetectorKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelResourceField;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0003BCDB\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u000f\u001a\u00020&H\u0016J\u0016\u0010'\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020*0)0(H\u0016J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u00100\u001a\u00020\u000e2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u00104\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J0\u00108\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020&2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\fH\u0016J\u0016\u0010?\u001a\u00020\u000e2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000e0AH\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E\u00b2\u0006\f\u0010F\u001a\u0004\u0018\u00010GX\u008a\u0084\u0002"}, d2={"Lcom/android/tools/lint/checks/UnusedResourceDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/BinaryResourceScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "bindingClasses", "", "", "model", "Lcom/android/tools/lint/checks/UnusedResourceDetector$UnusedResourceDetectorUsageModel;", "projectUsesViewBinding", "", "addDynamicResources", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "project", "Lcom/android/tools/lint/detector/api/Project;", "resValues", "", "Lcom/android/tools/lint/model/LintModelResourceField;", "addInactiveReferences", "active", "Lcom/android/tools/lint/model/LintModelVariant;", "afterCheckRootProject", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "appliesToResourceRefs", "beforeCheckEachProject", "checkBinaryResource", "Lcom/android/tools/lint/detector/api/ResourceContext;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UAnnotated;", "recordInactiveJavaReferences", "resDir", "Ljava/io/File;", "recordInactiveXmlResources", "folder", "recordManifestPlaceHolderUsages", "manifestPlaceholders", "storeSerializedModel", "Lcom/android/tools/lint/detector/api/LintMap;", "visitDocument", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "visitResourceReference", "node", "Lorg/jetbrains/uast/UElement;", "type", "Lcom/android/resources/ResourceType;", "name", "isFramework", "withParsingErrorTolerated", "run", "Lkotlin/Function0;", "Companion", "LintResource", "UnusedResourceDetectorUsageModel", "android.sdktools.lint-checks", "defaultLocation", "Lcom/android/tools/lint/detector/api/Location;"})
@SourceDebugExtension(value={"SMAP\nUnusedResourceDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedResourceDetector.kt\ncom/android/tools/lint/checks/UnusedResourceDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,712:1\n2259#2,5:713\n2265#2:719\n473#2:720\n1291#2:721\n603#2:722\n1291#2,2:723\n1292#2:725\n1291#2,2:726\n1291#2,2:728\n1#3:718\n*S KotlinDebug\n*F\n+ 1 UnusedResourceDetector.kt\ncom/android/tools/lint/checks/UnusedResourceDetector\n*L\n157#1:713,5\n157#1:719\n213#1:720\n219#1:721\n229#1:722\n234#1:723,2\n219#1:725\n274#1:726,2\n335#1:728,2\n*E\n"})
public final class UnusedResourceDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
BinaryResourceScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnusedResourceDetectorUsageModel model = new UnusedResourceDetectorUsageModel();
    private boolean projectUsesViewBinding;
    @Nullable
    private Map<String, String> bindingClasses;
    @NotNull
    public static final String KEY_RESOURCE_FIELD = "field";
    @NotNull
    private static final String KEY_MODEL = "model";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @NotNull
    private static final String EXCLUDE_TESTS_PROPERTY = "lint.unused-resources.exclude-tests";
    @NotNull
    private static final String INCLUDE_TESTS_PROPERTY = "lint.unused-resources.include-tests";
    @NotNull
    private static final String EXCLUDING_TESTS_EXPLANATION = "\n                The unused resource check can ignore tests. If you want to include \\\n                resources that are only referenced from tests, consider packaging them \\\n                in a test source set instead.\n\n                You can include test sources in the unused resource check by setting \\\n                the system property \\\n                lint.unused-resources.include-tests \\\n                =true, and to \\\n                exclude them (usually for performance reasons), use \\\n                lint.unused-resources.exclude-tests \\\n                =true.\n                ";
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @JvmField
    @NotNull
    public static final Issue ISSUE_IDS;
    @JvmField
    public static boolean sIncludeInactiveReferences;

    private final void addDynamicResources(Context context2) {
        Project project = context2.getProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            this.recordManifestPlaceHolderUsages(variant.getManifestPlaceholders());
            this.addDynamicResources(project, variant.getResValues());
        }
    }

    private final void recordManifestPlaceHolderUsages(Map<String, String> manifestPlaceholders) {
        for (String value : manifestPlaceholders.values()) {
            ResourceUsageModel.markReachable((ResourceUsageModel.Resource)this.model.getResourceFromUrl(value));
        }
    }

    private final void addDynamicResources(Project project, Map<String, ? extends LintModelResourceField> resValues) {
        Collection<? extends LintModelResourceField> resFields = resValues.values();
        if (!resFields.isEmpty()) {
            Location location2 = Lint.guessGradleLocation(project);
            for (LintModelResourceField lintModelResourceField : resFields) {
                ResourceType resourceType = ResourceType.fromClassName((String)lintModelResourceField.getType());
                if (resourceType == null) continue;
                ResourceType type2 = resourceType;
                ResourceUsageModel.Resource resource = this.model.declareResource(type2, lintModelResourceField.getName(), null);
                Intrinsics.checkNotNull((Object)resource, (String)"null cannot be cast to non-null type com.android.tools.lint.checks.UnusedResourceDetector.LintResource");
                LintResource resource2 = (LintResource)resource;
                resource2.recordLocation(location2);
            }
        }
    }

    @Override
    public void beforeCheckEachProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = context2.getProject().getBuildVariant();
        this.projectUsesViewBinding = object != null && (object = object.getBuildFeatures()) != null ? object.getViewBinding() : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        Object v0;
        void $this$reduceOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        if (context2.getProject().isLibrary()) {
            return;
        }
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)partialResults), (Function1)checkPartialResults.model.1.INSTANCE);
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void model2;
                ResourceUsageModel resourceUsageModel = (ResourceUsageModel)iterator$iv.next();
                ResourceUsageModel acc = (ResourceUsageModel)accumulator$iv;
                boolean bl = false;
                Object object3 = acc;
                ResourceUsageModel $this$checkPartialResults_u24lambda_u241_u24lambda_u240 = object3;
                boolean bl2 = false;
                $this$checkPartialResults_u24lambda_u241_u24lambda_u240.merge((ResourceUsageModel)model2);
                accumulator$iv = object3;
            }
            v0 = accumulator$iv;
        }
        ResourceUsageModel resourceUsageModel = v0;
        if (resourceUsageModel == null) {
            return;
        }
        ResourceUsageModel model3 = resourceUsageModel;
        for (ResourceUsageModel.Resource resource : UnusedResourceDetector.Companion.findUnused(context2, model3)) {
            Object object;
            Object object2;
            String message2;
            String field;
            block11: {
                field = resource.getField();
                message2 = "The resource `" + field + "` appears to be unused";
                for (Object object3 : (Iterable)partialResults) {
                    boolean bl = false;
                    LintMap lintMap = (LintMap)object3.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)field, (String)KEY_RESOURCE_FIELD);
                    object3 = lintMap.getLocation(field);
                    if (object3 == null) continue;
                    object2 = object3;
                    break block11;
                }
                object2 = object = null;
            }
            if (object2 == null) {
                Object object4;
                Object object5 = resource.declarations;
                if (object5 != null && (object5 = (Path)CollectionsKt.first((List)object5)) != null && (object5 = object5.toFile()) != null) {
                    Object object6 = object5;
                    Location.Companion companion = Location.Companion;
                    Object p0 = object6;
                    boolean bl = false;
                    object4 = companion.create((File)p0);
                } else {
                    object4 = object = null;
                }
                if (object4 == null) {
                    File file = context2.getProject().getDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.project.dir");
                    object = Location.Companion.create(file);
                }
            }
            Object location2 = object;
            Object[] objectArray = new Object[]{KEY_RESOURCE_FIELD, field};
            LintFix fix = this.fix().data(objectArray);
            context2.report(new Incident(UnusedResourceDetector.Companion.getIssue(resource), (Location)location2, message2, fix));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        switch (context2.getPhase()) {
            case 1: {
                Project project = context2.getProject();
                if (sIncludeInactiveReferences && !project.isLibrary() && LintClient.Companion.isStudio()) {
                    LintModelVariant lintModelVariant = project.getBuildVariant();
                    if (lintModelVariant != null) {
                        LintModelVariant p0 = lintModelVariant;
                        boolean bl = false;
                        this.addInactiveReferences(p0);
                    }
                }
                this.addDynamicResources(context2);
                Set unused = SequencesKt.toSet((Sequence)UnusedResourceDetector.Companion.findUnused(context2, this.model));
                if (!((Collection)unused).isEmpty()) {
                    this.model.setUnused(unused);
                    context2.requestRepeat(this, Scope.ALL_RESOURCES_SCOPE);
                    break;
                }
                if (context2.isGlobalAnalysis()) break;
                this.storeSerializedModel(context2);
                break;
            }
            case 2: {
                void $this$forEach$iv;
                Function2 function2;
                LintMap lintMap;
                if (!(!((Collection)this.model.getUnused()).isEmpty())) break;
                List unused = this.model.findUnused(CollectionsKt.toList((Iterable)this.model.getUnused()));
                Intrinsics.checkNotNullExpressionValue((Object)unused, (String)"unused");
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)unused);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)afterCheckRootProject$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)sequence, (Function1)afterCheckRootProject.2.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Sequence files2;
                    void $this$sortedBy$iv;
                    LintResource resource = (LintResource)((Object)element$iv);
                    boolean bl = false;
                    ResourceType type2 = resource.type;
                    String name = resource.name;
                    List<File> list2 = context2.getProject().getResourceFolders();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"context.project.resourceFolders");
                    Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)afterCheckRootProject.3.folders.1.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(type2){
                        final /* synthetic */ ResourceType $type;
                        {
                            this.$type = $type;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull File it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            String string2 = this.$type.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.getName()");
                            return StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
                        }
                    }));
                    boolean $i$f$sortedBy = false;
                    Sequence folders2 = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            File p0 = (File)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)p0.getName());
                            p0 = (File)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getName())));
                        }
                    });
                    Sequence $this$forEach$iv3 = files2 = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)folders2, (Function1)afterCheckRootProject.3.files.1.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(name){
                        final /* synthetic */ String $name;
                        {
                            this.$name = $name;
                            super(1);
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        @NotNull
                        public final Boolean invoke(@NotNull File it) {
                            boolean bl;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            String string2 = this.$name;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                            if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                                String string3 = it.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
                                if (StringsKt.startsWith$default((String)string3, (String)".", (int)this.$name.length(), (boolean)false, (int)4, null)) {
                                    bl = true;
                                    return bl;
                                }
                            }
                            bl = false;
                            return bl;
                        }
                    }));
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv3) {
                        File it = (File)element$iv2;
                        boolean bl2 = false;
                        resource.recordLocation(Location.Companion.create(it));
                    }
                }
                if (!context2.isGlobalAnalysis()) {
                    lintMap = this.storeSerializedModel(context2);
                    boolean bl = false;
                    function2 = (Function2)new Function2<LintResource, Location, LintMap>(lintMap){
                        final /* synthetic */ LintMap $lintMap;
                        {
                            this.$lintMap = $lintMap;
                            super(2);
                        }

                        @NotNull
                        public final LintMap invoke(@NotNull LintResource resource, @NotNull Location location2) {
                            Intrinsics.checkNotNullParameter((Object)((Object)resource), (String)"resource");
                            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                            String string = resource.getField();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resource.field");
                            return this.$lintMap.put(string, location2);
                        }
                    };
                } else {
                    function2 = (Function2)new Function2<LintResource, Location, Unit>(this, context2){
                        final /* synthetic */ UnusedResourceDetector this$0;
                        final /* synthetic */ Context $context;
                        {
                            this.this$0 = $receiver;
                            this.$context = $context;
                            super(2);
                        }

                        public final void invoke(@NotNull LintResource resource, @NotNull Location location2) {
                            Intrinsics.checkNotNullParameter((Object)((Object)resource), (String)"resource");
                            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                            String field = resource.getField();
                            String message2 = "The resource `" + field + "` appears to be unused";
                            Object[] objectArray = new Object[]{"field", field};
                            LintFix fix = UnusedResourceDetector.access$fix(this.this$0).data(objectArray);
                            Incident incident = new Incident(com.android.tools.lint.checks.UnusedResourceDetector$Companion.access$getIssue(UnusedResourceDetector.Companion, resource), location2, message2, fix);
                            this.$context.report(incident);
                        }
                    };
                }
                Function2 record2 = function2;
                Lazy defaultLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Location>(context2){
                    final /* synthetic */ Context $context;
                    {
                        this.$context = $context;
                        super(0);
                    }

                    @Nullable
                    public final Location invoke() {
                        Location location2;
                        boolean skippedLibraries;
                        block5: {
                            Iterable $this$any$iv = this.$context.getDriver().getProjects();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v0 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    Project it = (Project)element$iv;
                                    boolean bl = false;
                                    if (!(!it.getReportIssues())) continue;
                                    v0 = true;
                                    break block5;
                                }
                                v0 = skippedLibraries = false;
                            }
                        }
                        if (skippedLibraries) {
                            location2 = null;
                        } else {
                            File file = this.$context.getProject().getDir();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.project.dir");
                            location2 = Location.Companion.create(file);
                        }
                        return location2;
                    }
                }));
                lintMap = SequencesKt.mapNotNull((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)unused)), (Function1)((Function1)new Function1<ResourceUsageModel.Resource, Pair<? extends LintResource, ? extends Location>>((Lazy<? extends Location>)defaultLocation$delegate){
                    final /* synthetic */ Lazy<Location> $defaultLocation$delegate;
                    {
                        this.$defaultLocation$delegate = $defaultLocation$delegate;
                        super(1);
                    }

                    @Nullable
                    public final Pair<LintResource, Location> invoke(ResourceUsageModel.Resource resource) {
                        Pair pair2;
                        Location location2;
                        Location location3;
                        block6: {
                            block5: {
                                Intrinsics.checkNotNull((Object)resource, (String)"null cannot be cast to non-null type com.android.tools.lint.checks.UnusedResourceDetector.LintResource");
                                location3 = ((LintResource)resource).getLocations();
                                if (location3 == null) break block5;
                                Location location4 = location3;
                                Location.Companion companion = Location.Companion;
                                Location p0 = location4;
                                boolean bl = false;
                                Location location5 = companion.reverse(p0);
                                location3 = location5;
                                if (location5 != null) break block6;
                            }
                            location3 = UnusedResourceDetector.access$afterCheckRootProject$lambda$8(this.$defaultLocation$delegate);
                        }
                        Location location6 = location2 = location3;
                        if (location6 != null) {
                            Location it = location6;
                            boolean bl = false;
                            pair2 = TuplesKt.to((Object)resource, (Object)location2);
                        } else {
                            pair2 = null;
                        }
                        return pair2;
                    }
                }));
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair pair2 = (Pair)element$iv;
                    boolean bl = false;
                    LintResource resource = (LintResource)((Object)pair2.component1());
                    Location location2 = (Location)pair2.component2();
                    record2.invoke((Object)resource, (Object)location2);
                }
                break;
            }
            default: {
                throw new IllegalStateException(("Phase " + context2.getPhase() + " not expected").toString());
            }
        }
    }

    private final LintMap storeSerializedModel(Context context2) {
        boolean includeValues = false;
        String serialized = this.model.serialize(includeValues);
        LintMap lintMap = context2.getPartialResults(ISSUE).map();
        Intrinsics.checkNotNullExpressionValue((Object)serialized, (String)"serialized");
        return lintMap.put(KEY_MODEL, serialized);
    }

    private final void recordInactiveJavaReferences(File resDir) {
        for (File file : UnusedResourceDetectorKt.access$listFilesOrEmpty(resDir)) {
            if (file.isDirectory()) {
                this.recordInactiveJavaReferences(file);
                continue;
            }
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            if (StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null)) {
                UnusedResourceDetector.recordInactiveJavaReferences$recordFile(this, file, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this.model){

                    public final void invoke(String p0) {
                        ((UnusedResourceDetectorUsageModel)((Object)this.receiver)).tokenizeJavaCode(p0);
                    }
                }));
                continue;
            }
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            if (!StringsKt.endsWith$default((String)string2, (String)".kt", (boolean)false, (int)2, null)) continue;
            UnusedResourceDetector.recordInactiveJavaReferences$recordFile(this, file, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this.model){

                public final void invoke(String p0) {
                    ((UnusedResourceDetectorUsageModel)((Object)this.receiver)).tokenizeKotlinCode(p0);
                }
            }));
        }
    }

    private final void recordInactiveXmlResources(File resDir) {
        for (File folder : UnusedResourceDetectorKt.access$listFilesOrEmpty(resDir)) {
            ResourceFolderType it;
            if (ResourceFolderType.getFolderType((String)folder.getName()) == null) continue;
            boolean bl = false;
            this.recordInactiveXmlResources(it, folder);
        }
    }

    private final void recordInactiveXmlResources(ResourceFolderType folderType, File folder) {
        for (File file : UnusedResourceDetectorKt.access$listFilesOrEmpty(folder)) {
            this.withParsingErrorTolerated((Function0<Unit>)((Function0)new Function0<Unit>(file, this, folderType){
                final /* synthetic */ File $file;
                final /* synthetic */ UnusedResourceDetector this$0;
                final /* synthetic */ ResourceFolderType $folderType;
                {
                    this.$file = $file;
                    this.this$0 = $receiver;
                    this.$folderType = $folderType;
                    super(0);
                }

                public final void invoke() {
                    if (SdkUtils.endsWithIgnoreCase((String)this.$file.getPath(), (String)".xml")) {
                        String xml = Files.asCharSource((File)this.$file, (Charset)Charsets.UTF_8).read();
                        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
                        UnusedResourceDetector.access$getModel$p(this.this$0).visitXmlDocument(this.$file, this.$folderType, document);
                    } else {
                        UnusedResourceDetector.access$getModel$p(this.this$0).visitBinaryResource(this.$folderType, this.$file);
                    }
                }
            }));
        }
    }

    private final void withParsingErrorTolerated(Function0<Unit> run2) {
        try {
            run2.invoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void addInactiveReferences(LintModelVariant active) {
        for (LintModelSourceProvider provider : active.getModule().getInactiveSourceProviders(active)) {
            UnusedResourceDetector.addInactiveReferences$forEachDir(provider.getResDirectories(), (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>((Object)this){

                public final void invoke(@NotNull File p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    UnusedResourceDetector.access$recordInactiveXmlResources((UnusedResourceDetector)this.receiver, p0);
                }
            }));
            UnusedResourceDetector.addInactiveReferences$forEachDir(provider.getJavaDirectories(), (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>((Object)this){

                public final void invoke(@NotNull File p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    UnusedResourceDetector.access$recordInactiveJavaReferences((UnusedResourceDetector)this.receiver, p0);
                }
            }));
        }
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkBinaryResource(@NotNull ResourceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        try {
            this.model.setContext(context2);
            this.model.visitBinaryResource(context2.getResourceFolderType(), context2.file);
        }
        finally {
            this.model.setContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitDocument(@NotNull XmlContext context2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        try {
            this.model.setXmlContext(context2);
            this.model.setContext(context2);
            ResourceFolderType folderType = context2.getResourceFolderType();
            this.model.visitXmlDocument(context2.file, folderType, document);
            Element root = document.getDocumentElement();
            if (root != null && folderType == ResourceFolderType.LAYOUT) {
                String ignoreAttribute;
                if (Intrinsics.areEqual((Object)"layout", (Object)root.getTagName())) {
                    if (this.bindingClasses == null) {
                        this.bindingClasses = new HashMap();
                    }
                    String fileName = context2.file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
                    String resourceName = Lint.getBaseName(fileName);
                    String string = UnusedResourceDetector.visitDocument$bindingClassFrom(XmlUtils.getFirstSubTagByName((Node)root, (String)"data"));
                    if (string == null) {
                        string = Companion.toClassName(resourceName, "Binding");
                    }
                    String bindingClass = string;
                    Map<String, String> map2 = this.bindingClasses;
                    Intrinsics.checkNotNull(map2);
                    map2.put(bindingClass, resourceName);
                } else if (this.projectUsesViewBinding && !Intrinsics.areEqual((Object)"true", (Object)(ignoreAttribute = root.getAttributeNS("http://schemas.android.com/tools", "viewBindingIgnore")))) {
                    if (this.bindingClasses == null) {
                        this.bindingClasses = new HashMap();
                    }
                    String fileName = context2.file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
                    String resourceName = Lint.getBaseName(fileName);
                    String bindingClass = Companion.toClassName(resourceName, "Binding");
                    Map<String, String> map3 = this.bindingClasses;
                    Intrinsics.checkNotNull(map3);
                    map3.put(bindingClass, resourceName);
                }
            }
        }
        finally {
            this.model.setXmlContext(null);
            this.model.setContext(null);
        }
    }

    @Override
    public boolean appliesToResourceRefs() {
        return true;
    }

    @Override
    public void visitResourceReference(@NotNull JavaContext context2, @NotNull UElement node, @NotNull ResourceType type2, @NotNull String name, boolean isFramework) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!isFramework) {
            ResourceUsageModel.markReachable((ResourceUsageModel.Resource)this.model.addResource(type2, name, null));
        }
    }

    @NotNull
    public List<Class<? extends UAnnotated>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallableReferenceExpression.class, UCallExpression.class, UField.class, USimpleNameReferenceExpression.class, UQualifiedReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map<String, String> bindingClasses = this.bindingClasses;
        return bindingClasses != null ? (UElementHandler)new UElementHandler(context2, bindingClasses, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ Map<String, String> $bindingClasses;
            final /* synthetic */ UnusedResourceDetector this$0;
            {
                this.$context = $context;
                this.$bindingClasses = $bindingClasses;
                this.this$0 = $receiver;
            }

            private final <C extends PsiClass> void visitClass(C psiClass, Function1<? super C, String> getBindingClassName) {
                block1: {
                    if (psiClass == null || !this.isBindingClass(this.$context.getEvaluator(), psiClass)) break block1;
                    String string = this.$bindingClasses.get(getBindingClassName.invoke(psiClass));
                    if (string != null) {
                        String string2 = string;
                        UnusedResourceDetector unusedResourceDetector = this.this$0;
                        String resourceName = string2;
                        boolean bl = false;
                        ResourceUsageModel.markReachable((ResourceUsageModel.Resource)UnusedResourceDetector.access$getModel$p(unusedResourceDetector).getResource(ResourceType.LAYOUT, resourceName));
                    }
                }
            }

            static /* synthetic */ void visitClass$default(createUastHandler.1 var0, PsiClass psiClass, Function1 function1, int n, Object object) {
                if ((n & 2) != 0) {
                    function1 = createUastHandler.visitClass.1.INSTANCE;
                }
                var0.visitClass(psiClass, function1);
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                createUastHandler.1.visitClass$default(this, (PsiClass)(psiMethod != null ? psiMethod.getContainingClass() : null), null, 2, null);
            }

            public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.resolve();
                this.visitClass(psiElement instanceof PsiClass ? (PsiClass)psiElement : null, (Function1)new Function1<PsiClass, String>(node){
                    final /* synthetic */ USimpleNameReferenceExpression $node;
                    {
                        this.$node = $node;
                        super(1);
                    }

                    @Nullable
                    public final String invoke(@NotNull PsiClass it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$node.getIdentifier();
                    }
                });
            }

            public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.resolve();
                PsiMember psiMember = psiElement instanceof PsiMember ? (PsiMember)psiElement : null;
                createUastHandler.1.visitClass$default(this, (PsiClass)(psiMember != null ? psiMember.getContainingClass() : null), null, 2, null);
            }

            public void visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                String id;
                String className;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiType psiType = node.getReceiver().getExpressionType();
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                String string = className = psiClassType != null ? psiClassType.getClassName() : null;
                if (this.$bindingClasses.containsKey(className) && (id = node.getResolvedName()) != null) {
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)UnusedResourceDetector.access$getModel$p(this.this$0).getResource(ResourceType.ID, id));
                }
            }

            public void visitField(@NotNull UField node) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    PsiType psiType = node.getType();
                    PsiType[] classType = psiType instanceof PsiClassType ? (PsiType[])psiType : null;
                    createUastHandler.1.visitClass$default(this, (PsiClass)(classType != null ? classType.resolve() : null), null, 2, null);
                    PsiType[] psiTypeArray = classType;
                    if (classType == null || (psiTypeArray = psiTypeArray.getParameters()) == null) break block1;
                    PsiType[] $this$forEach$iv = psiTypeArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        PsiType element$iv;
                        PsiType typeArgument = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        PsiClassType psiClassType = typeArgument instanceof PsiClassType ? (PsiClassType)typeArgument : null;
                        createUastHandler.1.visitClass$default(this, (PsiClass)(psiClassType != null ? psiClassType.resolve() : null), null, 2, null);
                    }
                }
            }

            private final boolean isBindingClass(JavaEvaluator evaluator, PsiClass binding) {
                return evaluator.extendsClass(binding, "android.databinding.ViewDataBinding", true) || evaluator.extendsClass(binding, "androidx.databinding.ViewDataBinding", true) || evaluator.extendsClass(binding, "androidx.viewbinding.ViewBinding", true);
            }
        } : null;
    }

    private static final Location afterCheckRootProject$lambda$8(Lazy<? extends Location> $defaultLocation$delegate) {
        Lazy<? extends Location> lazy = $defaultLocation$delegate;
        return (Location)lazy.getValue();
    }

    private static final void recordInactiveJavaReferences$recordFile(UnusedResourceDetector this$0, File file, Function1<? super String, Unit> recordCode) {
        this$0.withParsingErrorTolerated((Function0<Unit>)((Function0)new Function0<Unit>(recordCode, file){
            final /* synthetic */ Function1<String, Unit> $recordCode;
            final /* synthetic */ File $file;
            {
                this.$recordCode = $recordCode;
                this.$file = $file;
                super(0);
            }

            public final void invoke() {
                String string = Files.asCharSource((File)this.$file, (Charset)Charsets.UTF_8).read();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asCharSource(file, Charsets.UTF_8).read()");
                this.$recordCode.invoke((Object)string);
            }
        }));
    }

    private static final void addInactiveReferences$forEachDir(Collection<? extends File> $this$addInactiveReferences_u24forEachDir, Function1<? super File, Unit> record2) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$addInactiveReferences_u24forEachDir), (Function1)addInactiveReferences.forEachDir.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            record2.invoke(element$iv);
        }
    }

    private static final String visitDocument$bindingClassFrom(Element data) {
        String string;
        block2: {
            while (data != null) {
                String bindingClass = data.getAttribute("class");
                Intrinsics.checkNotNullExpressionValue((Object)bindingClass, (String)"bindingClass");
                if (((CharSequence)bindingClass).length() > 0) {
                    String string2 = bindingClass.substring(StringsKt.lastIndexOf$default((CharSequence)bindingClass, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    break block2;
                }
                data = XmlUtils.getNextTagByName((Node)data, (String)"data");
            }
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ LintFix.Builder access$fix(UnusedResourceDetector $this) {
        return $this.fix();
    }

    public static final /* synthetic */ Location access$afterCheckRootProject$lambda$8(Lazy $defaultLocation$delegate) {
        return UnusedResourceDetector.afterCheckRootProject$lambda$8((Lazy<? extends Location>)$defaultLocation$delegate);
    }

    public static final /* synthetic */ UnusedResourceDetectorUsageModel access$getModel$p(UnusedResourceDetector $this) {
        return $this.model;
    }

    public static final /* synthetic */ void access$recordInactiveXmlResources(UnusedResourceDetector $this, File resDir) {
        $this.recordInactiveXmlResources(resDir);
    }

    public static final /* synthetic */ void access$recordInactiveJavaReferences(UnusedResourceDetector $this, File resDir) {
        $this.recordInactiveJavaReferences(resDir);
    }

    static {
        EnumSet<Enum> scopeSet = EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.ALL_JAVA_FILES, (Enum)Scope.BINARY_RESOURCE_FILE);
        boolean bl = false;
        if (Intrinsics.areEqual((Object)"true", (Object)System.getProperty(INCLUDE_TESTS_PROPERTY)) || !Intrinsics.areEqual((Object)"false", (Object)System.getProperty(EXCLUDE_TESTS_PROPERTY))) {
            scopeSet.add(Scope.TEST_SOURCES);
        }
        IMPLEMENTATION = new Implementation(UnusedResourceDetector.class, scopeSet);
        ISSUE = Issue.Companion.create("UnusedResources", "Unused resources", "\n                Unused resources make applications larger and slow down builds.\n\n                \n                The unused resource check can ignore tests. If you want to include \\\n                resources that are only referenced from tests, consider packaging them \\\n                in a test source set instead.\n\n                You can include test sources in the unused resource check by setting \\\n                the system property \\\n                lint.unused-resources.include-tests \\\n                =true, and to \\\n                exclude them (usually for performance reasons), use \\\n                lint.unused-resources.exclude-tests \\\n                =true.\n                ,\n                ", Category.PERFORMANCE, 3, Severity.WARNING, IMPLEMENTATION);
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE_IDS = Issue.Companion.create$default(companion, "UnusedIds", "Unused id", "\n                This resource id definition appears not to be needed since it is not referenced \\\n                from anywhere. Having id definitions, even if unused, is not necessarily a bad \\\n                idea since they make working on layouts and menus easier, so there is not a \\\n                strong reason to delete these.\n\n                \n                The unused resource check can ignore tests. If you want to include \\\n                resources that are only referenced from tests, consider packaging them \\\n                in a test source set instead.\n\n                You can include test sources in the unused resource check by setting \\\n                the system property \\\n                lint.unused-resources.include-tests \\\n                =true, and to \\\n                exclude them (usually for performance reasons), use \\\n                lint.unused-resources.exclude-tests \\\n                =true.\n                \n                ", implementation, null, category, 1, severity, false, null, null, null, 3600, null);
        sIncludeInactiveReferences = true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0012\u0010\u001b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/UnusedResourceDetector$Companion;", "", "()V", "EXCLUDE_TESTS_PROPERTY", "", "EXCLUDING_TESTS_EXPLANATION", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INCLUDE_TESTS_PROPERTY", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_IDS", "KEY_MODEL", "KEY_RESOURCE_FIELD", "sIncludeInactiveReferences", "", "capitalize", "string", "findUnused", "Lkotlin/sequences/Sequence;", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "context", "Lcom/android/tools/lint/detector/api/Context;", "model", "Lcom/android/ide/common/resources/usage/ResourceUsageModel;", "getIssue", "resource", "toClassName", "postfix", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nUnusedResourceDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedResourceDetector.kt\ncom/android/tools/lint/checks/UnusedResourceDetector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,712:1\n731#2,9:713\n*S KotlinDebug\n*F\n+ 1 UnusedResourceDetector.kt\ncom/android/tools/lint/checks/UnusedResourceDetector$Companion\n*L\n690#1:713,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Sequence<ResourceUsageModel.Resource> findUnused(Context context2, ResourceUsageModel model2) {
            model2.processToolsAttributes();
            boolean idEnabled = context2.isEnabled(ISSUE_IDS);
            List list2 = model2.findUnused();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"model\n        .findUnused()");
            return SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)findUnused.1.INSTANCE), (Function1)((Function1)new Function1<ResourceUsageModel.Resource, Boolean>(idEnabled){
                final /* synthetic */ boolean $idEnabled;
                {
                    this.$idEnabled = $idEnabled;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(ResourceUsageModel.Resource it) {
                    return this.$idEnabled || it.type != ResourceType.ID;
                }
            }));
        }

        private final Issue getIssue(ResourceUsageModel.Resource resource) {
            return resource.type != ResourceType.ID ? ISSUE : ISSUE_IDS;
        }

        @NotNull
        public final String toClassName(@NotNull String $this$toClassName, @NotNull String postfix) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)$this$toClassName, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
            CharSequence charSequence = $this$toClassName;
            Regex regex = new Regex("[_-]");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"", null, (CharSequence)postfix, (int)0, null, (Function1)((Function1)new Function1<String, String>((Object)this){

                @NotNull
                public final String invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return com.android.tools.lint.checks.UnusedResourceDetector$Companion.access$capitalize((Companion)this.receiver, p0);
                }
            }), (int)26, null);
        }

        private final String capitalize(String string) {
            Object object;
            Character ch = StringsKt.firstOrNull((CharSequence)string);
            if (ch == null) {
                object = string;
            } else if (Character.isTitleCase(ch.charValue())) {
                object = string;
            } else {
                char c = Character.toTitleCase(ch.charValue());
                String string2 = string.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                object = c + string2;
            }
            return object;
        }

        public static final /* synthetic */ String access$capitalize(Companion $this, String string) {
            return $this.capitalize(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/UnusedResourceDetector$LintResource;", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "type", "Lcom/android/resources/ResourceType;", "name", "", "value", "", "(Lcom/android/resources/ResourceType;Ljava/lang/String;I)V", "locations", "Lcom/android/tools/lint/detector/api/Location;", "getLocations", "()Lcom/android/tools/lint/detector/api/Location;", "setLocations", "(Lcom/android/tools/lint/detector/api/Location;)V", "recordLocation", "", "location", "android.sdktools.lint-checks"})
    private static final class LintResource
    extends ResourceUsageModel.Resource {
        @Nullable
        private Location locations;

        public LintResource(@Nullable ResourceType type2, @Nullable String name, int value) {
            super(type2, name, value);
        }

        @Nullable
        public final Location getLocations() {
            return this.locations;
        }

        public final void setLocations(@Nullable Location location2) {
            this.locations = location2;
        }

        public final void recordLocation(@NotNull Location location2) {
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Location oldLocation = this.locations;
            if (oldLocation != null) {
                location2.setSecondary(oldLocation);
            }
            this.locations = location2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J$\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0018\u0010!\u001a\n \"*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010#\u001a\u00020$H\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/checks/UnusedResourceDetector$UnusedResourceDetectorUsageModel;", "Lcom/android/ide/common/resources/usage/ResourceUsageModel;", "()V", "context", "Lcom/android/tools/lint/detector/api/Context;", "getContext", "()Lcom/android/tools/lint/detector/api/Context;", "setContext", "(Lcom/android/tools/lint/detector/api/Context;)V", "unused", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "getUnused", "()Ljava/util/Set;", "setUnused", "(Ljava/util/Set;)V", "xmlContext", "Lcom/android/tools/lint/detector/api/XmlContext;", "getXmlContext", "()Lcom/android/tools/lint/detector/api/XmlContext;", "setXmlContext", "(Lcom/android/tools/lint/detector/api/XmlContext;)V", "createResource", "Lcom/android/tools/lint/checks/UnusedResourceDetector$LintResource;", "type", "Lcom/android/resources/ResourceType;", "name", "", "realValue", "", "declareResource", "node", "Lorg/w3c/dom/Node;", "readText", "kotlin.jvm.PlatformType", "file", "Ljava/io/File;", "Companion", "android.sdktools.lint-checks"})
    private static final class UnusedResourceDetectorUsageModel
    extends ResourceUsageModel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private XmlContext xmlContext;
        @Nullable
        private Context context;
        @NotNull
        private Set<? extends ResourceUsageModel.Resource> unused = new HashSet();

        @Nullable
        public final XmlContext getXmlContext() {
            return this.xmlContext;
        }

        public final void setXmlContext(@Nullable XmlContext xmlContext) {
            this.xmlContext = xmlContext;
        }

        @Nullable
        public final Context getContext() {
            return this.context;
        }

        public final void setContext(@Nullable Context context2) {
            this.context = context2;
        }

        @NotNull
        public final Set<ResourceUsageModel.Resource> getUnused() {
            return this.unused;
        }

        public final void setUnused(@NotNull Set<? extends ResourceUsageModel.Resource> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.unused = set;
        }

        @NotNull
        protected LintResource createResource(@NotNull ResourceType type2, @NotNull String name, int realValue) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new LintResource(type2, name, realValue);
        }

        protected String readText(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Object object = this.context;
            if (object == null || (object = ((Context)object).getClient()) == null || (object = ((LintClient)object).readFile(file)) == null || (object = object.toString()) == null) {
                object = super.readText(file);
            }
            return object;
        }

        @Nullable
        public ResourceUsageModel.Resource declareResource(@NotNull ResourceType type2, @NotNull String name, @Nullable Node node) {
            LintResource resource;
            block9: {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (((CharSequence)name).length() == 0) {
                    return null;
                }
                ResourceUsageModel.Resource resource2 = super.declareResource(type2, name, node);
                Intrinsics.checkNotNull((Object)resource2, (String)"null cannot be cast to non-null type com.android.tools.lint.checks.UnusedResourceDetector.LintResource");
                resource = (LintResource)resource2;
                Context context2 = this.context;
                if (context2 == null) break block9;
                Context context3 = context2;
                boolean bl = false;
                resource.setDeclared(context3.getProject().getReportIssues());
                XmlContext xmlContext = this.xmlContext;
                if (context3.getPhase() == 2 && this.unused.contains((Object)resource)) {
                    if (xmlContext != null && xmlContext.getDriver().isSuppressed(xmlContext, Companion.getIssue(resource), node)) {
                        resource.setKeep(true);
                    } else if (node == null || xmlContext == null) {
                        resource.recordLocation(Location.Companion.create(context3.file));
                    } else {
                        Node node2;
                        Attr attr;
                        Element element = node instanceof Element ? (Element)node : null;
                        Attr attr2 = attr = element != null ? element.getAttributeNode("name") : null;
                        if (attr2 == null) {
                            node2 = node;
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)attr2, (String)"(node as? Element)?.getA\u2026teNode(ATTR_NAME) ?: node");
                            node2 = attr;
                        }
                        resource.recordLocation(xmlContext.getLocation(node2));
                    }
                }
                if (type2 == ResourceType.RAW && UnusedResourceDetectorUsageModel.Companion.isKeepFile(name, xmlContext)) {
                    resource.setReachable(true);
                }
            }
            return resource;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/UnusedResourceDetector$UnusedResourceDetectorUsageModel$Companion;", "", "()V", "isKeepFile", "", "name", "", "xmlContext", "Lcom/android/tools/lint/detector/api/XmlContext;", "android.sdktools.lint-checks"})
        @SourceDebugExtension(value={"SMAP\nUnusedResourceDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedResourceDetector.kt\ncom/android/tools/lint/checks/UnusedResourceDetector$UnusedResourceDetectorUsageModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,712:1\n1743#2,3:713\n*S KotlinDebug\n*F\n+ 1 UnusedResourceDetector.kt\ncom/android/tools/lint/checks/UnusedResourceDetector$UnusedResourceDetectorUsageModel$Companion\n*L\n565#1:713,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean isKeepFile(String name, XmlContext xmlContext) {
                boolean bl;
                block8: {
                    if (Intrinsics.areEqual((Object)"keep", (Object)name)) {
                        bl = true;
                    } else {
                        Object object = xmlContext;
                        if ((object != null && (object = ((XmlContext)object).document) != null ? object.getDocumentElement() : null) == null || xmlContext.document.getDocumentElement().getFirstChild() != null) {
                            bl = false;
                        } else {
                            NamedNodeMap attributes = xmlContext.document.getDocumentElement().getAttributes();
                            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)attributes.getLength());
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                Iterator iterator = $this$any$iv.iterator();
                                while (iterator.hasNext()) {
                                    int element$iv;
                                    int i = element$iv = ((IntIterator)iterator).nextInt();
                                    boolean bl2 = false;
                                    Node attr = attributes.item(i);
                                    String nodeName = attr.getNodeName();
                                    Intrinsics.checkNotNullExpressionValue((Object)nodeName, (String)"nodeName");
                                    if (!(StringsKt.startsWith$default((String)nodeName, (String)"xmlns:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nodeName, (String)"tools", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)attr.getNamespaceURI()))) {
                                        return false;
                                    }
                                    boolean bl3 = StringsKt.endsWith$default((String)nodeName, (String)"shrinkMode", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)nodeName, (String)"discard", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)nodeName, (String)"keep", (boolean)false, (int)2, null);
                                    if (!bl3) continue;
                                    bl = true;
                                    break block8;
                                }
                                bl = false;
                            }
                        }
                    }
                }
                return bl;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

