/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.android.utils.SdkUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharDirectionality;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/TypographyDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "checkDashes", "", "checkEllipsis", "checkFractions", "checkMisc", "checkQuotes", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkText", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "textNode", "Lorg/w3c/dom/Node;", "text", "", "getApplicableElements", "", "getFractionFix", "Lcom/android/tools/lint/detector/api/LintFix;", "numerator", "", "denominator", "replacement", "visitElement", "Companion", "android.sdktools.lint-checks"})
public final class TypographyDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean checkDashes;
    private boolean checkQuotes;
    private boolean checkFractions;
    private boolean checkEllipsis;
    private boolean checkMisc;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TypographyDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue DASHES;
    @JvmField
    @NotNull
    public static final Issue QUOTES;
    @JvmField
    @NotNull
    public static final Issue FRACTIONS;
    @JvmField
    @NotNull
    public static final Issue ELLIPSIS;
    @JvmField
    @NotNull
    public static final Issue OTHER;
    @NotNull
    private static final String GRAVE_QUOTE_MESSAGE = "Avoid quoting with grave accents; use apostrophes or better yet directional quotes instead";
    @NotNull
    private static final String ELLIPSIS_MESSAGE = "Replace \"...\" with ellipsis character (\u2026, &#8230;) ?";
    @NotNull
    private static final String EN_DASH_MESSAGE = "Replace \"-\" with an \"en dash\" character (\u2013, &#8211;) ?";
    @NotNull
    private static final String EM_DASH_MESSAGE = "Replace \"--\" with an \"em dash\" character (\u2014, &#8212;) ?";
    @NotNull
    private static final String TYPOGRAPHIC_APOSTROPHE_MESSAGE = "Replace apostrophe (') with typographic apostrophe (\u2019, &#8217;) ?";
    @NotNull
    private static final String SINGLE_QUOTE_MESSAGE = "Replace straight quotes ('') with directional quotes (\u2018\u2019, &#8216; and &#8217;) ?";
    @NotNull
    private static final String DBL_QUOTES_MESSAGE = "Replace straight quotes (\") with directional quotes (\u201c\u201d, &#8220; and &#8221;) ?";
    @NotNull
    private static final String COPYRIGHT_MESSAGE = "Replace (c) with copyright symbol \u00a9 (&#169;) ?";
    @NotNull
    private static final Pattern HYPHEN_RANGE_PATTERN;
    @NotNull
    private static final Pattern GRAVE_QUOTATION;
    @NotNull
    private static final Pattern FRACTION_PATTERN;
    @NotNull
    private static final Pattern SINGLE_QUOTE;
    @NotNull
    private static final String FRACTION_MESSAGE = "Use fraction character %1$c (%2$s) instead of %3$s?";

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"string", "string-array", "plurals"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.checkDashes = context2.isEnabled(DASHES);
        this.checkQuotes = context2.isEnabled(QUOTES);
        this.checkFractions = context2.isEnabled(FRACTIONS);
        this.checkEllipsis = context2.isEnabled(ELLIPSIS);
        this.checkMisc = context2.isEnabled(OTHER);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (SdkUtils.isServiceKey((String)element.getAttribute("name"))) {
            return;
        }
        Attr translatable = element.getAttributeNode("translatable");
        if (translatable != null && !Intrinsics.areEqual((Object)translatable.getValue(), (Object)"true")) {
            return;
        }
        Iterator iterator = DomExtensions.childrenIterator((Node)element);
        while (iterator.hasNext()) {
            String text;
            Node child = (Node)iterator.next();
            if (child.getNodeType() == 3) {
                text = child.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                this.checkText(context2, element, child, text);
                continue;
            }
            if (child.getNodeType() == 4) {
                text = child.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                if (StringsKt.contains$default((CharSequence)text, (CharSequence)"<", (boolean)false, (int)2, null)) continue;
                this.checkText(context2, element, child, text);
                continue;
            }
            if (child.getNodeType() != 1 || !Intrinsics.areEqual((Object)child.getParentNode().getNodeName(), (Object)"string-array") && !Intrinsics.areEqual((Object)child.getParentNode().getNodeName(), (Object)"plurals")) continue;
            Iterator iterator2 = DomExtensions.childrenIterator((Node)child);
            while (iterator2.hasNext()) {
                String text2;
                Node item = (Node)iterator2.next();
                if (item.getNodeType() == 3) {
                    text2 = item.getNodeValue();
                    Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    Element element2 = (Element)child;
                    Intrinsics.checkNotNullExpressionValue((Object)text2, (String)"text");
                    this.checkText(context2, element2, item, text2);
                    continue;
                }
                if (item.getNodeType() != 4) continue;
                text2 = item.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)text2, (String)"text");
                if (StringsKt.contains$default((CharSequence)text2, (CharSequence)"<", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                this.checkText(context2, (Element)child, item, text2);
            }
        }
    }

    private final void checkText(XmlContext context2, Element element, Node textNode, String text) {
        Matcher matcher;
        int hyphen;
        int ellipsis;
        if (this.checkEllipsis && (ellipsis = StringsKt.indexOf$default((CharSequence)text, (String)"...", (int)0, (boolean)false, (int)6, null)) != -1 && !StringsKt.startsWith$default((String)text, (String)".", (int)(ellipsis + 3), (boolean)false, (int)4, null)) {
            context2.report(ELLIPSIS, element, context2.getLocation(textNode), ELLIPSIS_MESSAGE, this.fix().replace().text("...").with("\u2026").build());
        }
        if (this.checkDashes && (hyphen = StringsKt.indexOf$default((CharSequence)text, (char)'-', (int)0, (boolean)false, (int)6, null)) != -1) {
            int emDash;
            Matcher matcher2 = HYPHEN_RANGE_PATTERN.matcher(text);
            if (matcher2.matches()) {
                boolean isNegativeNumber;
                boolean bl = isNegativeNumber = !Character.isWhitespace(matcher2.group(2).charAt(0)) && Character.isWhitespace(matcher2.group(1).charAt(matcher2.group(1).length() - 1));
                if (!isNegativeNumber && !TypographyDetector.Companion.isAnalyticsTrackingId(element)) {
                    context2.report(DASHES, element, context2.getLocation(textNode), EN_DASH_MESSAGE, TypographyDetector.Companion.isRtl(text) ? null : this.fix().replace().text("-").with("\u2013").build());
                }
            }
            if ((emDash = StringsKt.indexOf$default((CharSequence)text, (String)"--", (int)0, (boolean)false, (int)6, null)) > 1 && !StringsKt.startsWith$default((String)text, (String)"-", (int)(emDash + 2), (boolean)false, (int)4, null)) {
                context2.report(DASHES, element, context2.getLocation(textNode), EM_DASH_MESSAGE, TypographyDetector.Companion.isRtl(text) ? null : this.fix().replace().text("--").with("\u2014").build());
            }
        }
        if (this.checkQuotes) {
            int quoteEnd;
            int quoteStart = StringsKt.indexOf$default((CharSequence)text, (char)'\'', (int)0, (boolean)false, (int)6, null);
            if (quoteStart != -1) {
                int quoteEnd2 = StringsKt.indexOf$default((CharSequence)text, (char)'\'', (int)(quoteStart + 1), (boolean)false, (int)4, null);
                if (quoteEnd2 != -1 && quoteEnd2 > quoteStart + 1 && (quoteEnd2 < text.length() - 1 || quoteStart > 0) && SINGLE_QUOTE.matcher(text).matches()) {
                    Node node = element;
                    Location location2 = context2.getLocation(textNode);
                    LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace();
                    String string = text.substring(quoteStart, quoteEnd2 + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    LintFix.ReplaceStringBuilder replaceStringBuilder2 = replaceStringBuilder.text(string);
                    String string2 = text.substring(quoteStart + 1, quoteEnd2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    context2.report(QUOTES, node, location2, SINGLE_QUOTE_MESSAGE, replaceStringBuilder2.with("\u2018" + string2 + "\u2019").build());
                    return;
                }
                if (quoteEnd2 == -1 && quoteStart > 0 && (Character.isLetterOrDigit(text.charAt(quoteStart - 1)) || quoteStart > 1 && text.charAt(quoteStart - 1) == '\\' && Character.isLetterOrDigit(text.charAt(quoteStart - 2)))) {
                    context2.report(QUOTES, element, context2.getLocation(textNode), TYPOGRAPHIC_APOSTROPHE_MESSAGE, this.fix().replace().text("'").with("\u2019").build());
                    return;
                }
            }
            if ((quoteStart = StringsKt.indexOf$default((CharSequence)text, (char)'\"', (int)0, (boolean)false, (int)6, null)) != -1 && (quoteEnd = StringsKt.indexOf$default((CharSequence)text, (char)'\"', (int)(quoteStart + 1), (boolean)false, (int)4, null)) != -1 && quoteEnd > quoteStart + 1 && (quoteEnd < text.length() - 1 || quoteStart > 0)) {
                Node node = element;
                Location location3 = context2.getLocation(textNode);
                LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace();
                String string = text.substring(quoteStart, quoteEnd + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                LintFix.ReplaceStringBuilder replaceStringBuilder3 = replaceStringBuilder.text(string);
                String string3 = text.substring(quoteStart + 1, quoteEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                context2.report(QUOTES, node, location3, DBL_QUOTES_MESSAGE, replaceStringBuilder3.with("\u201c" + string3 + "\u201d").build());
                return;
            }
            int graveStart = StringsKt.indexOf$default((CharSequence)text, (char)'`', (int)0, (boolean)false, (int)6, null);
            if (graveStart != -1 && GRAVE_QUOTATION.matcher(text).matches()) {
                LintFix lintFix;
                int quoteEnd3 = StringsKt.indexOf$default((CharSequence)text, (String)"'", (int)0, (boolean)false, (int)6, null);
                if (text.charAt(graveStart + 1) == '`') {
                    LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace();
                    String string = text.substring(graveStart, quoteEnd3 + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    LintFix.ReplaceStringBuilder replaceStringBuilder4 = replaceStringBuilder.text(string);
                    String string4 = text.substring(graveStart + 2, quoteEnd3);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    lintFix = replaceStringBuilder4.with("\u201c" + string4 + "\u201d").build();
                } else {
                    LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace();
                    String string = text.substring(graveStart, quoteEnd3 + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    LintFix.ReplaceStringBuilder replaceStringBuilder5 = replaceStringBuilder.text(string);
                    String string5 = text.substring(graveStart + 1, quoteEnd3);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    lintFix = replaceStringBuilder5.with("\u2018" + string5 + "\u2019").build();
                }
                LintFix quickfix = lintFix;
                context2.report(QUOTES, element, context2.getLocation(textNode), GRAVE_QUOTE_MESSAGE, quickfix);
                return;
            }
        }
        if (this.checkFractions && StringsKt.indexOf$default((CharSequence)text, (char)'/', (int)0, (boolean)false, (int)6, null) != -1 && (matcher = FRACTION_PATTERN.matcher(text)).matches()) {
            String top = matcher.group(1);
            String bottom = matcher.group(2);
            if (Intrinsics.areEqual((Object)top, (Object)"1") && Intrinsics.areEqual((Object)bottom, (Object)"2")) {
                Node node = element;
                Location location4 = context2.getLocation(textNode);
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u00bd'), "&#189;", "1/2"};
                String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
                context2.report(FRACTIONS, node, location4, string6, this.getFractionFix(1, 2, "\u00bd"));
            } else if (Intrinsics.areEqual((Object)top, (Object)"1") && Intrinsics.areEqual((Object)bottom, (Object)"4")) {
                Node node = element;
                Location location5 = context2.getLocation(textNode);
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u00bc'), "&#188;", "1/4"};
                String string7 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
                context2.report(FRACTIONS, node, location5, string7, this.getFractionFix(1, 4, "\u00bc"));
            } else if (Intrinsics.areEqual((Object)top, (Object)"3") && Intrinsics.areEqual((Object)bottom, (Object)"4")) {
                Node node = element;
                Location location6 = context2.getLocation(textNode);
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u00be'), "&#190;", "3/4"};
                String string8 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(format, *args)");
                context2.report(FRACTIONS, node, location6, string8, this.getFractionFix(3, 4, "\u00be"));
            } else if (Intrinsics.areEqual((Object)top, (Object)"1") && Intrinsics.areEqual((Object)bottom, (Object)"3")) {
                Node node = element;
                Location location7 = context2.getLocation(textNode);
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u2153'), "&#8531;", "1/3"};
                String string9 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(format, *args)");
                context2.report(FRACTIONS, node, location7, string9, this.getFractionFix(1, 3, "\u2153"));
            } else if (Intrinsics.areEqual((Object)top, (Object)"2") && Intrinsics.areEqual((Object)bottom, (Object)"3")) {
                Node node = element;
                Location location8 = context2.getLocation(textNode);
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u2154'), "&#8532;", "2/3"};
                String string10 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(format, *args)");
                context2.report(FRACTIONS, node, location8, string10, this.getFractionFix(2, 3, "\u2154"));
            }
        }
        if (this.checkMisc && StringsKt.indexOf$default((CharSequence)text, (char)'(', (int)0, (boolean)false, (int)6, null) != -1 && (StringsKt.contains$default((CharSequence)text, (CharSequence)"(c)", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)"(C)", (boolean)false, (int)2, null))) {
            context2.report(OTHER, element, context2.getLocation(textNode), COPYRIGHT_MESSAGE, this.fix().replace().text(StringsKt.contains$default((CharSequence)text, (CharSequence)"(c)", (boolean)false, (int)2, null) ? "(c)" : "(C)").with("\u00a9").build());
        }
    }

    private final LintFix getFractionFix(int numerator, int denominator, String replacement) {
        return this.fix().replace().pattern(numerator + "\\s*/\\s*" + denominator).with(replacement).build();
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.TYPOGRAPHY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        DASHES = Issue.Companion.create$default(companion, "TypographyDashes", "Hyphen can be replaced with dash", "\n                        The \"n dash\" (\\u2013, &#8211;) and the \"m dash\" (\\u2014, &#8212;) \\\n                        characters are used for ranges (n dash) and breaks (m dash). Using these \\\n                        instead of plain hyphens can make text easier to read and your application \\\n                        will look more polished.\n                        ", implementation, "https://en.wikipedia.org/wiki/Dash", category, 5, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.TYPOGRAPHY;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        QUOTES = Issue.Companion.create$default(companion, "TypographyQuotes", "Straight quotes can be replaced with curvy quotes", "\n                        Straight single quotes and double quotes, when used as a pair, can be replaced by \\\n                        \"curvy quotes\" (or directional quotes). This can make the text more readable. Note that you \\\n                        should never use grave accents and apostrophes to quote, `like this'. (Also note that you \\\n                        should not use curvy quotes for code fragments.)\n                        ", implementation, "https://en.wikipedia.org/wiki/Quotation_mark", category, 5, severity, false, null, null, null, 3584, null);
        companion = Issue.Companion;
        category = Category.TYPOGRAPHY;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        FRACTIONS = Issue.Companion.create$default(companion, "TypographyFractions", "Fraction string can be replaced with fraction character", "\n                        You can replace certain strings, such as 1/2, and 1/4, with dedicated \\\n                        characters for these, such as \u00bd (&#189;) and \u00bc (&#188;). \\\n                        This can help make the text more readable.\n                        ", implementation, "https://en.wikipedia.org/wiki/Number_Forms", category, 5, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.TYPOGRAPHY;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        ELLIPSIS = Issue.Companion.create$default(companion, "TypographyEllipsis", "Ellipsis string can be replaced with ellipsis character", "\n                    You can replace the string \"...\" with a dedicated ellipsis character, \\\n                    ellipsis character (\\u2026, &#8230;). This can help make the text more readable.\n                    ", implementation, "https://en.wikipedia.org/wiki/Ellipsis", category, 5, severity, false, null, null, null, 3840, null);
        OTHER = Issue.Companion.create("TypographyOther", "Other typographical problems", "This check looks for miscellaneous typographical problems and offers replacement \\\n                    sequences that will make the text easier to read and your application more \\\n                    polished.\n                    ", Category.TYPOGRAPHY, 3, Severity.WARNING, IMPLEMENTATION);
        Pattern pattern = Pattern.compile(".*(\\d+\\s*)-(\\s*\\d+).*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\".*(\\\\d+\\\\s*)-(\\\\s*\\\\d+).*\")");
        HYPHEN_RANGE_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("(^[^`]*`[^'`]+'[^']*$)|(^[^`]*``[^'`]+''[^']*$)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"(^[^`]*`[^'`]+'\u2026^[^`]*``[^'`]+''[^']*$)\")");
        GRAVE_QUOTATION = pattern2;
        Pattern pattern3 = Pattern.compile(".*\\b([13])\\s*/\\s*([234])\\b.*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(\".*\\\\b([13])\\\\s*/\\\\s*([234])\\\\b.*\")");
        FRACTION_PATTERN = pattern3;
        Pattern pattern4 = Pattern.compile(".*\\W*'[^']+'(\\W.*)?", 256);
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(\".*\\\\W*'[^']+'(\\\u2026.UNICODE_CHARACTER_CLASS)");
        SINGLE_QUOTE = pattern4;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/TypographyDetector$Companion;", "", "()V", "COPYRIGHT_MESSAGE", "", "DASHES", "Lcom/android/tools/lint/detector/api/Issue;", "DBL_QUOTES_MESSAGE", "ELLIPSIS", "ELLIPSIS_MESSAGE", "EM_DASH_MESSAGE", "EN_DASH_MESSAGE", "FRACTIONS", "FRACTION_MESSAGE", "FRACTION_PATTERN", "Ljava/util/regex/Pattern;", "GRAVE_QUOTATION", "GRAVE_QUOTE_MESSAGE", "HYPHEN_RANGE_PATTERN", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "OTHER", "QUOTES", "SINGLE_QUOTE", "SINGLE_QUOTE_MESSAGE", "TYPOGRAPHIC_APOSTROPHE_MESSAGE", "isAnalyticsTrackingId", "", "element", "Lorg/w3c/dom/Element;", "isRtl", "string", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nTypographyDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypographyDetector.kt\ncom/android/tools/lint/checks/TypographyDetector$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,500:1\n1079#2,2:501\n*S KotlinDebug\n*F\n+ 1 TypographyDetector.kt\ncom/android/tools/lint/checks/TypographyDetector$Companion\n*L\n491#1:501,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAnalyticsTrackingId(Element element) {
            String name = element.getAttribute("name");
            return Intrinsics.areEqual((Object)"ga_trackingId", (Object)name);
        }

        private final boolean isRtl(String string) {
            boolean bl;
            block1: {
                CharSequence $this$any$iv = string;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    CharDirectionality directionality = CharsKt.getDirectionality((char)c);
                    boolean bl3 = directionality == CharDirectionality.RIGHT_TO_LEFT || directionality == CharDirectionality.RIGHT_TO_LEFT_ARABIC || directionality == CharDirectionality.RIGHT_TO_LEFT_EMBEDDING || directionality == CharDirectionality.RIGHT_TO_LEFT_OVERRIDE;
                    if (!bl3) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

