/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastErrorType;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringFormatDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION_XML = new Implementation(StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    private static final Implementation IMPLEMENTATION_XML_AND_JAVA = new Implementation(StringFormatDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE), Scope.JAVA_FILE_SCOPE);
    public static final Issue INVALID = Issue.create("StringFormatInvalid", "Invalid format string", "If a string contains a '%' character, then the string may be a formatting string which will be passed to `String.format` from Java code to replace each '%' occurrence with specific values.\n\nThis lint warning checks for two related problems:\n(1) Formatting strings that are invalid, meaning that `String.format` will throw exceptions at runtime when attempting to use the format string.\n(2) Strings containing '%' that are not formatting strings getting passed to a `String.format` call. In this case the '%' will need to be escaped as '%%'.\n\nNOTE: Not all Strings which look like formatting strings are intended for use by `String.format`; for example, they may contain date formats intended for `android.text.format.Time#format()`. Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML);
    public static final Issue ARG_COUNT = Issue.create("StringFormatCount", "Formatting argument types incomplete or inconsistent", "When a formatted string takes arguments, it usually needs to reference the same arguments in all translations (or all arguments if there are no translations.\n\nThere are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML);
    public static final Issue TRIVIAL = Issue.create("StringFormatTrivial", "`String.format` string only contains trivial conversions", "Every call to `String.format` creates a new `Formatter` instance, which will decrease the performance of your app. `String.format` should only be used when necessary--if the formatted string contains only trivial conversions (e.g. `b`, `s`, `c`) and there are no translation concerns, it will be more efficient to replace them and concatenate with `+`.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION_XML_AND_JAVA).setAndroidSpecific(true).setEnabledByDefault(false);
    public static final Issue ARG_TYPES = Issue.create("StringFormatMatches", "`String.format` string doesn't match the XML format string", "This lint check ensures the following:\n(1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n(2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML_AND_JAVA);
    public static final Issue POTENTIAL_PLURAL = Issue.create("PluralsCandidate", "Potential Plurals", "This lint check looks for potential errors in internationalization where you have translated a message which involves a quantity and it looks like other parts of the string may need grammatical changes.\n\nFor example, rather than something like this:\n```xml\n  <string name=\"try_again\">Try again in %d seconds.</string>\n```\nyou should be using a plural:\n```xml\n   <plurals name=\"try_again\">\n        <item quantity=\"one\">Try again in %d second</item>\n        <item quantity=\"other\">Try again in %d seconds</item>\n    </plurals>\n```\nThis will ensure that in other languages the right set of translations are provided for the different quantity classes.\n\n(This check depends on some heuristics, so it may not accurately determine whether a string really should be a quantity. You can use tools:ignore to filter out false positives.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML).addMoreInfo("https://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
    private Map<String, List<Pair<Location.Handle, String>>> mFormatStrings;
    private final Map<String, Location.Handle> mNotFormatStrings = new LinkedHashMap<String, Location.Handle>();
    private Set<String> mIgnoreStrings;
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    public static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("string");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() > 0) {
            if (childNodes.getLength() == 1) {
                Node child = childNodes.item(0);
                short type2 = child.getNodeType();
                if (type2 == 3 || type2 == 4) {
                    this.checkTextNode(context2, element, StringFormatDetector.stripQuotes(child.getNodeValue()));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                StringFormatDetector.addText(sb, element);
                if (sb.length() > 0) {
                    this.checkTextNode(context2, element, sb.toString());
                }
            }
        }
    }

    static void addText(StringBuilder sb, Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 3 || nodeType == 4) {
            sb.append(StringFormatDetector.stripQuotes(node.getNodeValue().trim()));
        } else {
            NodeList childNodes = node.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                StringFormatDetector.addText(sb, childNodes.item(i));
            }
        }
    }

    static String stripQuotes(String s) {
        StringBuilder sb = new StringBuilder();
        boolean isEscaped = false;
        boolean isQuotedBlock = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char current = s.charAt(i);
            if (isEscaped) {
                sb.append(current);
                isEscaped = false;
                continue;
            }
            boolean bl = isEscaped = current == '\\';
            if (current == '\"') {
                isQuotedBlock = !isQuotedBlock;
                continue;
            }
            if (current == '\'') {
                if (!isQuotedBlock) continue;
                sb.append(current);
                continue;
            }
            sb.append(current);
        }
        return sb.toString();
    }

    private void checkTextNode(XmlContext context2, Element element, String text) {
        String name = element.getAttribute("name");
        boolean found = false;
        boolean foundPlural = false;
        int m = text.length();
        for (int j = 0; j < m; ++j) {
            char c = text.charAt(j);
            if (c == '\\') {
                ++j;
            }
            if (c != '%') continue;
            String formatted = element.getAttribute("formatted");
            if (!formatted.isEmpty() && !Boolean.parseBoolean(formatted)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle2 = context2.createLocationHandle(element);
                    handle2.setClientData(element);
                    this.mNotFormatStrings.put(name, handle2);
                }
                return;
            }
            Matcher matcher = FORMAT.matcher(text);
            if (!matcher.find(j)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle3 = context2.createLocationHandle(element);
                    handle3.setClientData(element);
                    this.mNotFormatStrings.put(name, handle3);
                }
                return;
            }
            String conversion = matcher.group(6);
            int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
            if (conversionClass == 0 || matcher.group(5) != null) {
                if (this.mIgnoreStrings == null) {
                    this.mIgnoreStrings = new HashSet<String>();
                }
                this.mIgnoreStrings.add(name);
                return;
            }
            if (conversionClass == 3 && !foundPlural) {
                for (int k = matcher.end(); k < m; ++k) {
                    char nc = text.charAt(k);
                    if (Character.isWhitespace(nc)) continue;
                    if (!Character.isLetter(nc)) break;
                    foundPlural = StringFormatDetector.checkPotentialPlural(context2, element, text, k);
                    break;
                }
            }
            found = true;
            ++j;
        }
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        if (name != null) {
            Location.Handle handle4 = context2.createLocationHandle(element);
            handle4.setClientData(element);
            if (found) {
                List<Pair<Location.Handle, String>> list2;
                if (this.mFormatStrings == null) {
                    this.mFormatStrings = new LinkedHashMap<String, List<Pair<Location.Handle, String>>>();
                }
                if ((list2 = this.mFormatStrings.get(name)) == null) {
                    list2 = new ArrayList<Pair<Location.Handle, String>>();
                    this.mFormatStrings.put(name, list2);
                }
                list2.add((Pair<Location.Handle, String>)Pair.of((Object)handle4, (Object)text));
            } else if (!StringFormatDetector.isReference(text)) {
                this.mNotFormatStrings.put(name, handle4);
            }
        }
    }

    private static boolean isReference(String text) {
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '@' || c == '?';
        }
        return false;
    }

    private static boolean checkPotentialPlural(XmlContext context2, Element element, String text, int wordBegin) {
        int wordEnd;
        assert (Character.isLetter(text.charAt(wordBegin)));
        for (wordEnd = wordBegin; wordEnd < text.length() && Character.isLetter(text.charAt(wordEnd)); ++wordEnd) {
        }
        if (wordEnd - wordBegin <= 2) {
            return false;
        }
        boolean hasVowel = false;
        for (int i = wordBegin; i < wordEnd; ++i) {
            char c = text.charAt(i);
            if (i > wordBegin && Character.isUpperCase(c)) {
                return false;
            }
            if (c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u' && c != 'y') continue;
            hasVowel = true;
        }
        if (!hasVowel) {
            return false;
        }
        String word = text.substring(wordBegin, wordEnd);
        if (word.equals("min")) {
            return false;
        }
        if (Lint.isEnglishResource(context2, true)) {
            String message2 = String.format("Formatting %%d followed by words (\"%1$s\"): This should probably be a plural rather than a string", word);
            context2.report(POTENTIAL_PLURAL, element, context2.getLocation(element), message2);
            return true;
        }
        return false;
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mFormatStrings != null) {
            boolean checkCount = context2.isEnabled(ARG_COUNT);
            boolean checkValid = context2.isEnabled(INVALID);
            boolean checkTypes = context2.isEnabled(ARG_TYPES);
            for (Map.Entry<String, List<Pair<Location.Handle, String>>> entry : this.mFormatStrings.entrySet()) {
                String name = entry.getKey();
                ImmutableList list2 = entry.getValue();
                if (checkCount) {
                    Location.Handle notFormatted = this.mNotFormatStrings.get(name);
                    if (notFormatted != null) {
                        list2 = ImmutableList.builder().add((Object)Pair.of((Object)notFormatted, (Object)name)).addAll(list2).build();
                    }
                    StringFormatDetector.checkArity(context2, name, list2);
                }
                if (!checkValid && !checkTypes) continue;
                StringFormatDetector.checkTypes(context2, checkValid, checkTypes, name, list2);
            }
        }
    }

    private static boolean isSuppressed(Context context2, Issue issue, Object source) {
        if (source instanceof Node) {
            return context2.getDriver().isSuppressed(null, issue, (Node)source);
        }
        return false;
    }

    private static boolean isSuppressed(Context context2, Issue issue, Location location2) {
        Object source = location2.getSource();
        return StringFormatDetector.isSuppressed(context2, issue, source);
    }

    private static boolean isSuppressed(Context context2, Issue issue, Location.Handle handle2) {
        Object source = handle2.getClientData();
        if (StringFormatDetector.isSuppressed(context2, issue, source)) {
            return true;
        }
        return StringFormatDetector.isSuppressed(context2, issue, handle2.resolve());
    }

    private static void checkTypes(Context context2, boolean checkValid, boolean checkTypes, String name, List<Pair<Location.Handle, String>> list2) {
        HashMap<Integer, String> types = new HashMap<Integer, String>();
        HashMap<Integer, Location.Handle> typeDefinition = new HashMap<Integer, Location.Handle>();
        block0: for (Pair<Location.Handle, String> pair2 : list2) {
            Location.Handle handle2 = (Location.Handle)pair2.getFirst();
            String formatString = (String)pair2.getSecond();
            Matcher matcher = FORMAT.matcher(formatString);
            int index2 = 0;
            int prevIndex = 0;
            int nextNumber = 1;
            while (matcher.find(index2)) {
                int number;
                char last;
                int matchStart = matcher.start();
                while (prevIndex < matchStart) {
                    char c = formatString.charAt(prevIndex);
                    if (c == '\\') {
                        ++prevIndex;
                    }
                    ++prevIndex;
                }
                if (prevIndex > matchStart) {
                    index2 = prevIndex;
                    continue;
                }
                index2 = matcher.end();
                String str = formatString.substring(matchStart, matcher.end());
                if (str.equals("%%") || str.equals("%n")) continue;
                if (checkValid && str.length() > 2 && str.charAt(str.length() - 2) == ' ' && (last = str.charAt(str.length() - 1)) != 'd' && last != 'o' && last != 'x' && last != 'X') {
                    if (StringFormatDetector.isSuppressed(context2, INVALID, handle2)) {
                        return;
                    }
                    Location location2 = handle2.resolve();
                    String message2 = String.format("Incorrect formatting string `%1$s`; missing conversion character in '`%2$s`'?", name, str);
                    context2.report(INVALID, location2, message2);
                    continue;
                }
                if (!checkTypes) continue;
                String numberString = matcher.group(1);
                if (numberString != null) {
                    numberString = numberString.substring(0, numberString.length() - 1);
                    number = Integer.parseInt(numberString);
                    nextNumber = number + 1;
                } else {
                    number = nextNumber++;
                }
                String format = matcher.group(6);
                String currentFormat = (String)types.get(number);
                if (currentFormat == null) {
                    types.put(number, format);
                    typeDefinition.put(number, handle2);
                    continue;
                }
                if (currentFormat.equals(format) || !StringFormatDetector.isIncompatible(currentFormat.charAt(0), format.charAt(0))) continue;
                if (StringFormatDetector.isSuppressed(context2, ARG_TYPES, handle2)) {
                    return;
                }
                Location location3 = handle2.resolve();
                if (StringFormatDetector.isSuppressed(context2, ARG_TYPES, location3)) {
                    return;
                }
                location3 = StringFormatDetector.refineLocation(context2, location3, formatString, matcher.start(), matcher.end());
                Location otherLocation = ((Location.Handle)typeDefinition.get(number)).resolve();
                otherLocation.setMessage("Conflicting argument type (`" + currentFormat + "') here");
                location3.setSecondary(otherLocation);
                File f = otherLocation.getFile();
                String message3 = String.format(Locale.US, "Inconsistent formatting types for argument #%1$d in format string `%2$s` ('%3$s'): Found both '`%4$s`' here and '`%5$s`' in %6$s", number, name, str, format, currentFormat, Lint.getFileNameWithParent(context2.getClient(), f));
                context2.report(ARG_TYPES, location3, message3);
                continue block0;
            }
        }
    }

    private static boolean isIncompatible(char conversion1, char conversion2) {
        int class2;
        int class1 = StringFormatDetector.getConversionClass(conversion1);
        return class1 != (class2 = StringFormatDetector.getConversionClass(conversion2)) && class1 != 0 && class2 != 0;
    }

    private static int getConversionClass(char conversion) {
        switch (conversion) {
            case 'T': 
            case 't': {
                return 9;
            }
            case 'S': 
            case 's': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 2;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                return 3;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return 4;
            }
            case 'B': 
            case 'b': {
                return 5;
            }
            case 'H': 
            case 'h': {
                return 6;
            }
            case '%': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        return 0;
    }

    private static Location refineLocation(Context context2, Location location2, String formatString, int substringStart, int substringEnd) {
        Position startLocation = location2.getStart();
        Position endLocation = location2.getEnd();
        if (startLocation != null && endLocation != null) {
            int formatOffset;
            CharSequence contents;
            int startOffset = startLocation.getOffset();
            int endOffset = endLocation.getOffset();
            if (startOffset >= 0 && endOffset <= (contents = context2.getClient().readFile(location2.getFile())).length() && startOffset < endOffset && (formatOffset = CharSequences.indexOf((CharSequence)contents, (CharSequence)formatString, (int)startOffset)) != -1 && formatOffset <= endOffset) {
                return Location.create(location2.getFile(), contents, formatOffset + substringStart, formatOffset + substringEnd);
            }
        }
        return location2;
    }

    private static void checkArity(Context context2, String name, List<Pair<Location.Handle, String>> list2) {
        int prevCount = -1;
        for (Pair<Location.Handle, String> pair2 : list2) {
            HashSet<Integer> indices2 = new HashSet<Integer>();
            int count = StringFormatDetector.getFormatArgumentCount((String)pair2.getSecond(), indices2);
            Location.Handle handle2 = (Location.Handle)pair2.getFirst();
            if (prevCount != -1 && prevCount != count) {
                if (StringFormatDetector.isSuppressed(context2, ARG_COUNT, handle2)) {
                    return;
                }
                Location location2 = handle2.resolve();
                if (StringFormatDetector.isSuppressed(context2, ARG_COUNT, location2)) {
                    return;
                }
                Location secondary = ((Location.Handle)list2.get(0).getFirst()).resolve();
                if (StringFormatDetector.isSuppressed(context2, ARG_COUNT, secondary)) {
                    return;
                }
                secondary.setMessage("Conflicting number of arguments (" + prevCount + ") here");
                location2.setSecondary(secondary);
                String path2 = Lint.getFileNameWithParent(context2.getClient(), secondary.getFile());
                String message2 = String.format(Locale.US, "Inconsistent number of arguments in formatting string `%1$s`; found both %2$d here and %3$d in %4$s", name, count, prevCount, path2);
                context2.report(ARG_COUNT, location2, message2);
                break;
            }
            for (int i = 1; i <= count; ++i) {
                if (indices2.contains(i)) continue;
                if (StringFormatDetector.isSuppressed(context2, ARG_COUNT, handle2)) {
                    return;
                }
                HashSet<Integer> all2 = new HashSet<Integer>();
                for (int j = 1; j < count; ++j) {
                    all2.add(j);
                }
                all2.removeAll(indices2);
                ArrayList sorted = new ArrayList(all2);
                Collections.sort(sorted);
                Location location3 = handle2.resolve();
                String message3 = String.format("Formatting string '`%1$s`' is not referencing numbered arguments %2$s", name, sorted);
                context2.report(ARG_COUNT, location3, message3);
                break;
            }
            prevCount = count;
        }
    }

    @VisibleForTesting
    static String getFormatArgumentType(String s, int argument) {
        Matcher matcher = FORMAT.matcher(s);
        int index2 = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        while (matcher.find(index2)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index2 = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index2 = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number == argument) {
                return matcher.group(6);
            }
            index2 = matcher.end();
        }
        return null;
    }

    static int getFormatArgumentCount(String s, Set<Integer> seenArguments) {
        Matcher matcher = FORMAT.matcher(s);
        int index2 = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int max = 0;
        while (matcher.find(index2)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index2 = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index2 = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number > max) {
                max = number;
            }
            if (seenArguments != null) {
                seenArguments.add(number);
            }
            index2 = matcher.end();
        }
        return max;
    }

    static boolean hasFormatArgumentModifiers(String s, int argument) {
        Matcher matcher = FORMAT.matcher(s);
        int index2 = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        while (matcher.find(index2)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index2 = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index2 = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number == argument) {
                String flags = matcher.group(2);
                String width = matcher.group(3);
                String precision = matcher.group(4);
                return flags != null && flags.length() > 0 || width != null && width.length() > 0 || precision != null && precision.length() > 0;
            }
            index2 = matcher.end();
        }
        return false;
    }

    public static boolean isLocaleSpecific(String format) {
        if (format.indexOf(37) == -1) {
            return false;
        }
        Matcher matcher = FORMAT.matcher(format);
        int index2 = 0;
        int prevIndex = 0;
        while (matcher.find(index2)) {
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = format.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index2 = prevIndex;
                continue;
            }
            String type2 = matcher.group(6);
            if (!type2.isEmpty()) {
                char t = type2.charAt(0);
                switch (t) {
                    case 'E': 
                    case 'G': 
                    case 'T': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 't': {
                        return true;
                    }
                }
            }
            index2 = matcher.end();
        }
        return false;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("format", "getString");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression node, PsiMethod method) {
        JavaEvaluator evaluator = context2.getEvaluator();
        String methodName = method.getName();
        if (methodName.equals("format")) {
            if (evaluator.isMemberInClass((PsiMember)method, "java.lang.String")) {
                this.checkStringFormatCall(context2, method, node, method.getParameterList().getParametersCount() == 3);
            }
        } else {
            if (method.getParameterList().getParametersCount() < 2) {
                return;
            }
            if (evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.res.Resources", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.Context", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.app.Fragment", false) || evaluator.isMemberInSubClassOf((PsiMember)method, AndroidXConstants.CLASS_V4_FRAGMENT.oldName(), false) || evaluator.isMemberInSubClassOf((PsiMember)method, AndroidXConstants.CLASS_V4_FRAGMENT.newName(), false)) {
                this.checkStringFormatCall(context2, method, node, false);
            }
        }
    }

    private static void checkNotFormattedHandle(JavaContext context2, UCallExpression call, String name, Location.Handle handle2) {
        if (StringFormatDetector.isSuppressed((Context)context2, INVALID, handle2)) {
            return;
        }
        Location location2 = context2.getLocation((UElement)call);
        Location secondary = handle2.resolve();
        secondary.setMessage("This definition does not require arguments");
        location2.setSecondary(secondary);
        String message2 = String.format("Format string '`%1$s`' is not a valid format string so it should not be passed to `String.format`", name);
        context2.report(INVALID, (UElement)call, location2, message2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkStringFormatCall(JavaContext context2, PsiMethod calledMethod, UCallExpression call, boolean specifiesLocale) {
        ArrayList list2;
        int argIndex = specifiesLocale ? 1 : 0;
        List args = call.getValueArguments();
        if (args.size() <= argIndex) {
            return;
        }
        UExpression argument = (UExpression)args.get(argIndex);
        ResourceUrl resource = ResourceEvaluator.getResource(context2.getEvaluator(), (UElement)argument);
        if (resource == null || resource.isFramework() || resource.type != ResourceType.STRING) {
            this.checkTrivialString(context2, calledMethod, call, args, specifiesLocale);
            return;
        }
        String name = resource.name;
        if (this.mIgnoreStrings != null && this.mIgnoreStrings.contains(name)) {
            return;
        }
        boolean passingVarArgsArray = false;
        int callCount = args.size() - 1 - argIndex;
        if (callCount == 1) {
            UExpression lastArg = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(args.size() - 1)));
            PsiParameterList parameterList = calledMethod.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount > 0 && parameterList.getParameters()[parameterCount - 1].isVarArgs()) {
                PsiElement resolved;
                boolean knownArity = false;
                boolean argWasReference = false;
                if (lastArg instanceof UReferenceExpression && (resolved = ((UReferenceExpression)lastArg).resolve()) instanceof PsiVariable) {
                    UExpression initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved);
                    if (initializer != null) {
                        initializer = UastUtils.skipParenthesizedExprDown((UExpression)initializer);
                    }
                    if (initializer != null && (UastExpressionUtils.isNewArray((UElement)initializer) || UastExpressionUtils.isArrayInitializer((UElement)initializer))) {
                        argWasReference = true;
                        lastArg = initializer;
                    }
                }
                if (lastArg != null && (UastExpressionUtils.isNewArray((UElement)lastArg) || UastExpressionUtils.isArrayInitializer((UElement)lastArg))) {
                    Object o;
                    UExpression first;
                    Object arrayDimensions;
                    UCallExpression arrayInitializer = (UCallExpression)lastArg;
                    if (UastExpressionUtils.isNewArrayWithInitializer((UElement)lastArg) || UastExpressionUtils.isArrayInitializer((UElement)lastArg)) {
                        callCount = arrayInitializer.getValueArgumentCount();
                        knownArity = true;
                    } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)lastArg) && (arrayDimensions = arrayInitializer.getValueArguments()).size() == 1 && (first = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arrayDimensions.get(0)))) instanceof ULiteralExpression && (o = ((ULiteralExpression)first).getValue()) instanceof Integer) {
                        callCount = (Integer)o;
                        knownArity = true;
                    }
                    if (!knownArity) {
                        if (!argWasReference) {
                            return;
                        }
                    } else {
                        passingVarArgsArray = true;
                    }
                }
            }
        }
        if (callCount > 0 && this.mNotFormatStrings.containsKey(name)) {
            StringFormatDetector.checkNotFormattedHandle(context2, call, name, this.mNotFormatStrings.get(name));
            return;
        }
        ArrayList arrayList = list2 = this.mFormatStrings != null ? this.mFormatStrings.get(name) : null;
        if (list2 == null) {
            LintClient client = context2.getClient();
            boolean full = context2.isGlobalAnalysis();
            Project project = full ? context2.getMainProject() : context2.getProject();
            ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
            List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.STRING, name);
            for (ResourceItem item : items) {
                String value;
                ResourceValue v = item.getResourceValue();
                if (v == null || (value = v.getRawXmlValue()) == null) continue;
                if (StringFormatDetector.isReference(value)) {
                    List l;
                    ResourceUrl url;
                    for (int i = 0; i < 3 && (url = ResourceUrl.parse((String)value)) != null && !url.isFramework() && !(l = resources.getResources(ResourceNamespace.TODO(), url.type, url.name)).isEmpty() && (v = ((ResourceItem)l.get(0)).getResourceValue()) != null && (value = v.getValue()) != null && StringFormatDetector.isReference(value); ++i) {
                    }
                }
                if (value == null || StringFormatDetector.isReference(value)) continue;
                boolean isFormattingString = value.indexOf(37) != -1;
                int m = value.length();
                for (int j = 0; j < m && isFormattingString; ++j) {
                    char c = value.charAt(j);
                    if (c == '\\') {
                        ++j;
                        continue;
                    }
                    if (c != '%') continue;
                    Matcher matcher = FORMAT.matcher(value);
                    if (!matcher.find(j)) {
                        isFormattingString = false;
                    } else {
                        String conversion = matcher.group(6);
                        int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
                        if (conversionClass == 0 || matcher.group(5) != null) {
                            return;
                        }
                    }
                    ++j;
                }
                Location.ResourceItemHandle handle2 = client.createResourceItemHandle(item, false, true);
                if (isFormattingString) {
                    if (list2 == null) {
                        list2 = Lists.newArrayList();
                        if (this.mFormatStrings == null) {
                            this.mFormatStrings = new LinkedHashMap<String, List<Pair<Location.Handle, String>>>();
                        }
                        this.mFormatStrings.put(name, list2);
                    }
                    list2.add(Pair.of((Object)handle2, (Object)value));
                    continue;
                }
                if (callCount <= 0) continue;
                StringFormatDetector.checkNotFormattedHandle(context2, call, name, handle2);
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            list2.sort((o1, o2) -> {
                Location.Handle h1 = (Location.Handle)o1.getFirst();
                Location.Handle h2 = (Location.Handle)o2.getFirst();
                if (h1 instanceof Location.ResourceItemHandle && h2 instanceof Location.ResourceItemHandle) {
                    FolderConfiguration f2;
                    ResourceItem item1 = ((Location.ResourceItemHandle)h1).getItem();
                    ResourceItem item2 = ((Location.ResourceItemHandle)h2).getItem();
                    FolderConfiguration f1 = item1.getConfiguration();
                    int delta = f1.compareTo(f2 = item2.getConfiguration());
                    if (delta != 0) {
                        return delta;
                    }
                    return item1.toString().compareTo(item2.toString());
                }
                return o1.toString().compareTo(o2.toString());
            });
            Set reported = null;
            for (Pair<Location.Handle, String> pair2 : list2) {
                String s = (String)pair2.getSecond();
                if (reported != null && reported.contains(s)) continue;
                int count = StringFormatDetector.getFormatArgumentCount(s, null);
                Location.Handle handle3 = (Location.Handle)pair2.getFirst();
                if (count != callCount) {
                    Location location2 = context2.getLocation((UElement)call);
                    Location secondary = handle3.resolve();
                    secondary.setMessage(String.format(Locale.US, "This definition requires %1$d argument%2$s", count, count != 1 ? "s" : ""));
                    location2.setSecondary(secondary);
                    String message2 = String.format(Locale.US, "Wrong argument count, format string `%1$s` requires `%2$d` but format call supplies `%3$d`", name, count, callCount);
                    context2.report(ARG_TYPES, (UElement)call, location2, message2);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                    continue;
                }
                if (passingVarArgsArray) {
                    return;
                }
                block11: for (int i = 1; i <= count; ++i) {
                    int argumentIndex = i + argIndex;
                    UExpression expression = (UExpression)args.get(argumentIndex);
                    PsiType type2 = expression.getExpressionType();
                    if (this.isInStringExpression(call, expression)) {
                        type2 = this.getStringType(context2, expression);
                    }
                    if (type2 == null || type2 instanceof UastErrorType) continue;
                    boolean valid = true;
                    String formatType = StringFormatDetector.getFormatArgumentType(s, i);
                    if (formatType == null) continue;
                    char last = formatType.charAt(formatType.length() - 1);
                    if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') continue;
                    switch (last) {
                        case 'B': 
                        case 'b': {
                            valid = StringFormatDetector.isBooleanType(type2);
                            break;
                        }
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'o': 
                        case 'x': {
                            valid = StringFormatDetector.isNumericType(type2, true);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            valid = StringFormatDetector.isCharacterType(type2);
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            continue block11;
                        }
                        case 'S': 
                        case 's': {
                            valid = !StringFormatDetector.isBooleanType(type2) && !StringFormatDetector.isNumericType(type2, false);
                        }
                    }
                    if (valid) continue;
                    Location location3 = context2.getLocation((UElement)args.get(argumentIndex));
                    Location secondary = handle3.resolve();
                    secondary.setMessage("Conflicting argument declaration here");
                    location3.setSecondary(secondary);
                    if (StringFormatDetector.isSuppressed((Context)context2, ARG_TYPES, secondary)) continue;
                    Object suggestion = null;
                    if (StringFormatDetector.isBooleanType(type2)) {
                        suggestion = "`b`";
                    } else if (StringFormatDetector.isCharacterType(type2)) {
                        suggestion = "'c'";
                    } else if (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.SHORT.equals((Object)type2)) {
                        suggestion = "`d`, 'o' or `x`";
                    } else if (PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2)) {
                        suggestion = "`e`, 'f', 'g' or `a`";
                    } else if (type2 instanceof PsiClassType) {
                        String fqn = type2.getCanonicalText();
                        if ("java.lang.Integer".equals(fqn) || "java.lang.Long".equals(fqn) || "java.lang.Byte".equals(fqn) || "java.lang.Short".equals(fqn)) {
                            suggestion = "`d`, 'o' or `x`";
                        } else if ("java.lang.Float".equals(fqn) || "java.lang.Double".equals(fqn)) {
                            suggestion = "`d`, 'o' or `x`";
                        } else if ("java.lang.Object".equals(fqn)) {
                            suggestion = "'s' or 'h'";
                        }
                    }
                    suggestion = suggestion != null ? " (Did you mean formatting character " + (String)suggestion + "?)" : "";
                    String canonicalText = type2.getCanonicalText();
                    canonicalText = canonicalText.substring(canonicalText.lastIndexOf(46) + 1);
                    String message3 = String.format(Locale.US, "Wrong argument type for formatting argument '#%1$d' in `%2$s`: conversion is '`%3$s`', received `%4$s` (argument #%5$d in method call)%6$s", i, name, formatType, canonicalText, argumentIndex + 1, suggestion);
                    if ((last == 's' || last == 'S') && StringFormatDetector.isNumericType(type2, false)) {
                        message3 = String.format(Locale.US, "Suspicious argument type for formatting argument #%1$d in `%2$s`: conversion is `%3$s`, received `%4$s` (argument #%5$d in method call)%6$s", i, name, formatType, canonicalText, argumentIndex + 1, suggestion);
                    }
                    context2.report(ARG_TYPES, (UElement)call, location3, message3);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                }
            }
        }
    }

    private boolean isInStringExpression(UCallExpression call, UExpression expression) {
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return false;
        }
        PsiElement parent = sourcePsi.getParent();
        if (!(parent instanceof KtStringTemplateEntry)) {
            return false;
        }
        PsiElement stringElement = parent.getParent();
        PsiElement callPsi = call.getSourcePsi();
        if (callPsi instanceof KtCallExpression) {
            for (KtValueArgument argument : ((KtCallExpression)callPsi).getValueArguments()) {
                KtExpression valueExpression = argument.getArgumentExpression();
                if (valueExpression != stringElement) continue;
                return true;
            }
        }
        return false;
    }

    private PsiType getStringType(JavaContext context2, UExpression expression) {
        PsiElement element = expression.getSourcePsi();
        if (element == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)element.getProject());
        PsiClass javaLangClass = facade.findClass("java.lang.String", element.getResolveScope());
        if (javaLangClass != null) {
            return context2.getEvaluator().getClassType(javaLangClass);
        }
        return null;
    }

    private void checkTrivialString(JavaContext context2, PsiMethod calledMethod, UCallExpression call, List<UExpression> args, boolean specifiesLocale) {
        int stringIndex = specifiesLocale ? 1 : 0;
        String s = ConstantEvaluator.evaluateString(context2, (UElement)args.get(stringIndex), false);
        if (s == null) {
            return;
        }
        boolean uppercase = false;
        int count = StringFormatDetector.getFormatArgumentCount(s, null);
        for (int i = 1; i <= count; ++i) {
            int argumentIndex = i + stringIndex;
            if (argumentIndex >= args.size()) {
                return;
            }
            PsiType type2 = args.get(argumentIndex).getExpressionType();
            if (type2 == null) continue;
            String formatType = StringFormatDetector.getFormatArgumentType(s, i);
            if (formatType == null) {
                return;
            }
            char last = formatType.charAt(formatType.length() - 1);
            if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') {
                return;
            }
            switch (last) {
                case 'A': 
                case 'E': 
                case 'G': 
                case 'H': 
                case 'X': 
                case 'a': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'o': 
                case 'x': {
                    return;
                }
                case 'B': 
                case 'b': {
                    if (!Lint.isKotlin((PsiElement)calledMethod)) break;
                    return;
                }
            }
            if (StringFormatDetector.hasFormatArgumentModifiers(s, i)) {
                return;
            }
            if (!Character.isUpperCase(last)) continue;
            uppercase = true;
        }
        Object message2 = "This formatting string is trivial. Rather than using `String.format` to create your String, it will be more performant to concatenate your arguments with `+`. ";
        if (uppercase) {
            message2 = (String)message2 + "If uppercase formatting is necessary, use `String.toUpperCase()`.";
        }
        context2.report(TRIVIAL, (UElement)call, context2.getLocation((UElement)args.get(stringIndex)), (String)message2);
    }

    private static boolean isCharacterType(PsiType type2) {
        if (type2 == PsiType.CHAR) {
            return true;
        }
        if (type2 instanceof PsiClassType) {
            String fqn = type2.getCanonicalText();
            return "java.lang.Character".equals(fqn);
        }
        return false;
    }

    private static boolean isBooleanType(PsiType type2) {
        if (type2 == PsiType.BOOLEAN) {
            return true;
        }
        if (type2 instanceof PsiClassType) {
            String fqn = type2.getCanonicalText();
            return "java.lang.Boolean".equals(fqn);
        }
        return false;
    }

    private static boolean isNumericType(PsiType type2, boolean allowBigNumbers) {
        if (PsiType.INT.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2) || PsiType.LONG.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.SHORT.equals((Object)type2)) {
            return true;
        }
        if (type2 instanceof PsiClassType) {
            String fqn = type2.getCanonicalText();
            if ("java.lang.Integer".equals(fqn) || "java.lang.Float".equals(fqn) || "java.lang.Double".equals(fqn) || "java.lang.Long".equals(fqn) || "java.lang.Byte".equals(fqn) || "java.lang.Short".equals(fqn)) {
                return true;
            }
            if (allowBigNumbers && ("java.math.BigInteger".equals(fqn) || "java.math.BigDecimal".equals(fqn))) {
                return true;
            }
        }
        return false;
    }
}

