/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UastFacade;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/NonConstantResourceIdDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "ResourceIdVisitor", "android.sdktools.lint-checks"})
public final class NonConstantResourceIdDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue NON_CONSTANT_RESOURCE_ID;

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UAnnotation.class, USwitchExpression.class, UField.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new ResourceIdVisitor(context2);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(NonConstantResourceIdDetector.class, Scope.JAVA_FILE_SCOPE);
        NON_CONSTANT_RESOURCE_ID = Issue.Companion.create$default(companion, "NonConstantResourceId", "Checks use of resource IDs in places requiring constants", "\n                Avoid the usage of resource IDs where constant expressions are required.\n\n                A future version of the Android Gradle Plugin will generate R classes with \\\n                non-constant IDs in order to improve the performance of incremental compilation.\n                ", implementation, null, category, 5, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/NonConstantResourceIdDetector$Companion;", "", "()V", "NON_CONSTANT_RESOURCE_ID", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/NonConstantResourceIdDetector$ResourceIdVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "checkExpression", "", "node", "Lorg/jetbrains/uast/UExpression;", "where", "", "checkSwitchCasesForRClassReferences", "body", "Lorg/jetbrains/uast/UExpressionList;", "expressionReceiverIsRClass", "", "expression", "depth", "", "reportNonConstantUsage", "element", "Lorg/jetbrains/uast/UElement;", "visitAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "visitField", "Lorg/jetbrains/uast/UField;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "android.sdktools.lint-checks"})
    public static final class ResourceIdVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public ResourceIdVisitor(@NotNull JavaContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        @Override
        public void visitSwitchExpression(@NotNull USwitchExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Lint.isJava(node.getSourcePsi())) {
                this.checkSwitchCasesForRClassReferences(node.getBody());
            }
        }

        private final void checkSwitchCasesForRClassReferences(UExpressionList body) {
            for (UExpression expression : body.getExpressions()) {
                if (!(expression instanceof USwitchClauseExpression)) continue;
                this.checkExpression((UExpression)CollectionsKt.firstOrNull((List)((USwitchClauseExpression)expression).getCaseValues()), "in switch case statements");
            }
        }

        @Override
        public void visitAnnotation(@NotNull UAnnotation node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            for (UNamedExpression attribute : node.getAttributeValues()) {
                this.checkExpression(attribute.getExpression(), "as annotation attributes");
            }
        }

        @Override
        public void visitField(@NotNull UField node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression initializer = node.getUastInitializer();
            if (initializer != null && Lint.isKotlin((PsiElement)node) && this.context.getEvaluator().isConst((PsiModifierListOwner)node)) {
                this.checkExpression(initializer, "in const fields");
            }
        }

        private final void checkExpression(UExpression node, String where) {
            if (node == null) {
                return;
            }
            if (ResourceIdVisitor.expressionReceiverIsRClass$default(this, node, 0, 2, null)) {
                this.reportNonConstantUsage((UElement)node, where);
            }
        }

        private final void reportNonConstantUsage(UElement element, String where) {
            Location location2 = this.context.getLocation(element);
            JavaContext.report$default(this.context, NON_CONSTANT_RESOURCE_ID, element, location2, "Resource IDs will be non-final by default in Android Gradle Plugin version 8.0, avoid using them " + where, null, 16, null);
        }

        private final boolean expressionReceiverIsRClass(UExpression expression, int depth) {
            UExpression uExpression;
            PsiElement resolved;
            if (expression instanceof USimpleNameReferenceExpression && (resolved = ((USimpleNameReferenceExpression)expression).resolve()) instanceof PsiVariable && depth < 3 && (uExpression = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved)) != null) {
                UExpression initializer = uExpression;
                boolean bl = false;
                return this.expressionReceiverIsRClass(initializer, depth + 1);
            }
            ResourceReference reference = ResourceReference.Companion.get((UElement)expression);
            return reference != null && !reference.isFramework();
        }

        static /* synthetic */ boolean expressionReceiverIsRClass$default(ResourceIdVisitor resourceIdVisitor, UExpression uExpression, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return resourceIdVisitor.expressionReceiverIsRClass(uExpression, n);
        }
    }
}

