/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JobSchedulerDetector
extends Detector
implements SourceCodeScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(JobSchedulerDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("JobSchedulerService", "JobScheduler problems", "This check looks for various common mistakes in using the JobScheduler API: the service class must extend `JobService`, the service must be registered in the manifest and the registration must require the permission `android.permission.BIND_JOB_SERVICE`.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/topic/performance/scheduling.html").setAndroidSpecific(true);
    private static final String CLASS_JOB_SERVICE = "android.app.job.JobService";

    @Override
    public List<String> getApplicableConstructorTypes() {
        return Collections.singletonList("android.app.job.JobInfo.Builder");
    }

    @Override
    public void visitConstructor(JavaContext context2, UCallExpression node, PsiMethod constructor) {
        PsiElement resolved;
        List arguments = node.getValueArguments();
        if (arguments.size() < 2) {
            return;
        }
        UExpression componentName = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arguments.get(1)));
        if (componentName instanceof UReferenceExpression && (resolved = ((UReferenceExpression)componentName).resolve()) instanceof PsiVariable && (componentName = UastLintUtils.findLastAssignment((PsiVariable)resolved, (UElement)componentName)) != null) {
            componentName = UastUtils.skipParenthesizedExprDown((UExpression)componentName);
        }
        if (!(componentName instanceof UCallExpression)) {
            return;
        }
        UCallExpression call = (UCallExpression)componentName;
        arguments = call.getValueArguments();
        if (arguments.size() < 2) {
            return;
        }
        UExpression typeReference = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arguments.get(1)));
        if (!(typeReference instanceof UClassLiteralExpression)) {
            return;
        }
        UClassLiteralExpression classRef = (UClassLiteralExpression)typeReference;
        PsiType serviceType = classRef.getType();
        if (!(serviceType instanceof PsiClassType)) {
            return;
        }
        PsiClass serviceClass = ((PsiClassType)serviceType).resolve();
        if (serviceClass == null) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.inheritsFrom(serviceClass, "android.app.Service", false) && !evaluator.inheritsFrom(serviceClass, CLASS_JOB_SERVICE, false)) {
            String message2 = String.format("Scheduled job class %1$s must extend `android.app.job.JobService`", serviceClass.getName());
            context2.report(ISSUE, (UElement)componentName, context2.getLocation((UElement)componentName), message2);
        } else {
            if (context2.getDriver().isSuppressed(context2, ISSUE, (UAnnotated)typeReference)) {
                return;
            }
            String fqcn = serviceType.getCanonicalText();
            Location location2 = context2.getLocation((UElement)classRef);
            if (context2.isGlobalAnalysis()) {
                JobSchedulerDetector.ensureBindServicePermission(context2, fqcn, location2);
            } else {
                context2.getPartialResults(ISSUE).map().put(fqcn, location2);
            }
        }
    }

    @Override
    public void checkPartialResults(Context context2, PartialResult partialResults) {
        for (LintMap map2 : partialResults.maps()) {
            for (String fqcn : map2) {
                Location location2 = map2.getLocation(fqcn);
                if (location2 == null) continue;
                JobSchedulerDetector.ensureBindServicePermission(context2, fqcn, location2);
            }
        }
    }

    private static void ensureBindServicePermission(Context context2, String fqcn, Location location2) {
        Project project = context2.getMainProject();
        Document mergedManifest = project.getMergedManifest();
        if (mergedManifest == null) {
            return;
        }
        Element manifest = mergedManifest.getDocumentElement();
        if (manifest == null) {
            return;
        }
        Element application = XmlUtils.getFirstSubTagByName((Node)manifest, (String)"application");
        if (application == null) {
            return;
        }
        Element service = XmlUtils.getFirstSubTagByName((Node)application, (String)"service");
        while (service != null) {
            String name = Lint.resolveManifestName(service).replace('$', '.');
            if (fqcn.equals(name)) {
                String permission = service.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
                if (!"android.permission.BIND_JOB_SERVICE".equals(permission)) {
                    LintClient client = context2.getClient();
                    Location secondary = client.findManifestSourceLocation(service);
                    if (secondary != null) {
                        location2 = location2.withSecondary(secondary, "Service declaration here", false);
                    }
                    context2.report(ISSUE, location2, "The manifest registration for this service does not declare `android:permission=\"android.permission.BIND_JOB_SERVICE\"`");
                }
                return;
            }
            service = XmlUtils.getNextTagByName((Node)service, (String)"service");
        }
        context2.report(ISSUE, location2, "Did not find a manifest registration for this service");
    }
}

