/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.SourceSetType;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0010H\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "", "methodDescriptors", "", "", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "compare", "", "owner", "name", "desc", "combined", "isDesugared", "", "isSymbolSeparator", "", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nDesugaredMethodLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesugaredMethodLookup.kt\ncom/android/tools/lint/checks/DesugaredMethodLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1#2:395\n*E\n"})
public final class DesugaredMethodLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] methodDescriptors;
    @NotNull
    private static final String[] defaultDesugaredMethods;
    @NotNull
    private static DesugaredMethodLookup lookup;

    public DesugaredMethodLookup(@NotNull String[] methodDescriptors) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptors, (String)"methodDescriptors");
        this.methodDescriptors = methodDescriptors;
    }

    private final boolean isDesugared(String owner, String name, String desc) {
        Comparator signatureComparator2 = new Comparator(this, owner, name, desc){
            final /* synthetic */ DesugaredMethodLookup this$0;
            final /* synthetic */ String $owner;
            final /* synthetic */ String $name;
            final /* synthetic */ String $desc;
            {
                this.this$0 = $receiver;
                this.$owner = $owner;
                this.$name = $name;
                this.$desc = $desc;
            }

            public final int compare(String o1, String string) {
                Intrinsics.checkNotNullExpressionValue((Object)o1, (String)"o1");
                return this.this$0.compare(this.$owner, this.$name, this.$desc, o1);
            }
        };
        return Arrays.binarySearch(this.methodDescriptors, "placeholder", signatureComparator2) >= 0;
    }

    @VisibleForTesting
    public final int compare(@NotNull String owner, @NotNull String name, @NotNull String desc, @NotNull String combined) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)combined, (String)"combined");
        Ref.IntRef ownerIndex = new Ref.IntRef();
        Ref.BooleanRef hadSeparator = new Ref.BooleanRef();
        Ref.IntRef nameIndex = new Ref.IntRef();
        Ref.IntRef descIndex = new Ref.IntRef();
        int lastParen = StringsKt.lastIndexOf$default((CharSequence)combined, (char)')', (int)0, (boolean)false, (int)6, null);
        int combinedLength = lastParen == -1 ? combined.length() : lastParen + 1;
        int i = 0;
        do {
            char d;
            char c;
            if ((c = DesugaredMethodLookup.compare$getNext(ownerIndex, owner, hadSeparator, nameIndex, name, descIndex, desc)) == (d = combined.charAt(i++)) || this.isSymbolSeparator(c) && this.isSymbolSeparator(d)) continue;
            return d - c;
        } while (i != combinedLength);
        return nameIndex.element == 0 || nameIndex.element == name.length() && descIndex.element == 0 || descIndex.element == desc.length() ? 0 : 1;
    }

    private final boolean isSymbolSeparator(char $this$isSymbolSeparator) {
        return $this$isSymbolSeparator == '/' || $this$isSymbolSeparator == '$' || $this$isSymbolSeparator == '.';
    }

    private static final char compare$getNext(Ref.IntRef ownerIndex, String $owner, Ref.BooleanRef hadSeparator, Ref.IntRef nameIndex, String $name, Ref.IntRef descIndex, String $desc) {
        int n;
        if (ownerIndex.element < $owner.length()) {
            int n2 = ownerIndex.element;
            ownerIndex.element = n2 + 1;
            n = $owner.charAt(n2);
        } else if (!hadSeparator.element) {
            int n3;
            int it = n3 = 35;
            boolean bl = false;
            hadSeparator.element = true;
            n = n3;
        } else if (nameIndex.element < $name.length()) {
            int n4 = nameIndex.element;
            nameIndex.element = n4 + 1;
            n = $name.charAt(n4);
        } else if (descIndex.element < $desc.length()) {
            int n5 = descIndex.element;
            descIndex.element = n5 + 1;
            n = $desc.charAt(n5);
        } else {
            n = 0;
        }
        return (char)n;
    }

    static {
        String[] stringArray = new String[]{"android/util/SparseArray#set(ILjava/lang/Object;)V", "java/lang/Boolean#compare(ZZ)I", "java/lang/Boolean#hashCode(Z)I", "java/lang/Boolean#logicalAnd(ZZ)Z", "java/lang/Boolean#logicalOr(ZZ)Z", "java/lang/Boolean#logicalXor(ZZ)Z", "java/lang/Byte#compare(BB)I", "java/lang/Byte#compareUnsigned(BB)I", "java/lang/Byte#hashCode(B)I", "java/lang/Byte#toUnsignedInt(B)I", "java/lang/Byte#toUnsignedLong(B)J", "java/lang/CharSequence#compare(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)I", "java/lang/Character#compare(CC)I", "java/lang/Character#hashCode(C)I", "java/lang/Character#toString(I)Ljava/lang/String;", "java/lang/Double#hashCode(D)I", "java/lang/Double#isFinite(D)Z", "java/lang/Double#max(DD)D", "java/lang/Double#min(DD)D", "java/lang/Double#sum(DD)D", "java/lang/Float#hashCode(F)I", "java/lang/Float#isFinite(F)Z", "java/lang/Float#max(FF)F", "java/lang/Float#min(FF)F", "java/lang/Float#sum(FF)F", "java/lang/Integer#compare(II)I", "java/lang/Integer#compareUnsigned(II)I", "java/lang/Integer#divideUnsigned(II)I", "java/lang/Integer#hashCode(I)I", "java/lang/Integer#max(II)I", "java/lang/Integer#min(II)I", "java/lang/Integer#parseInt(Ljava/lang/CharSequence;III)I", "java/lang/Integer#parseUnsignedInt(Ljava/lang/String;)I", "java/lang/Integer#parseUnsignedInt(Ljava/lang/String;I)I", "java/lang/Integer#remainderUnsigned(II)I", "java/lang/Integer#sum(II)I", "java/lang/Integer#toUnsignedLong(I)J", "java/lang/Integer#toUnsignedString(I)Ljava/lang/String;", "java/lang/Integer#toUnsignedString(II)Ljava/lang/String;", "java/lang/Long#compare(JJ)I", "java/lang/Long#compareUnsigned(JJ)I", "java/lang/Long#divideUnsigned(JJ)J", "java/lang/Long#hashCode(J)I", "java/lang/Long#max(JJ)J", "java/lang/Long#min(JJ)J", "java/lang/Long#parseLong(Ljava/lang/CharSequence;III)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/CharSequence;III)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/String;)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/String;I)J", "java/lang/Long#remainderUnsigned(JJ)J", "java/lang/Long#sum(JJ)J", "java/lang/Long#toUnsignedString(J)Ljava/lang/String;", "java/lang/Long#toUnsignedString(JI)Ljava/lang/String;", "java/lang/Math#addExact(II)I", "java/lang/Math#addExact(JJ)J", "java/lang/Math#decrementExact(I)I", "java/lang/Math#decrementExact(J)J", "java/lang/Math#floorDiv(II)I", "java/lang/Math#floorDiv(JI)J", "java/lang/Math#floorDiv(JJ)J", "java/lang/Math#floorMod(II)I", "java/lang/Math#floorMod(JI)I", "java/lang/Math#floorMod(JJ)J", "java/lang/Math#incrementExact(I)I", "java/lang/Math#incrementExact(J)J", "java/lang/Math#multiplyExact(II)I", "java/lang/Math#multiplyExact(JI)J", "java/lang/Math#multiplyExact(JJ)J", "java/lang/Math#multiplyFull(II)J", "java/lang/Math#multiplyHigh(JJ)J", "java/lang/Math#negateExact(I)I", "java/lang/Math#negateExact(J)J", "java/lang/Math#nextDown(D)D", "java/lang/Math#nextDown(F)F", "java/lang/Math#subtractExact(II)I", "java/lang/Math#subtractExact(JJ)J", "java/lang/Math#toIntExact(J)I", "java/lang/Short#compare(SS)I", "java/lang/Short#compareUnsigned(SS)I", "java/lang/Short#hashCode(S)I", "java/lang/Short#toUnsignedInt(S)I", "java/lang/Short#toUnsignedLong(S)J", "java/lang/StrictMath#addExact(II)I", "java/lang/StrictMath#addExact(JJ)J", "java/lang/StrictMath#floorDiv(II)I", "java/lang/StrictMath#floorDiv(JI)J", "java/lang/StrictMath#floorDiv(JJ)J", "java/lang/StrictMath#floorMod(II)I", "java/lang/StrictMath#floorMod(JI)I", "java/lang/StrictMath#floorMod(JJ)J", "java/lang/StrictMath#multiplyExact(II)I", "java/lang/StrictMath#multiplyExact(JI)J", "java/lang/StrictMath#multiplyExact(JJ)J", "java/lang/StrictMath#multiplyFull(II)J", "java/lang/StrictMath#multiplyHigh(JJ)J", "java/lang/StrictMath#nextDown(D)D", "java/lang/StrictMath#nextDown(F)F", "java/lang/StrictMath#subtractExact(II)I", "java/lang/StrictMath#subtractExact(JJ)J", "java/lang/StrictMath#toIntExact(J)I", "java/lang/String#isBlank()Z", "java/lang/String#join(Ljava/lang/CharSequence;Ljava/lang/Iterable;)Ljava/lang/String;", "java/lang/String#join(Ljava/lang/CharSequence;[Ljava/lang/CharSequence;)Ljava/lang/String;", "java/lang/String#repeat(I)Ljava/lang/String;", "java/lang/String#strip()Ljava/lang/String;", "java/lang/String#stripLeading()Ljava/lang/String;", "java/lang/String#stripTrailing()Ljava/lang/String;", "java/util/Collections#emptyEnumeration()Ljava/util/Enumeration;", "java/util/Collections#emptyIterator()Ljava/util/Iterator;", "java/util/Collections#emptyListIterator()Ljava/util/ListIterator;", "java/util/List#copyOf(Ljava/util/Collection;)Ljava/util/List;", "java/util/List#of()Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of([Ljava/lang/Object;)Ljava/util/List;", "java/util/Map#copyOf(Ljava/util/Map;)Ljava/util/Map;", "java/util/Map#entry(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;", "java/util/Map#of()Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#ofEntries([Ljava/util/Map$Entry;)Ljava/util/Map;", "java/util/Objects#checkFromIndexSize(III)I", "java/util/Objects#checkFromToIndex(III)I", "java/util/Objects#checkIndex(II)I", "java/util/Objects#compare(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Comparator;)I", "java/util/Objects#deepEquals(Ljava/lang/Object;Ljava/lang/Object;)Z", "java/util/Objects#equals(Ljava/lang/Object;Ljava/lang/Object;)Z", "java/util/Objects#hash([Ljava/lang/Object;)I", "java/util/Objects#hashCode(Ljava/lang/Object;)I", "java/util/Objects#isNull(Ljava/lang/Object;)Z", "java/util/Objects#nonNull(Ljava/lang/Object;)Z", "java/util/Objects#requireNonNull(Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Objects#requireNonNull(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "java/util/Objects#requireNonNullElse(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Objects#requireNonNullElseGet(Ljava/lang/Object;Ljava/util/function/Supplier;)Ljava/lang/Object;", "java/util/Objects#toString(Ljava/lang/Object;)Ljava/lang/String;", "java/util/Objects#toString(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;", "java/util/Set#copyOf(Ljava/util/Collection;)Ljava/util/Set;", "java/util/Set#of()Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of([Ljava/lang/Object;)Ljava/util/Set;"};
        defaultDesugaredMethods = stringArray;
        lookup = new DesugaredMethodLookup(defaultDesugaredMethods);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001a\u0010\u000b\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 R\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/DesugaredMethodLookup$Companion;", "", "()V", "defaultDesugaredMethods", "", "", "getDefaultDesugaredMethods", "()[Ljava/lang/String;", "[Ljava/lang/String;", "lookup", "Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "getLookup", "()Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "setLookup", "(Lcom/android/tools/lint/checks/DesugaredMethodLookup;)V", "createDesugaredMethodLookup", "files", "", "Ljava/io/File;", "project", "Lcom/android/tools/lint/detector/api/Project;", "sourceSetType", "Lcom/android/tools/lint/detector/api/SourceSetType;", "isDesugared", "", "owner", "name", "desc", "reset", "", "setDesugaredMethods", "paths", "", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nDesugaredMethodLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesugaredMethodLookup.kt\ncom/android/tools/lint/checks/DesugaredMethodLookup$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,394:1\n37#2,2:395\n37#2,2:397\n*S KotlinDebug\n*F\n+ 1 DesugaredMethodLookup.kt\ncom/android/tools/lint/checks/DesugaredMethodLookup$Companion\n*L\n179#1:395,2\n199#1:397,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDesugared(@NotNull String owner, @NotNull String name, @NotNull String desc, @NotNull SourceSetType sourceSetType, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Intrinsics.checkNotNullParameter((Object)((Object)sourceSetType), (String)"sourceSetType");
            return this.getLookup(project, sourceSetType).isDesugared(owner, name, desc);
        }

        public static /* synthetic */ boolean isDesugared$default(Companion companion, String string, String string2, String string3, SourceSetType sourceSetType, Project project, int n, Object object) {
            if ((n & 0x10) != 0) {
                project = null;
            }
            return companion.isDesugared(string, string2, string3, sourceSetType, project);
        }

        private final DesugaredMethodLookup getLookup(Project project, SourceSetType sourceSetType) {
            LintModelVariant model2;
            if (project != null && (model2 = project.getBuildVariant()) != null) {
                Collection<File> desugaredMethodsFiles;
                LintModelAndroidArtifact modelArtifact;
                Collection<File> collection;
                if ((collection = (modelArtifact = (switch (WhenMappings.$EnumSwitchMapping$0[sourceSetType.ordinal()]) {
                    case 1 -> model2.getMainArtifact();
                    case 2 -> model2.getAndroidTestArtifact();
                    case 3 -> model2.getTestFixturesArtifact();
                    default -> null;
                }))) == null || (collection = collection.getDesugaredMethodsFiles()) == null) {
                    collection = model2.getDesugaredMethodsFiles();
                }
                if (!(desugaredMethodsFiles = collection).isEmpty()) {
                    DesugaredMethodLookup lookup = (DesugaredMethodLookup)project.getClientProperty((Object)sourceSetType);
                    if (lookup != null) {
                        return lookup;
                    }
                    DesugaredMethodLookup newLookup = this.createDesugaredMethodLookup(desugaredMethodsFiles);
                    project.putClientProperty((Object)sourceSetType, newLookup);
                    return newLookup;
                }
            }
            return this.getLookup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final String setDesugaredMethods(@NotNull List<String> paths) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            lines = new ArrayList<String>(1024);
            for (String path : paths) {
                try {
                    if (StringsKt.startsWith$default((String)path, (String)"jar:", (boolean)false, (int)2, null)) {
                        url = new URL(path);
                        v0 = url.openConnection();
                        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type java.net.JarURLConnection");
                        connection = (JarURLConnection)v0;
                        var7_11 = connection.getJarFile();
                        var8_12 = null;
                        try {
                            jarFile = (JarFile)var7_11;
                            $i$a$-use-DesugaredMethodLookup$Companion$setDesugaredMethods$1 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)jarFile.getInputStream(connection.getJarEntry()), (String)"jarFile.getInputStream(connection.jarEntry)");
                            var12_18 = Charsets.UTF_8;
                            var13_19 = new InputStreamReader(var11_17, var12_18);
                            var14_20 = 8192;
                            TextStreamsKt.forEachLine((Reader)(var13_19 instanceof BufferedReader != false ? (BufferedReader)var13_19 : new BufferedReader(var13_19, var14_20)), (Function1)((Function1)new Function1<String, Unit>(lines){
                                final /* synthetic */ ArrayList<String> $lines;
                                {
                                    this.$lines = $lines;
                                    super(1);
                                }

                                public final void invoke(@NotNull String it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    if (!StringsKt.isBlank((CharSequence)it)) {
                                        this.$lines.add(it);
                                    }
                                }
                            }));
                            var9_13 = Unit.INSTANCE;
                            continue;
                        }
                        catch (Throwable var9_14) {
                            var8_12 = var9_14;
                            throw var9_14;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var7_11, (Throwable)var8_12);
                            continue;
                        }
                    }
                    v1 = file = StringsKt.startsWith$default((String)path, (String)"file:", (boolean)false, (int)2, null) != false ? SdkUtils.urlToFile((URL)new URL(path)) : new File(path);
                    if (!file.isFile()) {
                        return path;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    FilesKt.forEachLine$default((File)file, null, (Function1)((Function1)new Function1<String, Unit>(lines){
                        final /* synthetic */ ArrayList<String> $lines;
                        {
                            this.$lines = $lines;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (!StringsKt.isBlank((CharSequence)it)) {
                                this.$lines.add(it);
                            }
                        }
                    }), (int)1, null);
                }
                catch (IOException throwable) {
                    return path;
                }
            }
            CollectionsKt.sort((List)lines);
            if (!(((Collection)lines).isEmpty() == false)) ** GOTO lbl-1000
            v2 = lines.get(0);
            Intrinsics.checkNotNullExpressionValue(v2, (String)"lines[0]");
            if (!StringsKt.endsWith$default((CharSequence)((CharSequence)v2), (char)'\r', (boolean)false, (int)2, null)) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = var3_4 = false;
            }
            if (_Assertions.ENABLED && !var3_4) {
                path = "Assertion failed";
                throw new AssertionError((Object)path);
            }
            $this$toTypedArray$iv = CollectionsKt.distinct((Iterable)lines);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            this.setLookup(new DesugaredMethodLookup(thisCollection$iv.toArray(new String[0])));
            return null;
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        private final DesugaredMethodLookup createDesugaredMethodLookup(Collection<? extends File> files) {
            v0 = var2_2 = files.isEmpty() == false;
            if (_Assertions.ENABLED && !var2_2) {
                var3_4 = "Assertion failed";
                throw new AssertionError((Object)var3_4);
            }
            lines = new ArrayList<String>(1024);
            for (Object file : files) {
                FilesKt.forEachLine$default((File)file, null, (Function1)((Function1)new Function1<String, Unit>(lines){
                    final /* synthetic */ ArrayList<String> $lines;
                    {
                        this.$lines = $lines;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (!StringsKt.isBlank((CharSequence)it)) {
                            this.$lines.add(it);
                        }
                    }
                }), (int)1, null);
            }
            CollectionsKt.sort((List)lines);
            if (!(((Collection)lines).isEmpty() == false)) ** GOTO lbl-1000
            v1 = lines.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"lines[0]");
            if (!StringsKt.endsWith$default((CharSequence)v1, (char)'\r', (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = var3_6 = false;
            }
            if (_Assertions.ENABLED && !var3_6) {
                file = "Assertion failed";
                throw new AssertionError(file);
            }
            $this$toTypedArray$iv = CollectionsKt.distinct((Iterable)lines);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            return new DesugaredMethodLookup(thisCollection$iv.toArray(new String[0]));
        }

        @TestOnly
        public final void reset() {
            this.setLookup(new DesugaredMethodLookup(this.getDefaultDesugaredMethods()));
        }

        @VisibleForTesting
        @NotNull
        public final String[] getDefaultDesugaredMethods() {
            return defaultDesugaredMethods;
        }

        @NotNull
        public final DesugaredMethodLookup getLookup() {
            return lookup;
        }

        public final void setLookup(@NotNull DesugaredMethodLookup desugaredMethodLookup) {
            Intrinsics.checkNotNullParameter((Object)desugaredMethodLookup, (String)"<set-?>");
            lookup = desugaredMethodLookup;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SourceSetType.values().length];
                try {
                    nArray[SourceSetType.MAIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SourceSetType.INSTRUMENTATION_TESTS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SourceSetType.TEST_FIXTURES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

