/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.checks.DataFlowAnalyzerKt;
import com.android.tools.lint.checks.TargetMethodDataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J9\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0010\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J0\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u000bH\u0016J \u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkEditorApplied", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "checkRecycled", "recycleType", "", "recycleNames", "", "(Lcom/android/tools/lint/detector/api/JavaContext;Lorg/jetbrains/uast/UCallExpression;Ljava/lang/String;[Ljava/lang/String;)V", "checkResourceRecycled", "method", "checkTransactionCommits", "getApplicableConstructorTypes", "", "getApplicableMethodNames", "isBeginTransaction", "", "isMethodOnFragmentClass", "fragmentClass", "platformFragmentClass", "v4FragmentClass", "isSharedEditorCreation", "suggestApplyIfApplicable", "visitConstructor", "constructor", "visitMethodCall", "Companion", "android.sdktools.lint-checks"})
public final class CleanupDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue RECYCLE_RESOURCE;
    @JvmField
    @NotNull
    public static final Issue COMMIT_FRAGMENT;
    @JvmField
    @NotNull
    public static final Issue SHARED_PREF;
    @JvmField
    @NotNull
    public static final Issue APPLY_SHARED_PREF;
    @NotNull
    private static final String OF_INT = "ofInt";
    @NotNull
    private static final String OF_ARGB = "ofArgb";
    @NotNull
    private static final String OF_FLOAT = "ofFloat";
    @NotNull
    private static final String OF_OBJECT = "ofObject";
    @NotNull
    private static final String OF_PROPERTY_VALUES_HOLDER = "ofPropertyValuesHolder";
    @NotNull
    private static final String START = "start";
    @NotNull
    private static final String RECYCLE = "recycle";
    @NotNull
    private static final String RELEASE = "release";
    @NotNull
    private static final String OBTAIN = "obtain";
    @NotNull
    private static final String SHOW = "show";
    @NotNull
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    @NotNull
    private static final String ACQUIRE_UNSTABLE_CPC = "acquireUnstableContentProviderClient";
    @NotNull
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    @NotNull
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    @NotNull
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    @NotNull
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    @NotNull
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    @NotNull
    private static final String COMMIT = "commit";
    @NotNull
    private static final String COMMIT_NOW = "commitNow";
    @NotNull
    private static final String APPLY = "apply";
    @NotNull
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    @NotNull
    private static final String COMMIT_NOW_ALLOWING_LOSS = "commitNowAllowingStateLoss";
    @NotNull
    private static final String QUERY = "query";
    @NotNull
    private static final String RAW_QUERY = "rawQuery";
    @NotNull
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    @NotNull
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    @NotNull
    private static final String CLOSE = "close";
    @NotNull
    private static final String CLOSE_WITH_ERROR = "closeWithError";
    @NotNull
    private static final String EDIT = "edit";
    @NotNull
    private static final String OPEN_ASSET_FILE = "openAssetFile";
    @NotNull
    private static final String OPEN_ASSET_FILE_DESCRIPTOR = "openAssetFileDescriptor";
    @NotNull
    private static final String OPEN_FILE = "openFile";
    @NotNull
    private static final String OPEN_FILE_DESCRIPTOR = "openFileDescriptor";
    @NotNull
    private static final String OPEN_INPUT_STREAM = "openInputStream";
    @NotNull
    private static final String OPEN_OUTPUT_STREAM = "openOutputStream";
    @NotNull
    private static final String OPEN_TYPED_ASSET_FILE = "openTypedAssetFile";
    @NotNull
    private static final String OPEN_TYPED_ASSET_FILE_DESCRIPTOR = "openTypedAssetFileDescriptor";
    @NotNull
    public static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    @NotNull
    private static final String PARCEL_CLS = "android.os.Parcel";
    @NotNull
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    @NotNull
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    @NotNull
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    @NotNull
    private static final String DIALOG_ANDROIDX_FRAGMENT = "androidx.fragment.app.DialogFragment";
    @NotNull
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_MANAGER_ANDROIDX_CLS = "androidx.fragment.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_ANDROIDX_CLS = "androidx.fragment.app.FragmentTransaction";
    @NotNull
    private static final String VALUE_ANIMATOR_CLS = "android.animation.ValueAnimator";
    @NotNull
    private static final String OBJECT_ANIMATOR_CLS = "android.animation.ObjectAnimator";
    @NotNull
    private static final String ANIMATOR_SET_CLS = "android.animation.AnimatorSet";
    @NotNull
    public static final String SURFACE_CLS = "android.view.Surface";
    @NotNull
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    @NotNull
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    @NotNull
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    @NotNull
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    @NotNull
    public static final String CURSOR_CLS = "android.database.Cursor";
    @NotNull
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    @NotNull
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";
    @NotNull
    private static final String ASSET_FILE_DESCRIPTOR_CLS = "android.content.res.AssetFileDescriptor";
    @NotNull
    private static final String INPUT_STREAM_CLS = "java.io.InputStream";
    @NotNull
    private static final String OUTPUT_STREAM_CLS = "java.io.OutputStream";
    @NotNull
    private static final String PARCEL_FILE_DESCRIPTOR_CLS = "android.os.ParcelFileDescriptor";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, ACQUIRE_UNSTABLE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY, OPEN_ASSET_FILE, OPEN_ASSET_FILE_DESCRIPTOR, OPEN_TYPED_ASSET_FILE, OPEN_TYPED_ASSET_FILE_DESCRIPTOR, OPEN_INPUT_STREAM, OPEN_OUTPUT_STREAM, OPEN_FILE, OPEN_FILE_DESCRIPTOR, EDIT, OF_INT, OF_ARGB, OF_FLOAT, OF_OBJECT, OF_PROPERTY_VALUES_HOLDER};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getApplicableConstructorTypes() {
        Object[] objectArray = new String[]{SURFACE_TEXTURE_CLS, SURFACE_CLS, VALUE_ANIMATOR_CLS, OBJECT_ANIMATOR_CLS, ANIMATOR_SET_CLS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method.getName()) {
            case "beginTransaction": {
                this.checkTransactionCommits(context2, node, method);
                break;
            }
            case "edit": {
                this.checkEditorApplied(context2, node, method);
                break;
            }
            default: {
                this.checkResourceRecycled(context2, node, method);
            }
        }
    }

    @Override
    public void visitConstructor(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Object object = constructor.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object type2 = object;
        if (UastLintUtilsKt.isThisOrSuperConstructorCall(node)) {
            return;
        }
        if (Intrinsics.areEqual((Object)type2, (Object)SURFACE_TEXTURE_CLS) || Intrinsics.areEqual((Object)type2, (Object)SURFACE_CLS)) {
            String[] stringArray = new String[]{RELEASE};
            this.checkRecycled(context2, node, (String)type2, stringArray);
        } else {
            String[] stringArray = new String[]{START};
            this.checkRecycled(context2, node, (String)type2, stringArray);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkResourceRecycled(JavaContext context, UCallExpression node, PsiMethod method) {
        block76: {
            v0 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"method.name");
            name = v0;
            v1 = method.getContainingClass();
            if (v1 == null) {
                return;
            }
            containingClass = v1;
            evaluator = context.getEvaluator();
            var7_7 = name;
            tmp = -1;
            switch (var7_7.hashCode()) {
                case -1023074139: {
                    if (var7_7.equals("obtain")) {
                        tmp = 1;
                    }
                    break;
                }
                case 1143130466: {
                    if (var7_7.equals("openAssetFile")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1200563244: {
                    if (var7_7.equals("openTypedAssetFile")) {
                        tmp = 2;
                    }
                    break;
                }
                case -505062682: {
                    if (var7_7.equals("openFile")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1020883133: {
                    if (var7_7.equals("ofArgb")) {
                        tmp = 4;
                    }
                    break;
                }
                case 1175030894: {
                    if (var7_7.equals("obtainNoHistory")) {
                        tmp = 1;
                    }
                    break;
                }
                case 107944136: {
                    if (var7_7.equals("query")) {
                        tmp = 5;
                    }
                    break;
                }
                case 1253904020: {
                    if (var7_7.equals("obtainTypedArray")) {
                        tmp = 6;
                    }
                    break;
                }
                case -1535764801: {
                    if (var7_7.equals("acquireContentProviderClient")) {
                        tmp = 7;
                    }
                    break;
                }
                case -1578159419: {
                    if (var7_7.equals("ofFloat")) {
                        tmp = 4;
                    }
                    break;
                }
                case 1802996923: {
                    if (var7_7.equals("openTypedAssetFileDescriptor")) {
                        tmp = 2;
                    }
                    break;
                }
                case -386691204: {
                    if (var7_7.equals("queryWithFactory")) {
                        tmp = 5;
                    }
                    break;
                }
                case -608262543: {
                    if (var7_7.equals("openAssetFileDescriptor")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1188314052: {
                    if (var7_7.equals("rawQueryWithFactory")) {
                        tmp = 5;
                    }
                    break;
                }
                case 1316941135: {
                    if (var7_7.equals("obtainStyledAttributes")) {
                        tmp = 6;
                    }
                    break;
                }
                case 11042906: {
                    if (var7_7.equals("ofPropertyValuesHolder")) {
                        tmp = 4;
                    }
                    break;
                }
                case 105623192: {
                    if (var7_7.equals("ofInt")) {
                        tmp = 4;
                    }
                    break;
                }
                case -1430020106: {
                    if (var7_7.equals("ofObject")) {
                        tmp = 4;
                    }
                    break;
                }
                case -30661899: {
                    if (var7_7.equals("openFileDescriptor")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1190057141: {
                    if (var7_7.equals("openOutputStream")) {
                        tmp = 8;
                    }
                    break;
                }
                case -2141281472: {
                    if (var7_7.equals("openInputStream")) {
                        tmp = 9;
                    }
                    break;
                }
                case -1652302884: {
                    if (var7_7.equals("obtainAttributes")) {
                        tmp = 6;
                    }
                    break;
                }
                case -63640053: {
                    if (var7_7.equals("acquireUnstableContentProviderClient")) {
                        tmp = 7;
                    }
                    break;
                }
                case 490686848: {
                    if (var7_7.equals("rawQuery")) {
                        tmp = 5;
                    }
                    break;
                }
            }
            block26 : switch (tmp) {
                case 1: {
                    if (evaluator.extendsClass(containingClass, "android.view.MotionEvent", false)) {
                        var8_8 = new String[]{"recycle"};
                        this.checkRecycled(context, node, "android.view.MotionEvent", var8_8);
                        break;
                    }
                    if (evaluator.extendsClass(containingClass, "android.os.Parcel", false)) {
                        var8_9 = new String[]{"recycle"};
                        this.checkRecycled(context, node, "android.os.Parcel", var8_9);
                        break;
                    }
                    if (!evaluator.extendsClass(containingClass, "android.view.VelocityTracker", false)) break;
                    var8_10 = new String[]{"recycle"};
                    this.checkRecycled(context, node, "android.view.VelocityTracker", var8_10);
                    break;
                }
                case 6: {
                    if (!evaluator.extendsClass(containingClass, "android.content.Context", false) && !evaluator.extendsClass(containingClass, "android.content.res.Resources", false) || !((returnType = method.getReturnType()) instanceof PsiClassType) || (cls = ((PsiClassType)returnType).resolve()) == null || !Intrinsics.areEqual((Object)"android.content.res.TypedArray", (Object)cls.getQualifiedName())) break;
                    var10_21 = new String[]{"recycle"};
                    this.checkRecycled(context, node, "android.content.res.TypedArray", var10_21);
                    break;
                }
                case 7: {
                    if (!evaluator.extendsClass(containingClass, "android.content.ContentResolver", false)) break;
                    returnType = new String[]{"release", "close"};
                    this.checkRecycled(context, node, "android.content.ContentProviderClient", returnType);
                    break;
                }
                case 5: {
                    if (!evaluator.extendsClass(containingClass, "android.database.sqlite.SQLiteDatabase", false) && !evaluator.extendsClass(containingClass, "android.content.ContentResolver", false) && !evaluator.extendsClass(containingClass, "android.content.ContentProvider", false) && !evaluator.extendsClass(containingClass, "android.content.ContentProviderClient", false)) break;
                    returnType = new String[]{"close"};
                    this.checkRecycled(context, node, "android.database.Cursor", returnType);
                    break;
                }
                case 2: {
                    if (!evaluator.extendsClass(containingClass, "android.content.ContentResolver", false) && !evaluator.extendsClass(containingClass, "android.content.ContentProviderClient", false)) break;
                    returnType = new String[]{"close"};
                    this.checkRecycled(context, node, "android.content.res.AssetFileDescriptor", returnType);
                    break;
                }
                case 3: {
                    if (!evaluator.extendsClass(containingClass, "android.content.ContentResolver", false) && !evaluator.extendsClass(containingClass, "android.content.ContentProviderClient", false)) break;
                    returnType = new String[]{"close", "closeWithError"};
                    this.checkRecycled(context, node, "android.os.ParcelFileDescriptor", returnType);
                    break;
                }
                case 9: {
                    if (!evaluator.extendsClass(containingClass, "android.content.ContentResolver", false)) break;
                    returnType = new String[]{"close"};
                    this.checkRecycled(context, node, "java.io.InputStream", returnType);
                    break;
                }
                case 8: {
                    if (!evaluator.extendsClass(containingClass, "android.content.ContentResolver", false)) break;
                    returnType = new String[]{"close"};
                    this.checkRecycled(context, node, "java.io.OutputStream", returnType);
                    break;
                }
                case 4: {
                    returnType = method.getReturnType();
                    if (!(returnType instanceof PsiClassType)) break;
                    v2 = ((PsiClassType)returnType).getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"returnType.canonicalText");
                    type = v2;
                    switch (type.hashCode()) {
                        case -1710703185: {
                            if (!type.equals("android.animation.ObjectAnimator")) {
                                break block26;
                            }
                            ** GOTO lbl201
                        }
                        case -1645485518: {
                            if (!type.equals("android.animation.AnimatorSet")) {
                                break block26;
                            }
                            ** GOTO lbl201
                        }
                        case -1131383825: {
                            if (!type.equals("android.animation.ValueAnimator")) break block76;
lbl201:
                            // 3 sources

                            var10_22 = new String[]{"start"};
                            this.checkRecycled(context, node, type, var10_22);
                        }
                    }
                }
            }
        }
    }

    private final void checkRecycled(JavaContext context2, UCallExpression node, String recycleType, String ... recycleNames) {
        List list2;
        PsiElement psi = node.getSourcePsi();
        if (psi != null && Lint.isJava(psi) && PsiTreeUtil.getParentOfType((PsiElement)psi, PsiResourceVariable.class) != null) {
            return;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        Set set = SetsKt.setOf((Object)node);
        TargetMethodDataFlowAnalyzer visitor2 = new TargetMethodDataFlowAnalyzer(recycleNames, recycleType, context2, set, list2 = CollectionsKt.emptyList()){
            final /* synthetic */ String[] $recycleNames;
            final /* synthetic */ String $recycleType;
            final /* synthetic */ JavaContext $context;
            {
                this.$recycleNames = $recycleNames;
                this.$recycleType = $recycleType;
                this.$context = $context;
                super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
            }

            public boolean isTargetMethodName(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return Intrinsics.areEqual((Object)name, (Object)"use") || ArraysKt.contains((Object[])this.$recycleNames, (Object)name);
            }

            public boolean isTargetMethod(@NotNull String name, @Nullable PsiMethod method, @Nullable UCallExpression call, @Nullable UCallableReferenceExpression methodRef) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (Intrinsics.areEqual((Object)"use", (Object)name)) {
                    PsiType argumentType;
                    if (call != null && call.getValueArgumentCount() == 1 && (argumentType = UastLintUtilsKt.skipLabeledExpression((UExpression)CollectionsKt.first((List)call.getValueArguments())).getExpressionType()) != null && LambdaUtil.isFunctionalType((PsiType)argumentType)) {
                        return true;
                    }
                    if (!ArraysKt.contains((Object[])this.$recycleNames, (Object)name)) {
                        return false;
                    }
                }
                if (method != null) {
                    PsiClass containingClass = method.getContainingClass();
                    Object object = containingClass;
                    if (object == null || (object = object.getQualifiedName()) == null) {
                        return true;
                    }
                    Object targetName = object;
                    if (Intrinsics.areEqual((Object)targetName, (Object)this.$recycleType)) {
                        return true;
                    }
                    PsiClass psiClass = this.$context.getEvaluator().findClass(this.$recycleType);
                    if (psiClass == null) {
                        return true;
                    }
                    PsiClass recycleClass = psiClass;
                    return this.$context.getEvaluator().extendsClass(recycleClass, (String)targetName, false);
                }
                return true;
            }

            public boolean visitTryExpression(@NotNull UTryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getHasResources() && ArraysKt.contains((Object[])this.$recycleNames, (Object)"close")) {
                    PsiResourceList resourceList;
                    PsiElement psiElement = node.getSourcePsi();
                    PsiTryStatement psiTryStatement = psiElement instanceof PsiTryStatement ? (PsiTryStatement)psiElement : null;
                    Object object = resourceList = psiTryStatement != null ? psiTryStatement.getResourceList() : null;
                    if (resourceList != null) {
                        for (PsiResourceListElement child : resourceList) {
                            PsiReferenceExpression expression;
                            PsiExpression psiExpression;
                            if (!(child instanceof PsiResourceExpression) || ((psiExpression = ((PsiResourceExpression)child).getExpression()) instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiExpression : null) == null) continue;
                            expression = expression;
                            PsiElement resolved = expression.resolve();
                            if (!CollectionsKt.contains((Iterable)this.getReferences(), (Object)resolved)) continue;
                            this.setTargetReached(true);
                            this.setTargetReference((UElement)node);
                            break;
                        }
                    }
                }
                return super.visitTryExpression(node);
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                PsiMethod resolved;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                if (Intrinsics.areEqual((Object)this.$recycleType, (Object)"android.graphics.SurfaceTexture") && UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) && (resolved = call.resolve()) != null && this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.Surface")) {
                    return;
                }
                if (Intrinsics.areEqual((Object)"obtain", (Object)Lint.getMethodName(call))) {
                    resolved = call.resolve();
                    if (this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.MotionEvent")) {
                        return;
                    }
                }
                super.argument(call, reference);
            }

            private final String name(UCallExpression $this$name) {
                String string = $this$name.getMethodName();
                if (string == null) {
                    UIdentifier uIdentifier = $this$name.getMethodIdentifier();
                    string = uIdentifier != null ? uIdentifier.getName() : null;
                }
                return string;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean returnsSelf(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                boolean returnsSelf = super.returnsSelf(call);
                if (returnsSelf) {
                    return true;
                }
                switch (this.$recycleType) {
                    case "android.content.res.AssetFileDescriptor": {
                        String string = this.name(call);
                        if (string == null) return false;
                        switch (string.hashCode()) {
                            case 135710465: {
                                if (string.equals("getFileDescriptor")) return true;
                                return false;
                            }
                            case 1907572458: {
                                if (string.equals("getParcelFileDescriptor")) return true;
                                return false;
                            }
                            case 1861626621: {
                                if (string.equals("createOutputStream")) return true;
                                return false;
                            }
                            case 451011918: {
                                if (!string.equals("createInputStream")) return false;
                                return true;
                            }
                        }
                        return false;
                    }
                    case "android.os.ParcelFileDescriptor": {
                        String string = this.name(call);
                        if (Intrinsics.areEqual((Object)string, (Object)"getFileDescriptor")) {
                            return true;
                        }
                        boolean bl = Intrinsics.areEqual((Object)string, (Object)"detachFd");
                        if (!bl) return false;
                        return true;
                    }
                    case "java.io.OutputStream": 
                    case "java.io.InputStream": {
                        PsiMethod psiMethod;
                        String string = this.name(call);
                        if (string == null) {
                            return false;
                        }
                        String callName = string;
                        if (Intrinsics.areEqual((Object)callName, (Object)"source")) return Intrinsics.areEqual((Object)(psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"okio.Okio");
                        if (!Intrinsics.areEqual((Object)callName, (Object)"sink")) return false;
                        psiMethod = call.resolve();
                        return Intrinsics.areEqual((Object)(psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"okio.Okio");
                    }
                }
                return false;
            }
        };
        if (!DataFlowAnalyzerKt.isMissingTarget$default(method, visitor2, false, 2, null)) {
            return;
        }
        String string = recycleType.substring(StringsKt.lastIndexOf$default((CharSequence)recycleType, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String className = string;
        String recycleName = (String)ArraysKt.first((Object[])recycleNames);
        String message2 = Intrinsics.areEqual((Object)recycleName, (Object)RECYCLE) ? "This `" + className + "` should be recycled after use with `#recycle()`" : (Intrinsics.areEqual((Object)recycleName, (Object)START) ? "This animation should be started with `#start()`" : "This `" + className + "` should be freed up after use with `#" + recycleName + "()`");
        UElement locationNode = (UElement)node.getMethodIdentifier();
        if (locationNode == null) {
            locationNode = (UElement)node;
        }
        Location location2 = context2.getLocation(locationNode);
        JavaContext.report$default(context2, RECYCLE_RESOURCE, (UElement)node, location2, message2, null, 16, null);
    }

    private final void checkTransactionCommits(JavaContext context2, UCallExpression node, PsiMethod calledMethod) {
        if (this.isBeginTransaction(context2, calledMethod)) {
            List list2;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Set set = SetsKt.setOf((Object)node);
            TargetMethodDataFlowAnalyzer visitor2 = new TargetMethodDataFlowAnalyzer(this, context2, set, list2 = CollectionsKt.emptyList()){
                final /* synthetic */ CleanupDetector this$0;
                final /* synthetic */ JavaContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
                }

                public boolean isTargetMethodName(@NotNull String name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    return Intrinsics.areEqual((Object)name, (Object)"show") || StringsKt.startsWith$default((String)name, (String)"commit", (boolean)false, (int)2, null);
                }

                public boolean isTargetMethod(@NotNull String name, @Nullable PsiMethod method) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    if (method == null) {
                        return true;
                    }
                    return switch (name) {
                        case "commitNow", "commitAllowingStateLoss", "commit", "commitNowAllowingStateLoss" -> CleanupDetector.access$isMethodOnFragmentClass(this.this$0, this.$context, method, "androidx.fragment.app.FragmentTransaction", "android.app.FragmentTransaction", "android.support.v4.app.FragmentTransaction");
                        case "show" -> CleanupDetector.access$isMethodOnFragmentClass(this.this$0, this.$context, method, "androidx.fragment.app.DialogFragment", "android.app.DialogFragment", "android.support.v4.app.DialogFragment");
                        default -> false;
                    };
                }
            };
            if (DataFlowAnalyzerKt.isMissingTarget$default(method, visitor2, false, 2, null)) {
                String message2 = "This transaction should be completed with a `commit()` call";
                JavaContext.report$default(context2, COMMIT_FRAGMENT, (UElement)node, context2.getNameLocation((UElement)node), message2, null, 16, null);
            }
        }
    }

    private final boolean isMethodOnFragmentClass(JavaContext context2, PsiMethod method, String fragmentClass, String platformFragmentClass, String v4FragmentClass) {
        PsiClass containingClass = method.getContainingClass();
        JavaEvaluator evaluator = context2.getEvaluator();
        return evaluator.extendsClass(containingClass, fragmentClass, false) || evaluator.extendsClass(containingClass, platformFragmentClass, false) || evaluator.extendsClass(containingClass, v4FragmentClass, false);
    }

    private final void checkEditorApplied(JavaContext context2, UCallExpression node, PsiMethod calledMethod) {
        if (this.isSharedEditorCreation(context2, calledMethod)) {
            List list2;
            if (!((Collection)node.getValueArguments()).isEmpty()) {
                return;
            }
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Set set = SetsKt.setOf((Object)node);
            TargetMethodDataFlowAnalyzer visitor2 = new TargetMethodDataFlowAnalyzer(context2, set, list2 = CollectionsKt.emptyList()){
                final /* synthetic */ JavaContext $context;
                {
                    this.$context = $context;
                    super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
                }

                public boolean isTargetMethodName(@NotNull String name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    return Intrinsics.areEqual((Object)name, (Object)"apply") || Intrinsics.areEqual((Object)name, (Object)"commit");
                }

                public boolean isTargetMethod(@NotNull String name, @Nullable PsiMethod method, @Nullable UCallExpression call, @Nullable UCallableReferenceExpression methodRef) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    String string = name;
                    if (Intrinsics.areEqual((Object)string, (Object)"apply")) {
                        if (method != null) {
                            PsiClass containingClass = method.getContainingClass();
                            JavaEvaluator evaluator = this.$context.getEvaluator();
                            return evaluator.extendsClass(containingClass, "android.content.SharedPreferences.Editor", false);
                        }
                        return call == null || call.getValueArgumentCount() == 0;
                    }
                    if (Intrinsics.areEqual((Object)string, (Object)"commit")) {
                        if (method != null) {
                            PsiClass containingClass = method.getContainingClass();
                            JavaEvaluator evaluator = this.$context.getEvaluator();
                            if (evaluator.extendsClass(containingClass, "android.content.SharedPreferences.Editor", false)) {
                                return true;
                            }
                        } else if (call == null || call.getValueArgumentCount() == 0) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            if (DataFlowAnalyzerKt.isMissingTarget$default(method, visitor2, false, 2, null)) {
                String message2 = "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call";
                JavaContext.report$default(context2, SHARED_PREF, (UElement)node, context2.getLocation((UElement)node), message2, null, 16, null);
            } else {
                UElement targetCall = visitor2.getTargetReference();
                if (targetCall instanceof UCallExpression && Intrinsics.areEqual((Object)((UCallExpression)targetCall).getMethodName(), (Object)COMMIT)) {
                    this.suggestApplyIfApplicable(context2, (UCallExpression)targetCall);
                }
            }
        }
    }

    private final boolean isSharedEditorCreation(JavaContext context2, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)EDIT, (Object)methodName)) {
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass containingClass = psiClass;
            PsiType psiType = method.getReturnType();
            if (psiType == null) {
                return false;
            }
            PsiType type2 = psiType;
            JavaEvaluator evaluator = context2.getEvaluator();
            return evaluator.implementsInterface(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES, false) && evaluator.typeMatches(type2, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR);
        }
        return false;
    }

    private final void suggestApplyIfApplicable(JavaContext context2, UCallExpression node) {
        UElement prev = (UElement)node;
        UElement parent = node.getUastParent();
        while (parent instanceof UReferenceExpression || parent instanceof UParenthesizedExpression) {
            prev = parent;
            parent = parent.getUastParent();
        }
        boolean returnValueIgnored = true;
        UElement uElement = parent;
        if ((((uElement instanceof UCallExpression ? true : uElement instanceof UVariable) ? true : uElement instanceof UPolyadicExpression) ? true : uElement instanceof UUnaryExpression) ? true : uElement instanceof UReturnExpression) {
            returnValueIgnored = false;
        } else if (uElement instanceof UIfExpression) {
            condition = ((UIfExpression)parent).getCondition();
            returnValueIgnored = condition != prev;
        } else if (uElement instanceof UWhileExpression) {
            condition = ((UWhileExpression)parent).getCondition();
            returnValueIgnored = condition != prev;
        } else if (uElement instanceof UDoWhileExpression) {
            condition = ((UDoWhileExpression)parent).getCondition();
            boolean bl = returnValueIgnored = condition != prev;
        }
        if (returnValueIgnored) {
            String message2 = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
            Location location2 = context2.getCallLocation(node, false, true);
            LintFix fix = LintFix.Companion.create().name("Replace commit() with apply()").replace().pattern("(commit)\\s*\\(").with(APPLY).build();
            context2.report(APPLY_SHARED_PREF, (UElement)node, location2, message2, fix);
        }
    }

    private final boolean isBeginTransaction(JavaContext context2, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)BEGIN_TRANSACTION, (Object)methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context2.getEvaluator();
            if (evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_ANDROIDX_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_V4_CLS, false)) {
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
        return Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
        return Companion.getVariableElement(rhs, allowChainedCalls);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
        return Companion.getVariableElement(rhs);
    }

    public static final /* synthetic */ boolean access$isMethodOnFragmentClass(CleanupDetector $this, JavaContext context2, PsiMethod method, String fragmentClass, String platformFragmentClass, String v4FragmentClass) {
        return $this.isMethodOnFragmentClass(context2, method, fragmentClass, platformFragmentClass, v4FragmentClass);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        RECYCLE_RESOURCE = Issue.Companion.create$default(companion, "Recycle", "Missing `recycle()` calls", "\n                Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled \\\n                (with a `recycle()` call) after use. This lint check looks for missing \\\n                `recycle()` calls.", implementation, null, category, 7, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        COMMIT_FRAGMENT = Issue.Companion.create$default(companion, "CommitTransaction", "Missing `commit()` calls", "\n                After creating a `FragmentTransaction`, you typically need to commit it as well\n                ", implementation, null, category, 7, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        SHARED_PREF = Issue.Companion.create$default(companion, "CommitPrefEdits", "Missing `commit()` on `SharedPreference` editor", "\n                After calling `edit()` on a `SharedPreference`, you must call `commit()` or \\\n                `apply()` on the editor to save the results.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        APPLY_SHARED_PREF = Issue.Companion.create$default(companion, "ApplySharedPref", "Use `apply()` on `SharedPreferences`", "\n                Consider using `apply()` instead of `commit` on shared preferences. Whereas \\\n                `commit` blocks and writes its data to persistent storage immediately, `apply` \\\n                will handle it in the background.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020N2\b\b\u0002\u0010O\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020PH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector$Companion;", "", "()V", "ACQUIRE_CPC", "", "ACQUIRE_UNSTABLE_CPC", "ANDROID_CONTENT_SHARED_PREFERENCES", "ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR", "ANIMATOR_SET_CLS", "APPLY", "APPLY_SHARED_PREF", "Lcom/android/tools/lint/detector/api/Issue;", "ASSET_FILE_DESCRIPTOR_CLS", "BEGIN_TRANSACTION", "CLOSE", "CLOSE_WITH_ERROR", "COMMIT", "COMMIT_ALLOWING_LOSS", "COMMIT_FRAGMENT", "COMMIT_NOW", "COMMIT_NOW_ALLOWING_LOSS", "CONTENT_PROVIDER_CLIENT_CLS", "CONTENT_RESOLVER_CLS", "CURSOR_CLS", "DIALOG_ANDROIDX_FRAGMENT", "DIALOG_FRAGMENT", "DIALOG_V4_FRAGMENT", "EDIT", "FRAGMENT_MANAGER_ANDROIDX_CLS", "FRAGMENT_MANAGER_CLS", "FRAGMENT_MANAGER_V4_CLS", "FRAGMENT_TRANSACTION_ANDROIDX_CLS", "FRAGMENT_TRANSACTION_CLS", "FRAGMENT_TRANSACTION_V4_CLS", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INPUT_STREAM_CLS", "MOTION_EVENT_CLS", "OBJECT_ANIMATOR_CLS", "OBTAIN", "OBTAIN_ATTRIBUTES", "OBTAIN_NO_HISTORY", "OBTAIN_STYLED_ATTRIBUTES", "OBTAIN_TYPED_ARRAY", "OF_ARGB", "OF_FLOAT", "OF_INT", "OF_OBJECT", "OF_PROPERTY_VALUES_HOLDER", "OPEN_ASSET_FILE", "OPEN_ASSET_FILE_DESCRIPTOR", "OPEN_FILE", "OPEN_FILE_DESCRIPTOR", "OPEN_INPUT_STREAM", "OPEN_OUTPUT_STREAM", "OPEN_TYPED_ASSET_FILE", "OPEN_TYPED_ASSET_FILE_DESCRIPTOR", "OUTPUT_STREAM_CLS", "PARCEL_CLS", "PARCEL_FILE_DESCRIPTOR_CLS", "QUERY", "QUERY_WITH_FACTORY", "RAW_QUERY", "RAW_QUERY_WITH_FACTORY", "RECYCLE", "RECYCLE_RESOURCE", "RELEASE", "SHARED_PREF", "SHOW", "SQLITE_DATABASE_CLS", "START", "SURFACE_CLS", "SURFACE_TEXTURE_CLS", "VALUE_ANIMATOR_CLS", "VELOCITY_TRACKER_CLS", "getVariableElement", "Lcom/intellij/psi/PsiVariable;", "rhs", "Lorg/jetbrains/uast/UCallExpression;", "allowChainedCalls", "", "allowFields", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return DataFlowAnalyzer.Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
        }

        public static /* synthetic */ PsiVariable getVariableElement$default(Companion companion, UCallExpression uCallExpression, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.getVariableElement(uCallExpression, bl, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, allowChainedCalls, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, false, false, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

