/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/BinderGetCallingInMainThreadDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "Method", "android.sdktools.lint-checks"})
public final class BinderGetCallingInMainThreadDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final Method GET_CALLING_METHODS;
    @NotNull
    private static final List<Method> DISALLOWED_METHODS_LIST;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return GET_CALLING_METHODS.getMethodsNames();
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)node));
        if (uMethod == null) {
            return;
        }
        UMethod containingMethod = uMethod;
        PsiClass psiClass = containingMethod.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        PsiClass psiClass2 = method.getContainingClass();
        if (psiClass2 == null) {
            return;
        }
        PsiClass invokedClass = psiClass2;
        if (JavaEvaluator.inheritsFrom$default(context2.getEvaluator(), invokedClass, GET_CALLING_METHODS.getClassName(), false, 4, null)) {
            for (Method method2 : DISALLOWED_METHODS_LIST) {
                String className = method2.component1();
                List<String> methodNames = method2.component2();
                if (!context2.getEvaluator().inheritsFrom(containingClass, className, true) || !methodNames.contains(containingMethod.getName())) continue;
                Incident incident = new Incident(ISSUE, node, context2.getLocation((UElement)node), "Binder." + method.getName() + "() should not be used inside " + containingMethod.getName() + "()");
                context2.report(incident);
                return;
            }
        }
    }

    static {
        Object[] objectArray = Issue.Companion;
        Object[] objectArray2 = Category.SECURITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(BinderGetCallingInMainThreadDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)objectArray, "BinderGetCallingInMainThread", "Incorrect usage of getCallingUid() or getCallingPid()", "\n                `Binder.getCallingUid()` and `Binder.getCallingPid()` will return information about the current process if called \\\n                inside a thread that is not handling a binder transaction. This can cause security issues. \\\n                If you still want to use your own uid/pid, use `Process.myUid()` or `Process.myPid()`.\n                ", implementation, null, (Category)objectArray2, 9, severity, false, true, null, null, 3344, null);
        objectArray = new String[]{"getCallingUid", "getCallingPid"};
        GET_CALLING_METHODS = new Method("android.os.Binder", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Method[4];
        objectArray2 = new String[]{"onCreate", "onRestart", "onStart"};
        objectArray[0] = new Method("android.app.Activity", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"onCreate", "onBind", "onRebind"};
        objectArray[1] = new Method("android.app.Service", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"onAttach", "onCreate", "onCreateView", "onStart", "onViewCreated"};
        objectArray[2] = new Method("android.app.Fragment", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"onAttach", "onCreate", "onCreateView", "onStart", "onViewCreated"};
        objectArray[3] = new Method("androidx.fragment.app.Fragment", CollectionsKt.listOf((Object[])objectArray2));
        DISALLOWED_METHODS_LIST = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/BinderGetCallingInMainThreadDetector$Companion;", "", "()V", "DISALLOWED_METHODS_LIST", "", "Lcom/android/tools/lint/checks/BinderGetCallingInMainThreadDetector$Method;", "GET_CALLING_METHODS", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/BinderGetCallingInMainThreadDetector$Method;", "", "className", "", "methodsNames", "", "(Ljava/lang/String;Ljava/util/List;)V", "getClassName", "()Ljava/lang/String;", "getMethodsNames", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.lint-checks"})
    private static final class Method {
        @NotNull
        private final String className;
        @NotNull
        private final List<String> methodsNames;

        public Method(@NotNull String className, @NotNull List<String> methodsNames) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter(methodsNames, (String)"methodsNames");
            this.className = className;
            this.methodsNames = methodsNames;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final List<String> getMethodsNames() {
            return this.methodsNames;
        }

        @NotNull
        public final String component1() {
            return this.className;
        }

        @NotNull
        public final List<String> component2() {
            return this.methodsNames;
        }

        @NotNull
        public final Method copy(@NotNull String className, @NotNull List<String> methodsNames) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter(methodsNames, (String)"methodsNames");
            return new Method(className, methodsNames);
        }

        public static /* synthetic */ Method copy$default(Method method, String string, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = method.className;
            }
            if ((n & 2) != 0) {
                list2 = method.methodsNames;
            }
            return method.copy(string, list2);
        }

        @NotNull
        public String toString() {
            return "Method(className=" + this.className + ", methodsNames=" + this.methodsNames + ")";
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = result * 31 + ((Object)this.methodsNames).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Method)) {
                return false;
            }
            Method method = (Method)other;
            if (!Intrinsics.areEqual((Object)this.className, (Object)method.className)) {
                return false;
            }
            return Intrinsics.areEqual(this.methodsNames, method.methodsNames);
        }
    }
}

