/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class BadHostnameVerifierDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(BadHostnameVerifierDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("BadHostnameVerifier", "Insecure HostnameVerifier", "This check looks for implementations of `HostnameVerifier` whose `verify` method always returns true (thus trusting any hostname) which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://goo.gle/BadHostnameVerifier");

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("javax.net.ssl.HostnameVerifier");
    }

    @Override
    public void visitClass(JavaContext context2, UClass declaration) {
        JavaEvaluator evaluator = context2.getEvaluator();
        for (PsiMethod method : declaration.findMethodsByName("verify", false)) {
            if (!evaluator.methodMatches(method, null, false, "java.lang.String", "javax.net.ssl.SSLSession")) continue;
            ComplexVisitor visitor2 = new ComplexVisitor(context2);
            declaration.accept((UastVisitor)visitor2);
            if (visitor2.isComplex()) {
                return;
            }
            Location location2 = context2.getNameLocation((PsiElement)method);
            String message2 = String.format("`%1$s` always returns `true`, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames", method.getName());
            context2.report(ISSUE, (PsiElement)method, location2, message2);
            break;
        }
    }

    private static class ComplexVisitor
    extends AbstractUastVisitor {
        private final JavaContext context;
        private boolean complex;

        public ComplexVisitor(JavaContext context2) {
            this.context = context2;
        }

        public boolean visitThrowExpression(UThrowExpression node) {
            this.complex = true;
            return true;
        }

        public boolean visitCallExpression(UCallExpression node) {
            this.complex = true;
            return true;
        }

        public boolean visitReturnExpression(UReturnExpression node) {
            UExpression argument = node.getReturnExpression();
            if (argument != null) {
                this.complex = !UastLiteralUtils.isTrueLiteral((UElement)argument);
            }
            return super.visitReturnExpression(node);
        }

        public boolean isComplex() {
            return this.complex;
        }
    }
}

