/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AppCompatCustomViewDetectorKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UTypeReferenceExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/AppCompatCustomViewDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "android.sdktools.lint-checks"})
public final class AppCompatCustomViewDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"android.view.View");
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        PsiReferenceList extendsList;
        Project project;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Project project2 = project = context2.isGlobalAnalysis() ? context2.getMainProject() : context2.getProject();
        if (!AppCompatCustomViewDetectorKt.dependsOnAppCompat$default(project, false, 1, null)) {
            return;
        }
        PsiClass psiClass = declaration.getJavaPsi().getSuperClass();
        if (psiClass == null) {
            return;
        }
        PsiClass superClass = psiClass;
        if (!AppCompatCustomViewDetector.Companion.hasAppCompatDelegate(context2, superClass)) {
            return;
        }
        PsiElement superTypeNode = null;
        List superTypes = declaration.getUastSuperTypes();
        if (superTypes.size() == 1) {
            superTypeNode = ((UTypeReferenceExpression)superTypes.get(0)).getSourcePsi();
        } else {
            for (UTypeReferenceExpression reference : superTypes) {
                PsiClass superType = context2.getEvaluator().getTypeClass(reference.getType());
                if (!context2.getEvaluator().extendsClass(superType, "android.view.View", false)) continue;
                superTypeNode = reference.getSourcePsi();
                break;
            }
        }
        if (superTypeNode == null && (extendsList = declaration.getExtendsList()) != null) {
            PsiJavaCodeReferenceElement[] elements = extendsList.getReferenceElements();
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"elements");
            if (!(elements.length == 0)) {
                superTypeNode = (PsiElement)elements[0];
            }
        }
        PsiElement psiElement = superTypeNode;
        Location location2 = psiElement != null ? context2.getNameLocation(psiElement) : context2.getNameLocation(declaration);
        String string = superClass.getName();
        if (string == null) {
            return;
        }
        String widgetName = string;
        Object object = AppCompatCustomViewDetector.Companion.findAppCompatDelegate(context2, widgetName);
        if (object == null || (object = object.getQualifiedName()) == null) {
            object = AppCompatCustomViewDetector.Companion.getAppCompatDelegate(widgetName, false);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"findAppCompatDelegate(co\u2026legate(widgetName, false)");
        Object suggested = object;
        String message2 = "This custom view should extend `" + (String)suggested + "` instead";
        String actionLabel = "Extend AppCompat widget instead";
        LintFix fix = superTypeNode != null ? this.fix().name(actionLabel).sharedName(actionLabel).replace().all().with((String)suggested).autoFix().build() : null;
        context2.report(ISSUE, declaration, location2, message2, fix);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(AppCompatCustomViewDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "AppCompatCustomView", "Appcompat Custom Widgets", "\n                In order to support features such as tinting, the appcompat library will \\\n                automatically load special appcompat replacements for the builtin widgets. \\\n                However, this does not work for your own custom views.\n\n                Instead of extending the `android.widget` classes directly, you should \\\n                instead extend one of the delegate classes in \\\n                `androidx.appcompat.widget.AppCompatTextView`.\n                ", implementation, null, category, 4, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/AppCompatCustomViewDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "findAppCompatDelegate", "Lcom/intellij/psi/PsiClass;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "widgetName", "", "getAppCompatDelegate", "androidx", "", "hasAppCompatDelegate", "superClass", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final String getAppCompatDelegate(String widgetName, boolean androidx) {
            String pkg = androidx ? "androidx.appcompat.widget" : "android.support.v7.widget";
            return pkg + ".AppCompat" + widgetName;
        }

        private final PsiClass findAppCompatDelegate(JavaContext context2, String widgetName) {
            JavaEvaluator evaluator = context2.getEvaluator();
            String supportName = this.getAppCompatDelegate(widgetName, false);
            String androidxName = this.getAppCompatDelegate(widgetName, true);
            PsiClass psiClass = evaluator.findClass(supportName);
            if (psiClass == null) {
                psiClass = evaluator.findClass(androidxName);
            }
            return psiClass;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasAppCompatDelegate(JavaContext context2, PsiClass superClass) {
            if (superClass == null) {
                return false;
            }
            String qualifiedName = superClass.getQualifiedName();
            if (qualifiedName == null) return false;
            if (!StringsKt.startsWith$default((String)qualifiedName, (String)"android.widget.", (boolean)false, (int)2, null)) {
                return false;
            }
            String string = qualifiedName;
            switch (string.hashCode()) {
                case -50131582: {
                    if (string.equals("android.widget.ImageButton")) return true;
                    break;
                }
                case 670921973: {
                    if (string.equals("android.widget.ImageView")) return true;
                    break;
                }
                case 1663696930: {
                    if (string.equals("android.widget.RadioButton")) return true;
                    break;
                }
                case -37359416: {
                    if (string.equals("android.widget.MultiAutoCompleteTextView")) return true;
                    break;
                }
                case 172698661: {
                    if (string.equals("android.widget.AutoCompleteTextView")) return true;
                    break;
                }
                case -398359122: {
                    if (string.equals("android.widget.Spinner")) return true;
                    break;
                }
                case -717105648: {
                    if (string.equals("android.widget.SeekBar")) return true;
                    break;
                }
                case 1540240509: {
                    if (string.equals("android.widget.TextView")) return true;
                    break;
                }
                case -214285650: {
                    if (string.equals("android.widget.CheckBox")) return true;
                    break;
                }
                case 1893553035: {
                    if (string.equals("android.widget.RatingBar")) return true;
                    break;
                }
                case -1648779058: {
                    if (string.equals("android.widget.CheckedTextView")) return true;
                    break;
                }
                case 1583615229: {
                    if (string.equals("android.widget.Button")) return true;
                    break;
                }
                case -149114526: {
                    if (!string.equals("android.widget.EditText")) break;
                    return true;
                }
            }
            String string2 = superClass.getName();
            if (string2 == null) {
                return false;
            }
            String widgetName = string2;
            if (this.findAppCompatDelegate(context2, widgetName) == null) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

