/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.ApiClassOwner;
import com.android.tools.lint.checks.ApiParser;
import com.android.tools.lint.checks.PrivateApiClass;
import com.android.tools.lint.checks.PrivateApiParser;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.android.utils.XmlUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Api<C extends ApiClassBase> {
    private final Map<String, C> mClasses;
    private final Map<String, ApiClassOwner<C>> mContainers;
    private final List<ExtensionSdk> mSdks;
    private final Map<Object, Integer> mSdkIndex = new LinkedHashMap<Object, Integer>();
    public static boolean TEST_TWO_BYTE_APIS = false;

    public static Api<ApiClass> parseApi(File apiFile) {
        Api<ApiClass> api2;
        FileInputStream inputStream = new FileInputStream(apiFile);
        try {
            api2 = Api.parseApi(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)inputStream).close();
        return api2;
    }

    public static Api<ApiClass> parseApi(InputStream inputStream) {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            XmlUtils.configureSaxFactory((SAXParserFactory)parserFactory, (boolean)false, (boolean)false);
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)parserFactory);
            ApiParser apiParser = new ApiParser();
            parser.parse(inputStream, (DefaultHandler)apiParser);
            return new Api<ApiClass>(apiParser.getClasses(), apiParser.getContainers(), apiParser.getExtensionSdks());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static Api<PrivateApiClass> parseHiddenApi(URL input) {
        Api<PrivateApiClass> api2;
        block8: {
            InputStream inputStream = input.openStream();
            try {
                PrivateApiParser privateApiParser = new PrivateApiParser();
                privateApiParser.parse(inputStream);
                api2 = new Api<PrivateApiClass>(privateApiParser.getClasses(), privateApiParser.getContainers(), Collections.emptyList());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return api2;
    }

    private Api(Map<String, C> classes, Map<String, ApiClassOwner<C>> containers, List<ExtensionSdk> sdks) {
        int i;
        int next = this.mSdkIndex.size();
        if (TEST_TWO_BYTE_APIS) {
            for (i = 300; i < 500; ++i) {
                this.mSdkIndex.put(i + ":1", next++);
            }
        }
        for (i = 0; i <= 34; ++i) {
            this.mSdkIndex.put(i, next++);
        }
        this.mSdkIndex.put(10000, next);
        this.mClasses = Collections.unmodifiableMap(new MyHashMap<C>(classes));
        this.mContainers = Collections.unmodifiableMap(new MyHashMap<ApiClassOwner<C>>(containers));
        this.mSdks = Collections.unmodifiableList(sdks);
    }

    C getClass(String fqcn) {
        return (C)((ApiClassBase)this.mClasses.get(fqcn));
    }

    Map<String, C> getClasses() {
        return this.mClasses;
    }

    Map<String, ApiClassOwner<C>> getContainers() {
        return this.mContainers;
    }

    public short getSdkIndex(Object sdks) {
        Integer sdkIndex = this.mSdkIndex.get(sdks);
        if (sdkIndex != null) {
            return sdkIndex.shortValue();
        }
        int index2 = this.mSdkIndex.size();
        this.mSdkIndex.put(sdks, index2);
        return (short)index2;
    }

    public List<String> getSdks() {
        ArrayList<String> list2 = new ArrayList<String>();
        for (Object key2 : this.mSdkIndex.keySet()) {
            if (key2 instanceof String || key2 instanceof Integer) {
                list2.add(key2.toString());
                continue;
            }
            throw new RuntimeException(key2.toString());
        }
        return list2;
    }

    public List<ExtensionSdk> getExtensionSdks() {
        return this.mSdks;
    }

    private static class MyHashMap<V>
    extends THashMap<String, V> {
        private static final TObjectHashingStrategy<String> myHashingStrategy = new TObjectHashingStrategy<String>(){

            public int computeHashCode(String str) {
                int h = 0;
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    c = MyHashMap.normalizeSeparator(c);
                    h = 31 * h + c;
                }
                return h;
            }

            public boolean equals(String s1, String s2) {
                if (s1.length() != s2.length()) {
                    return false;
                }
                for (int i = 0; i < s1.length(); ++i) {
                    if (MyHashMap.normalizeSeparator(s1.charAt(i)) == MyHashMap.normalizeSeparator(s2.charAt(i))) continue;
                    return false;
                }
                return true;
            }
        };

        private static char normalizeSeparator(char c) {
            if (c == '/' || c == '$') {
                c = (char)46;
            }
            return c;
        }

        MyHashMap(Map<String, V> data) {
            super(data, myHashingStrategy);
        }
    }
}

