/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.MultiReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.manifest.parser.components.ManifestAppComponentInfo;
import com.android.utils.ILogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class WearComponent
extends AppComponent {
    protected WearComponent(IDevice device2, String appId, ManifestAppComponentInfo info, ILogger logger) {
        super(device2, appId, info, logger);
    }

    protected void setUpAmDebugApp() throws DeployerException {
        DebugCommandReceiver amReceiver = new DebugCommandReceiver();
        this.runShellCommand(String.format("%s '%s'", "am set-debug-app -w", this.appId), amReceiver);
        if (amReceiver.hasException()) {
            throw DeployerException.componentActivationException("Activity Manager failed to set up the app for debugging.");
        }
    }

    protected void setUpDebugSurfaceDebugApp() throws DeployerException {
        CommandResultReceiver surfaceReceiver = new CommandResultReceiver();
        this.runShellCommand(String.format("%s '%s'", "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation set-debug-app --es package", this.appId), surfaceReceiver);
        if (surfaceReceiver.resultCode != 1) {
            this.logger.warning("Warning: Debug Surface failed to set the debug app.", new Object[0]);
        }
    }

    protected void runStartCommand(String command, IShellOutputReceiver receiver, ILogger logger) throws DeployerException {
        logger.info("$ adb shell " + command, new Object[0]);
        CommandResultReceiver resultReceiver = new CommandResultReceiver();
        MultiReceiver multiReceiver = new MultiReceiver(resultReceiver, receiver);
        this.runShellCommand(command, multiReceiver);
        if (resultReceiver.getResultCode() != 1) {
            throw DeployerException.componentActivationException(String.format("Invalid Success code `%d`", resultReceiver.getResultCode()));
        }
    }

    public static class DebugCommandReceiver
    extends MultiLineReceiver {
        @NotNull
        private final Pattern exceptionPattern = Pattern.compile("(Exception)");
        private boolean exceptionStatus = false;

        public boolean hasException() {
            return this.exceptionStatus;
        }

        @Override
        public void processNewLines(@NotNull String[] lines) {
            for (String line : lines) {
                Matcher matcher = this.exceptionPattern.matcher(line);
                if (!matcher.find()) continue;
                this.exceptionStatus = true;
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }

    public static class ShellCommand {
        public static final String GET_WEAR_DEBUG_SURFACE_VERSION = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation version";
        public static final String DEBUG_SURFACE_SET_DEBUG_APP = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation set-debug-app --es package";
        public static final String AM_SET_DEBUG_APP = "am set-debug-app -w";
    }

    public static final class CommandResultReceiver
    extends MultiLineReceiver {
        public static final int SUCCESS_CODE = 1;
        public static final int INVALID_ARGUMENT_CODE = 3;
        private int resultCode = -1;
        @NotNull
        private final Pattern resultCodePattern = Pattern.compile("result=(\\d+)");

        public int getResultCode() {
            return this.resultCode;
        }

        @Override
        public void processNewLines(@NotNull String[] lines) {
            for (String line : lines) {
                Matcher matcher = this.resultCodePattern.matcher(line);
                if (!matcher.find()) continue;
                this.resultCode = Integer.parseInt(matcher.group(1));
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }
}

