/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.PatchGenerator;
import com.android.tools.deployer.PatchSet;
import com.android.tools.deployer.model.Apk;
import com.android.tools.idea.protobuf.ByteString;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchSetGenerator {
    public static final int MAX_PATCHSET_SIZE = 0x2800000;
    private ILogger logger;
    private final WhenNoChanges whenNoChanges;

    public PatchSetGenerator(WhenNoChanges whenNoChanges, ILogger logger) {
        this.logger = logger;
        this.whenNoChanges = whenNoChanges;
    }

    public PatchSet generateFromApks(List<Apk> localApks, List<Apk> remoteApks) {
        HashMap<String, Apk> localApkMap = new HashMap<String, Apk>();
        for (Apk apk : localApks) {
            localApkMap.put(apk.name, apk);
        }
        HashMap<String, Apk> remoteApkMap = new HashMap<String, Apk>();
        for (Apk apk : remoteApks) {
            remoteApkMap.put(apk.name, apk);
        }
        return this.generateFromApkSets(remoteApkMap, localApkMap);
    }

    public PatchSet generateFromApkSets(HashMap<String, Apk> remoteApks, HashMap<String, Apk> localApks) {
        try {
            if (remoteApks.size() != localApks.size()) {
                return PatchSet.INVALID;
            }
            ArrayList<Pair<Apk, Apk>> pairs = new ArrayList<Pair<Apk, Apk>>();
            for (Map.Entry<String, Apk> localApk : localApks.entrySet()) {
                if (!remoteApks.keySet().contains(localApk.getValue().name)) {
                    return PatchSet.INVALID;
                }
                pairs.add((Pair<Apk, Apk>)Pair.of((Object)localApk.getValue(), (Object)remoteApks.get(localApk.getValue().name)));
            }
            return this.generateFromPairs(pairs);
        }
        catch (IOException iOException) {
            return PatchSet.INVALID;
        }
    }

    public PatchSet generateFromPairs(List<Pair<Apk, Apk>> pairs) throws IOException {
        ArrayList<Deploy.PatchInstruction> patches = new ArrayList<Deploy.PatchInstruction>();
        boolean noChanges = true;
        for (Pair<Apk, Apk> pair2 : pairs) {
            Apk localApk = (Apk)pair2.getFirst();
            Apk remoteApk = (Apk)pair2.getSecond();
            if (remoteApk.checksum.equals(localApk.checksum)) continue;
            noChanges = false;
            break;
        }
        if (noChanges && this.whenNoChanges == WhenNoChanges.GENERATE_EMPTY_PATCH) {
            return PatchSet.NO_CHANGES;
        }
        long patchSizes = 0L;
        for (Pair<Apk, Apk> pair3 : pairs) {
            Apk localApk = (Apk)pair3.getFirst();
            Apk remoteApk = (Apk)pair3.getSecond();
            Deploy.PatchInstruction instruction = null;
            if (localApk.checksum.equals(remoteApk.checksum)) {
                instruction = this.generateCleanPatch(remoteApk, localApk);
            } else {
                PatchGenerator.Patch patch = new PatchGenerator(this.logger).generate(remoteApk, localApk);
                switch (patch.status) {
                    case SizeThresholdExceeded: {
                        return PatchSet.SIZE_THRESHOLD_EXCEEDED;
                    }
                    case Ok: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled PatchSet status");
                    }
                }
                instruction = this.buildPatchInstruction(patch.destinationSize, patch.sourcePath, patch.instructions, patch.data);
            }
            if ((patchSizes += (long)(instruction.getInstructions().size() + instruction.getPatches().size())) > 0x2800000L) {
                return PatchSet.SIZE_THRESHOLD_EXCEEDED;
            }
            patches.add(instruction);
        }
        assert (pairs.size() == patches.size());
        return new PatchSet(patches);
    }

    private Deploy.PatchInstruction buildPatchInstruction(long size, String remotePath, ByteBuffer instruction, ByteBuffer data) {
        Deploy.PatchInstruction.Builder patchInstructionBuilder = Deploy.PatchInstruction.newBuilder();
        patchInstructionBuilder.setSrcAbsolutePath(remotePath);
        patchInstructionBuilder.setPatches(ByteString.copyFrom((ByteBuffer)data));
        patchInstructionBuilder.setInstructions(ByteString.copyFrom((ByteBuffer)instruction));
        patchInstructionBuilder.setDstFilesize(size);
        return patchInstructionBuilder.build();
    }

    private Deploy.PatchInstruction generateCleanPatch(Apk remoteApk, Apk localApk) throws IOException {
        Deploy.PatchInstruction.Builder patchInstructionBuilder = Deploy.PatchInstruction.newBuilder();
        PatchGenerator.Patch patch = new PatchGenerator(this.logger).generateCleanPatch(remoteApk, localApk);
        patchInstructionBuilder.setSrcAbsolutePath(patch.sourcePath);
        patchInstructionBuilder.setDstFilesize(patch.destinationSize);
        return patchInstructionBuilder.build();
    }

    public static enum WhenNoChanges {
        GENERATE_PATCH_ANYWAY,
        GENERATE_EMPTY_PATCH;

    }
}

