/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.model.Apk;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentCacheDatabase {
    public static final int DEFAULT_SIZE = 25;
    private final Cache<String, Entry> db;
    File persistFile = null;

    public DeploymentCacheDatabase(int size) {
        this(size, null);
    }

    public DeploymentCacheDatabase(File persistFile) {
        this(25, persistFile);
    }

    public DeploymentCacheDatabase(int size, File persistFile) {
        this.db = CacheBuilder.newBuilder().maximumSize((long)size).build();
        this.persistFile = persistFile;
        if (persistFile == null) {
            return;
        }
        try (ObjectInputStream in2 = new ObjectInputStream(new FileInputStream(persistFile));){
            HashMap entries = (HashMap)in2.readObject();
            for (Map.Entry e : entries.entrySet()) {
                this.db.put((Object)((String)e.getKey()), (Object)((Entry)e.getValue()));
            }
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Entry get(String serial, String appId) {
        String key2 = String.format("%s:%s", serial, appId);
        return (Entry)this.db.getIfPresent((Object)key2);
    }

    public boolean store(String serial, String appId, List<Apk> newInstalledApks, OverlayId overlayId) {
        String key2 = String.format("%s:%s", serial, appId);
        this.db.put((Object)key2, (Object)new Entry(newInstalledApks, overlayId));
        this.writeToFile();
        return true;
    }

    public boolean invalidate(String serial, String appId) {
        String key2 = String.format("%s:%s", serial, appId);
        this.db.invalidate((Object)key2);
        this.writeToFile();
        return true;
    }

    public boolean writeToFile() {
        if (this.persistFile == null) {
            return false;
        }
        if (this.persistFile.exists()) {
            this.persistFile.delete();
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.persistFile));){
            HashMap entries = Maps.newHashMap((Map)this.db.asMap());
            out.writeObject(entries);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static class Entry
    implements Serializable {
        private final List<Apk> apks;
        private final OverlayId oid;

        public List<Apk> getApks() {
            return this.apks;
        }

        public OverlayId getOverlayId() {
            return this.oid;
        }

        public OverlayId.Contents getOverlayContents() {
            return this.oid.getOverlayContents();
        }

        private Entry(List<Apk> apks, OverlayId overlayId) {
            this.apks = apks;
            this.oid = overlayId;
        }
    }
}

