/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.adblib.AdbSession;
import com.android.adblib.tools.AdbLibSessionFactoryKt;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.ChangeType;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployRunnerParameters;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.LoggerReceiver;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DeployerRunner {
    private static final int SUCCESS = 0;
    private static final int ERR_SPECIFIED_DEVICE_NOT_FOUND = 1002;
    private static final int ERR_NO_MATCHING_DEVICE = 1003;
    private static final int ERR_BAD_ARGS = 1004;
    private static final String DEX_DB_PATH = "/tmp/studio_dex.db";
    private static final String DEPLOY_DB_PATH = "/tmp/studio_deploy.db";
    private static final InstallOptions STUDIO_DEFAULTS = InstallOptions.builder().setAllowDebuggable().build();
    private static final InstallOptions MOBILE_INSTALL_DEFAULTS = InstallOptions.builder().setAllowDebuggable().setAllowDowngrade().build();
    private final InstallOptions defaultInstallOptions;
    private final DeploymentCacheDatabase cacheDb;
    private final SqlApkFileDatabase dexDb;
    private final MetricsRecorder metrics;
    private final UIService service;

    public static void main(String[] args) {
        Trace.start();
        Trace.begin("main");
        int errorCode = DeployerRunner.tracedMain(args);
        Trace.end();
        Trace.flush();
        System.exit(errorCode);
    }

    public static int tracedMain(String[] args) {
        DeployerRunner runner = new DeployerRunner(MOBILE_INSTALL_DEFAULTS, new File(DEPLOY_DB_PATH), new File(DEX_DB_PATH), new AlwaysYesService());
        return runner.run(args);
    }

    public DeployerRunner(File deployCacheFile, File databaseFile, UIService service) {
        this(STUDIO_DEFAULTS, deployCacheFile, databaseFile, service);
    }

    private DeployerRunner(InstallOptions defaultInstallOptions, File deployCacheFile, File databaseFile, UIService service) {
        this.defaultInstallOptions = defaultInstallOptions;
        this.cacheDb = new DeploymentCacheDatabase(deployCacheFile);
        this.dexDb = new SqlApkFileDatabase(databaseFile, null);
        this.service = service;
        this.metrics = new MetricsRecorder();
    }

    @VisibleForTesting
    public DeployerRunner(DeploymentCacheDatabase cacheDb, SqlApkFileDatabase dexDb, UIService service) {
        this.defaultInstallOptions = STUDIO_DEFAULTS;
        this.cacheDb = cacheDb;
        this.dexDb = dexDb;
        this.service = service;
        this.metrics = new MetricsRecorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: {install | codeswap | fullswap} [--device=<serial>] [--user=<user id>|all|current] [--adb=<path>] packageName baseApk [splitApk1, splitApk2, ...]");
            return 1004;
        }
        try {
            DeployRunnerParameters parameters = DeployRunnerParameters.parse(args);
            StdLogger logger = new StdLogger(parameters.getLogLevel());
            Map<String, IDevice> devices2 = this.waitForDevices(parameters.getAdbExecutablePath(), parameters.getTargetDevices(), parameters.getJdwpClientSupport(), (ILogger)logger);
            if (devices2.isEmpty()) {
                logger.error(null, "No device connected to ddmlib", new Object[0]);
                int n = 1003;
                return n;
            }
            for (String expectedDevice : parameters.getTargetDevices()) {
                if (devices2.containsKey(expectedDevice)) continue;
                logger.error(null, "Could not find specified device: %s", new Object[]{expectedDevice});
                int n = 1002;
                return n;
            }
            for (IDevice device2 : devices2.values()) {
                int status = this.run(device2, parameters, (ILogger)logger);
                if (status == 0) continue;
                logger.error(null, "Error deploying to device: %s", new Object[]{device2.getName()});
                int n = status;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    public int run(IDevice device2, String[] args, ILogger logger) {
        return this.run(device2, DeployRunnerParameters.parse(args), logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(IDevice device2, DeployRunnerParameters parameters, ILogger logger) {
        EnumSet<ChangeType> optimisticInstallSupport = EnumSet.noneOf(ChangeType.class);
        if (parameters.isOptimisticInstall()) {
            optimisticInstallSupport.add(ChangeType.DEX);
            optimisticInstallSupport.add(ChangeType.NATIVE_LIBRARY);
        }
        this.metrics.getDeployMetrics().clear();
        AdbSession session = AdbLibSessionFactoryKt.createStandaloneSession();
        AdbClient adb = new AdbClient(device2, logger, session);
        AdbInstaller installer = new AdbInstaller(parameters.getInstallersPath(), adb, this.metrics.getDeployMetrics(), logger);
        ExecutorService service = Executors.newFixedThreadPool(5);
        TaskRunner runner = new TaskRunner(service);
        DeployerOption deployerOption = new DeployerOption.Builder().setUseOptimisticSwap(true).setUseOptimisticResourceSwap(true).setUseStructuralRedefinition(true).setUseVariableReinitialization(true).setFastRestartOnSwapFail(false).setOptimisticInstallSupport(optimisticInstallSupport).enableCoroutineDebugger(true).skipPostInstallTasks(parameters.getSkipPostInstallTasks()).useRootPushInstall(parameters.getUseRootPushInstall()).build();
        Deployer deployer = new Deployer(adb, this.cacheDb, this.dexDb, runner, installer, this.service, this.metrics, logger, deployerOption);
        try {
            Deployer.Result deployResult;
            if (parameters.getCommands().contains((Object)DeployRunnerParameters.Command.INSTALL)) {
                InstallOptions.Builder options = this.defaultInstallOptions.toBuilder();
                if (device2.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
                    options.setGrantAllPermissions();
                }
                Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
                if (parameters.isForceFullInstall()) {
                    installMode = Deployer.InstallMode.FULL;
                }
                if (parameters.getTargetUserId() != null) {
                    options.setInstallOnUser(parameters.getTargetUserId());
                }
                deployResult = deployer.install(parameters.getApplicationId(), parameters.getApks(), options.build(), installMode);
            } else if (parameters.getCommands().contains((Object)DeployRunnerParameters.Command.FULLSWAP)) {
                deployResult = deployer.fullSwap(parameters.getApks(), Canceller.NO_OP);
            } else if (parameters.getCommands().contains((Object)DeployRunnerParameters.Command.CODESWAP)) {
                deployResult = deployer.codeSwap(parameters.getApks(), (Map<Integer, ClassRedefiner>)ImmutableMap.of(), Canceller.NO_OP);
            } else {
                throw new RuntimeException("UNKNOWN command");
            }
            runner.run(Canceller.NO_OP);
            if (parameters.getCommands().contains((Object)DeployRunnerParameters.Command.ACTIVATE)) {
                DeployRunnerParameters.Component component = parameters.getComponentToActivate();
                assert (component != null);
                deployResult.app.activateComponent(component.type, component.name, new LoggerReceiver(logger));
            }
        }
        catch (DeployerException e) {
            String commands = parameters.getCommands().stream().map(String::valueOf).map(String::toLowerCase).collect(Collectors.joining(","));
            logger.error((Throwable)e, "Not possible to execute " + commands, new Object[0]);
            logger.warning(e.getDetails(), new Object[0]);
            int n = e.getError().ordinal();
            return n;
        }
        finally {
            service.shutdown();
        }
        return 0;
    }

    public List<DeployMetric> getMetrics() {
        return this.metrics.getDeployMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IDevice> waitForDevices(String adbExecutablePath, final List<String> deviceSerials, boolean jdwpClientSupport, final ILogger logger) {
        try (Trace unused = Trace.begin("waitForDevices()");){
            Map<String, IDevice> map2;
            AndroidDebugBridge.IDeviceChangeListener listener;
            block19: {
                int expectedDevices = deviceSerials.isEmpty() ? 1 : deviceSerials.size();
                final CountDownLatch latch = new CountDownLatch(expectedDevices);
                final ConcurrentHashMap<String, IDevice> devices2 = new ConcurrentHashMap<String, IDevice>();
                listener = new AndroidDebugBridge.IDeviceChangeListener(){

                    @Override
                    public void deviceConnected(IDevice device2) {
                        String serial = device2.getSerialNumber();
                        logger.info("Found device with serial: " + serial, new Object[0]);
                        if (deviceSerials.isEmpty() || deviceSerials.contains(serial)) {
                            devices2.put(serial, device2);
                            latch.countDown();
                        }
                    }

                    @Override
                    public void deviceDisconnected(IDevice device2) {
                    }

                    @Override
                    public void deviceChanged(IDevice device2, int changeMask) {
                    }
                };
                if (jdwpClientSupport) {
                    AndroidDebugBridge.init(AdbInitOptions.DEFAULT);
                } else {
                    AndroidDebugBridge.init(AdbInitOptions.builder().setClientSupportEnabled(false).useJdwpProxyService(false).build());
                }
                AndroidDebugBridge.addDeviceChangeListener(listener);
                AndroidDebugBridge bridge = adbExecutablePath == null ? AndroidDebugBridge.createBridge(5L, TimeUnit.SECONDS) : AndroidDebugBridge.createBridge(adbExecutablePath, true, 5L, TimeUnit.SECONDS);
                if (bridge == null) {
                    logger.error(null, "Could not create debug bridge", new Object[0]);
                    Map<String, IDevice> map3 = Collections.emptyMap();
                    return map3;
                }
                if (!latch.await(30L, TimeUnit.SECONDS)) break block19;
                ConcurrentHashMap<String, IDevice> concurrentHashMap = devices2;
                AndroidDebugBridge.removeDeviceChangeListener(listener);
                return concurrentHashMap;
            }
            try {
                map2 = Collections.emptyMap();
            }
            catch (InterruptedException e) {
                Map<String, IDevice> map4;
                try {
                    map4 = Collections.emptyMap();
                }
                catch (Throwable throwable) {
                    AndroidDebugBridge.removeDeviceChangeListener(listener);
                    throw throwable;
                }
                AndroidDebugBridge.removeDeviceChangeListener(listener);
                if (unused != null) {
                    unused.close();
                }
                return map4;
            }
            AndroidDebugBridge.removeDeviceChangeListener(listener);
            return map2;
        }
    }

    static class AlwaysYesService
    implements UIService {
        AlwaysYesService() {
        }

        @Override
        public boolean prompt(String result) {
            return true;
        }

        @Override
        public void message(String message2) {
        }
    }
}

