/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.FileDiff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ApkDiffer {
    public List<FileDiff> specDiff(DeploymentCacheDatabase.Entry cacheEntry, List<Apk> newApks) throws DeployerException {
        if (cacheEntry == null) {
            throw DeployerException.remoteApkNotFound();
        }
        DiffFunction compare = (oldFile, newFile) -> {
            Optional<FileDiff> normalDiff = ApkDiffer.standardDiff(oldFile, newFile);
            if (normalDiff.isPresent()) {
                return normalDiff;
            }
            boolean inOverlay = cacheEntry.getOverlayContents().containsFile(newFile.getQualifiedPath());
            boolean isResource = newFile.getName().startsWith("res");
            if (!inOverlay && isResource) {
                return Optional.of(new FileDiff(null, newFile, FileDiff.Status.RESOURCE_NOT_IN_OVERLAY));
            }
            return Optional.empty();
        };
        return this.diff(cacheEntry.getApks(), newApks, compare);
    }

    public List<FileDiff> diff(List<Apk> oldApks, List<Apk> newApks) throws DeployerException {
        return this.diff(oldApks, newApks, ApkDiffer::standardDiff);
    }

    public List<FileDiff> diff(List<Apk> oldApks, List<Apk> newApks, DiffFunction compare) throws DeployerException {
        ArrayList<ApkEntry> oldFiles = new ArrayList<ApkEntry>();
        HashMap<String, Map<String, ApkEntry>> oldMap = new HashMap<String, Map<String, ApkEntry>>();
        ApkDiffer.groupFiles(oldApks, oldFiles, oldMap);
        ArrayList<ApkEntry> newFiles = new ArrayList<ApkEntry>();
        HashMap<String, Map<String, ApkEntry>> newMap2 = new HashMap<String, Map<String, ApkEntry>>();
        ApkDiffer.groupFiles(newApks, newFiles, newMap2);
        if (newMap2.size() != oldMap.size()) {
            throw DeployerException.apkCountMismatch();
        }
        if (!newMap2.keySet().equals(oldMap.keySet())) {
            throw DeployerException.apkNameMismatch();
        }
        ArrayList<FileDiff> diffs = new ArrayList<FileDiff>();
        for (ApkEntry newFile : newFiles) {
            ApkEntry oldFile = (ApkEntry)((Map)oldMap.get(newFile.getApk().name)).get(newFile.getName());
            compare.diff(oldFile, newFile).ifPresent(diffs::add);
        }
        for (ApkEntry oldFile : oldFiles) {
            ApkEntry newFile = (ApkEntry)((Map)newMap2.get(oldFile.getApk().name)).get(oldFile.getName());
            if (newFile != null) continue;
            compare.diff(oldFile, null).ifPresent(diffs::add);
        }
        return diffs;
    }

    private static void groupFiles(List<Apk> apks, List<ApkEntry> entries, Map<String, Map<String, ApkEntry>> map2) {
        for (Apk apk : apks) {
            map2.putIfAbsent(apk.name, apk.apkEntries);
            entries.addAll(apk.apkEntries.values());
        }
    }

    private static Optional<FileDiff> standardDiff(ApkEntry oldFile, ApkEntry newFile) {
        FileDiff.Status status = null;
        if (oldFile == null) {
            status = FileDiff.Status.CREATED;
        } else if (newFile == null) {
            status = FileDiff.Status.DELETED;
        } else if (oldFile.getChecksum() != newFile.getChecksum()) {
            status = FileDiff.Status.MODIFIED;
        }
        if (status != null) {
            return Optional.of(new FileDiff(oldFile, newFile, status));
        }
        return Optional.empty();
    }

    @FunctionalInterface
    private static interface DiffFunction {
        public Optional<FileDiff> diff(ApkEntry var1, ApkEntry var2);
    }
}

