/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.model.Apk;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;

public class ApkChecker {
    private final String deploySessionId;
    private final ILogger logger;

    ApkChecker(String deploySessionId, ILogger logger) {
        this.deploySessionId = deploySessionId;
        this.logger = logger;
    }

    boolean log(List<Apk> apks) {
        for (Apk apk : apks) {
            String fingerprint = apk.checksum;
            Path path2 = Paths.get(apk.path, new String[0]);
            String size = "INVALID_SIZE";
            String creationTime = "NOT_AVAILABLE";
            String lastModifiedTime = "NOT_AVAILABLE";
            String lastAccessTime = "NOT_AVAILABLE";
            try {
                BasicFileAttributes attr = Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
                long length = attr.size();
                size = String.valueOf(length);
                creationTime = attr.creationTime().toString();
                lastModifiedTime = attr.lastModifiedTime().toString();
                lastAccessTime = attr.lastAccessTime().toString();
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, "Unable to perform APKChecker logging on file %s", new Object[]{path2.toString()});
            }
            this.logger.info("Deploy APK Check session='%s', path='%s', size='%s', fingerprint='%s', crTime='%s', modTime='%s', acTime='%s'", new Object[]{this.deploySessionId, apk.path, size, fingerprint, creationTime, lastModifiedTime, lastAccessTime});
        }
        return true;
    }
}

