/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.idea.protobuf.CodedInputStream;
import com.android.tools.idea.protobuf.CodedOutputStream;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

class AdbInstallerChannel
implements AutoCloseable {
    private static final byte[] MAGIC_NUMBER = new byte[]{-84, -91, -84, -91, -84, -91, -84, -91};
    private final SocketChannel channel;
    private final Selector readSelector;
    private final SelectionKey readKey;
    private final Selector writeSelector;
    private final SelectionKey writeKey;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ILogger logger;
    private static final long PER_WRITE_TIME_OUT = TimeUnit.SECONDS.toMillis(5L);

    AdbInstallerChannel(SocketChannel c, ILogger logger) throws IOException {
        this.channel = c;
        this.channel.configureBlocking(false);
        this.readSelector = Selector.open();
        this.readKey = this.channel.register(this.readSelector, 1);
        this.writeSelector = Selector.open();
        this.writeKey = this.channel.register(this.writeSelector, 4);
        this.logger = logger;
    }

    private void read(ByteBuffer buffer2, long timeOutMs) throws IOException {
        this.checkLock();
        long deadline = System.currentTimeMillis() + timeOutMs;
        while (buffer2.remaining() != 0) {
            long timeout = Math.max(0L, deadline - System.currentTimeMillis());
            this.readSelector.select(timeout);
            int read2 = this.channel.read(buffer2);
            if (read2 == 0 || System.currentTimeMillis() >= deadline) {
                this.close();
                String template = "InstallerChannel.select: Timeout on read after %dms";
                String msg = String.format(Locale.US, template, timeOutMs);
                throw new IOException(msg);
            }
            if (read2 != -1) continue;
            break;
        }
        buffer2.rewind();
    }

    private void write(ByteBuffer buffer2, long timeOutMs) throws IOException, TimeoutException {
        this.checkLock();
        long deadline = System.currentTimeMillis() + timeOutMs;
        while (buffer2.remaining() != 0) {
            if (System.currentTimeMillis() >= deadline) {
                throw new TimeoutException("InstallerChannel write timeout");
            }
            long timeout = Math.min(PER_WRITE_TIME_OUT, deadline - System.currentTimeMillis());
            timeout = Math.max(0L, timeout);
            this.writeSelector.select(timeout);
            int written = this.channel.write(buffer2);
            if (written != 0) continue;
            throw new TimeoutException("InstallerChannel write timeout");
        }
    }

    @Override
    public void close() throws IOException {
        try (SocketChannel c = this.channel;
             Selector r = this.readSelector;){
            Selector w = this.writeSelector;
            if (w != null) {
                w.close();
            }
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void checkLock() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Channel lock must be acquired before read/write");
        }
    }

    boolean writeRequest(Deploy.InstallerRequest request, long timeOutMs) throws TimeoutException {
        ByteBuffer bytes = this.wrap(request);
        try {
            this.write(bytes, timeOutMs);
        }
        catch (IOException | ClosedSelectorException e) {
            return false;
        }
        return bytes.remaining() == 0;
    }

    Deploy.InstallerResponse readResponse(long timeOutMs) {
        try {
            ByteBuffer bufferMarker = ByteBuffer.allocate(MAGIC_NUMBER.length);
            this.read(bufferMarker, timeOutMs);
            if (!Arrays.equals(MAGIC_NUMBER, bufferMarker.array())) {
                String garbage = new String(bufferMarker.array(), Charsets.UTF_8);
                this.logger.info("Read '" + garbage + "' from socket", new Object[0]);
                return null;
            }
            ByteBuffer bufferSize = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            this.read(bufferSize, timeOutMs);
            int responseSize = bufferSize.getInt();
            if (responseSize < 0) {
                return null;
            }
            ByteBuffer bufferPayload = ByteBuffer.allocate(responseSize);
            this.read(bufferPayload, timeOutMs);
            return this.unwrap(bufferPayload);
        }
        catch (IOException e) {
            this.logger.warning("Error while reading InstallerChannel", new Object[0]);
            return null;
        }
    }

    private Deploy.InstallerResponse unwrap(ByteBuffer buffer2) {
        buffer2.rewind();
        try {
            CodedInputStream cis = CodedInputStream.newInstance((ByteBuffer)buffer2);
            return (Deploy.InstallerResponse)Deploy.InstallerResponse.parser().parseFrom(cis);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ByteBuffer wrap(Deploy.InstallerRequest message2) {
        int messageSize = message2.getSerializedSize();
        int headerSize = MAGIC_NUMBER.length + 4;
        byte[] buffer2 = new byte[headerSize + messageSize];
        ByteBuffer headerWriter = ByteBuffer.wrap(buffer2).order(ByteOrder.LITTLE_ENDIAN);
        headerWriter.put(MAGIC_NUMBER);
        headerWriter.putInt(messageSize);
        try {
            CodedOutputStream cos = CodedOutputStream.newInstance((byte[])buffer2, (int)headerSize, (int)messageSize);
            message2.writeTo(cos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return ByteBuffer.wrap(buffer2);
    }

    boolean isClosed() {
        return !this.channel.isOpen();
    }
}

