/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstallerChannel;
import com.android.tools.deployer.AdbInstallerChannelManager;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.Sites;
import com.android.tools.deployer.Timeouts;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.concurrent.TimeoutException;

public class AdbInstaller
extends Installer {
    public static final String INSTALLER_BINARY_NAME = Sites.installerBinary();
    public static final String INSTALLER_PATH = Sites.installerPath();
    public static final String ANDROID_EXECUTABLE_PATH = "/tools/base/deploy/installer/android-installer";
    private final AdbClient adb;
    private final String installersFolder;
    private final Collection<DeployMetric> metrics;
    private final AdbInstallerChannelManager channelsProvider;
    private final Mode mode;

    public AdbInstaller(String installersFolder, AdbClient adb, Collection<DeployMetric> metrics, ILogger logger) {
        this(installersFolder, adb, metrics, logger, Mode.ONE_SHOT);
    }

    public AdbInstaller(String installersFolder, AdbClient adb, Collection<DeployMetric> metrics, ILogger logger, Mode mode) {
        super(logger);
        this.adb = adb;
        this.installersFolder = installersFolder;
        this.metrics = metrics;
        this.channelsProvider = new AdbInstallerChannelManager(logger, mode);
        this.mode = mode;
    }

    private void logEvents(List<Deploy.Event> events) {
        for (Deploy.Event event : events) {
            if (event.getType() == Deploy.Event.Type.TRC_END) continue;
            this.logger.info(event.getTimestampNs() / 1000000L + "ms " + event.getType() + " [" + event.getPid() + "][" + event.getTid() + "] : " + event.getText(), new Object[0]);
        }
    }

    private void traceEvents(Deploy.InstallerResponse response, long start2, long end2) {
        long maxNs = Long.MIN_VALUE;
        long minNs = Long.MAX_VALUE;
        for (Deploy.Event event : response.getEventsList()) {
            maxNs = Math.max(maxNs, event.getTimestampNs());
            minNs = Math.min(minNs, event.getTimestampNs());
        }
        long delta = (maxNs + minNs - (end2 + start2)) / 2L;
        Stack<Deploy.Event> eventStack = new Stack<Deploy.Event>();
        for (Deploy.Event event : response.getEventsList()) {
            switch (event.getType()) {
                case TRC_BEG: 
                case TRC_METRIC: {
                    Trace.begin(event.getPid(), event.getTid(), event.getTimestampNs() - delta, event.getText());
                    eventStack.push(event);
                    break;
                }
                case TRC_END: {
                    Deploy.Event begin;
                    Trace.end(event.getPid(), event.getTid(), event.getTimestampNs() - delta);
                    if (eventStack.empty() || (begin = (Deploy.Event)eventStack.pop()).getType() != Deploy.Event.Type.TRC_METRIC) break;
                    long startMs = begin.getTimestampNs() - delta;
                    long endMs = event.getTimestampNs() - delta;
                    this.metrics.add(new DeployMetric(begin.getText(), startMs, endMs));
                    break;
                }
            }
        }
    }

    @Override
    protected Deploy.InstallerResponse sendInstallerRequest(Deploy.InstallerRequest request, long timeOutMs) throws IOException {
        try (Trace ignore = Trace.begin("./installer " + request.getCommandName());){
            long start2 = System.nanoTime();
            Deploy.InstallerResponse response = this.sendInstallerRequest(request, OnFail.RETRY, timeOutMs);
            long end2 = System.nanoTime();
            this.logEvents(response.getEventsList());
            this.traceEvents(response, start2, end2);
            Deploy.InstallerResponse installerResponse = response;
            return installerResponse;
        }
    }

    private Deploy.InstallerResponse sendInstallerRequest(Deploy.InstallerRequest request, OnFail onFail, long timeOutMs) throws IOException {
        Deploy.InstallerResponse response = null;
        AdbInstallerChannel channel = this.channelsProvider.getChannel(this.adb, this.getVersion());
        channel.lock();
        try {
            if (channel.writeRequest(request, timeOutMs)) {
                response = channel.readResponse(timeOutMs);
            }
        }
        catch (TimeoutException e) {
            String msg = String.format("Device '%s' timed out", this.adb.getName());
            throw new IOException(msg);
        }
        finally {
            channel.unlock();
        }
        if (response == null) {
            if (onFail == OnFail.DO_NO_RETRY) {
                throw new IOException("Invalid installer response");
            }
            this.channelsProvider.reset(this.adb);
            this.prepare();
            return this.sendInstallerRequest(request, OnFail.DO_NO_RETRY, timeOutMs);
        }
        if (response.getStatus() == Deploy.InstallerResponse.Status.ERROR_WRONG_VERSION) {
            if (onFail == OnFail.DO_NO_RETRY) {
                throw new IOException("Unrecoverable installer WRONG_VERSION error. Aborting");
            }
            this.channelsProvider.reset(this.adb);
            this.prepare();
            return this.sendInstallerRequest(request, OnFail.DO_NO_RETRY, timeOutMs);
        }
        Deploy.InstallerResponse.Status status = response.getStatus();
        if (status != Deploy.InstallerResponse.Status.OK) {
            int statusNumber = status.getNumber();
            String errorMsg = response.getErrorMessage();
            String msg = String.format(Locale.US, "Bad InstallerResponse msg='%s', status=%d", errorMsg, statusNumber);
            throw new IOException(msg);
        }
        if (this.mode == Mode.ONE_SHOT) {
            this.channelsProvider.reset(this.adb);
        }
        return response;
    }

    private void prepare() throws IOException {
        File installerFile = null;
        List<String> abis = this.adb.getAbis();
        for (String abi : abis) {
            String installerJarPath = abi + "/" + INSTALLER_BINARY_NAME;
            InputStream inputStream = this.getResource(installerJarPath);
            try {
                if (inputStream == null) continue;
                this.logger.info("Pushed installer '" + installerJarPath + "'", new Object[0]);
                installerFile = File.createTempFile(".studio_installer", abi);
                Files.copy(inputStream, Paths.get(installerFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                break;
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (installerFile == null) {
            throw new IOException("Unsupported abis: " + Arrays.toString(abis.toArray()));
        }
        try {
            this.cleanAndPushInstaller(installerFile);
        }
        catch (IOException io) {
            this.runShell(new String[]{"su", "root", "chown", "-R", "shell:shell", Deployer.BASE_DIRECTORY}, Timeouts.SHELL_CHOWN);
            this.cleanAndPushInstaller(installerFile);
        }
        installerFile.delete();
    }

    private void cleanAndPushInstaller(File installerFile) throws IOException {
        this.runShell(new String[]{"rm", "-fr", Deployer.INSTALLER_DIRECTORY, Deployer.INSTALLER_TMP_DIRECTORY}, Timeouts.SHELL_RMFR);
        this.runShell(new String[]{"mkdir", "-p", Deployer.INSTALLER_DIRECTORY, Deployer.INSTALLER_TMP_DIRECTORY}, Timeouts.SHELL_MKDIR);
        this.runShell(new String[]{"chmod", "-R", "775", Deployer.BASE_DIRECTORY}, Timeouts.SHELL_CHMOD);
        this.runShell(new String[]{"chown", "-R", "shell:shell", Deployer.BASE_DIRECTORY}, Timeouts.SHELL_CHOWN);
        this.adb.push(installerFile.getAbsolutePath(), INSTALLER_PATH);
        this.runShell(new String[]{"chmod", "+x", INSTALLER_PATH}, Timeouts.SHELL_CHMOD);
    }

    private void runShell(String[] cmd, long timeOutMs) throws IOException {
        byte[] response = this.adb.shell(cmd, timeOutMs);
        if (response.length <= 0) {
            return;
        }
        String extraMsg = new String(response, Charsets.UTF_8).trim();
        String error = String.format("Cannot '%s' : '%s'", String.join((CharSequence)" ", cmd), extraMsg);
        this.logger.error(null, error, new Object[0]);
        throw new IOException(error);
    }

    private InputStream getResource(String path2) throws FileNotFoundException {
        InputStream stream = this.installersFolder == null ? Installer.class.getResourceAsStream("/tools/base/deploy/installer/android-installer/" + path2) : new FileInputStream(this.installersFolder + "/" + path2);
        return stream;
    }

    @Override
    protected void onAsymetry(Deploy.InstallerRequest req, Deploy.InstallerResponse resp) throws IOException {
        try {
            this.channelsProvider.reset(this.adb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum Mode {
        DAEMON,
        ONE_SHOT;

    }

    private static enum OnFail {
        RETRY,
        DO_NO_RETRY;

    }
}

