/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.HashCodes;
import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicResourceItemBase
implements BasicResourceItem,
ResourceValue {
    @NotNull
    private final String myName;
    private final byte myTypeOrdinal;
    private final byte myVisibilityOrdinal;

    BasicResourceItemBase(@NotNull ResourceType type2, @NotNull String name, @NotNull ResourceVisibility visibility) {
        this.myName = name;
        this.myTypeOrdinal = (byte)type2.ordinal();
        this.myVisibilityOrdinal = (byte)visibility.ordinal();
    }

    @NotNull
    public final ResourceType getType() {
        return this.getResourceType();
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.getRepository().getNamespace();
    }

    @NotNull
    public final String getName() {
        return this.myName;
    }

    @Nullable
    public final String getLibraryName() {
        return this.getRepository().getLibraryName();
    }

    @NotNull
    public final ResourceType getResourceType() {
        return ResourceType.values()[this.myTypeOrdinal];
    }

    @NotNull
    public final ResourceVisibility getVisibility() {
        return ResourceVisibility.values()[this.myVisibilityOrdinal];
    }

    @NotNull
    public final ResourceReference getReferenceToSelf() {
        return this.asReference();
    }

    @NotNull
    public final ResourceValue getResourceValue() {
        return this;
    }

    public final boolean isUserDefined() {
        return this.getRepository().containsUserDefinedResources();
    }

    public final boolean isFramework() {
        return this.getNamespace().equals((Object)ResourceNamespace.ANDROID);
    }

    @NotNull
    public final ResourceReference asReference() {
        return new ResourceReference(this.getNamespace(), this.getResourceType(), this.myName);
    }

    @NotNull
    public final LoadableResourceRepository getRepository() {
        return this.getRepositoryConfiguration().getRepository();
    }

    @NotNull
    public final FolderConfiguration getConfiguration() {
        return this.getRepositoryConfiguration().getFolderConfiguration();
    }

    @NotNull
    public abstract RepositoryConfiguration getRepositoryConfiguration();

    @NotNull
    public final String getKey() {
        String qualifiers = this.getConfiguration().getQualifierString();
        if (!qualifiers.isEmpty()) {
            return this.getType().getName() + '-' + qualifiers + '/' + this.getName();
        }
        return this.getType().getName() + '/' + this.getName();
    }

    public final void setValue(@Nullable String value) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicResourceItemBase other = (BasicResourceItemBase)obj;
        return this.myTypeOrdinal == other.myTypeOrdinal && this.myName.equals(other.myName) && this.myVisibilityOrdinal == other.myVisibilityOrdinal;
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myTypeOrdinal, (int)this.myName.hashCode());
    }

    @NotNull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.getResourceType()).add("name", (Object)this.getName()).add("value", (Object)this.getValue()).toString();
    }

    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        stream.writeInt((this.myTypeOrdinal << 1) + (this.isFileBased() ? 1 : 0));
        stream.writeString(this.myName);
        stream.writeInt((int)this.myVisibilityOrdinal);
    }

    @NotNull
    public static BasicResourceItemBase deserialize(@NotNull Base128InputStream stream, @NotNull List<RepositoryConfiguration> configurations, @NotNull List<ResourceSourceFile> sourceFiles, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        assert (!configurations.isEmpty());
        int encodedType = stream.readInt();
        boolean isFileBased = (encodedType & 1) != 0;
        ResourceType resourceType = ResourceType.values()[encodedType >>> 1];
        String name = stream.readString();
        if (name == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        ResourceVisibility visibility = ResourceVisibility.values()[stream.readInt()];
        if (isFileBased) {
            LoadableResourceRepository repository2 = configurations.get(0).getRepository();
            return repository2.deserializeFileResourceItem(stream, resourceType, name, visibility, configurations);
        }
        return BasicValueResourceItemBase.deserialize(stream, resourceType, name, visibility, configurations, sourceFiles, namespaceResolvers);
    }
}

