/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.aapt.Resources;
import com.android.utils.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ProtoStyledStringDecoder {
    @NotNull
    public static String getRawXmlValue(@NotNull Resources.StyledString styledStringMsg) {
        String text = styledStringMsg.getValue();
        StringBuilder xmlValue = new StringBuilder(text.length() * 2);
        List spanList = styledStringMsg.getSpanList();
        ArrayList<Resources.StyledString.Span> spanStack = new ArrayList<Resources.StyledString.Span>(spanList.size());
        int offset = 0;
        for (int i = 0; i <= styledStringMsg.getSpanCount(); ++i) {
            String tagText;
            int pos;
            Resources.StyledString.Span spanMsg;
            int oldOffset = offset;
            if (i < styledStringMsg.getSpanCount()) {
                spanMsg = styledStringMsg.getSpan(i);
                offset = spanMsg.getFirstChar();
            } else {
                spanMsg = null;
                offset = text.length();
            }
            while (!spanStack.isEmpty() && ((Resources.StyledString.Span)spanStack.get(spanStack.size() - 1)).getLastChar() < offset) {
                Resources.StyledString.Span span = (Resources.StyledString.Span)spanStack.remove(spanStack.size() - 1);
                int spanEnd = span.getLastChar() + 1;
                if (spanEnd > oldOffset) {
                    XmlUtils.appendXmlTextValue((StringBuilder)xmlValue, (String)text, (int)oldOffset, (int)spanEnd);
                    oldOffset = spanEnd;
                }
                String tagText2 = span.getTag();
                int tagEnd = ProtoStyledStringDecoder.indexOfOrEnd(tagText2, ';', 0);
                xmlValue.append("</").append(tagText2, 0, tagEnd).append('>');
            }
            if (offset < oldOffset) continue;
            XmlUtils.appendXmlTextValue((StringBuilder)xmlValue, (String)text, (int)oldOffset, (int)offset);
            if (spanMsg == null || (pos = ProtoStyledStringDecoder.indexOfOrEnd(tagText = spanMsg.getTag(), ';', 0)) == 0) continue;
            spanStack.add(spanMsg);
            xmlValue.append('<').append(tagText, 0, pos);
            while (pos < tagText.length()) {
                int nextPos = ProtoStyledStringDecoder.indexOfOrEnd(tagText, ';', ++pos);
                int nameEnd = tagText.indexOf(61, pos);
                if (nameEnd > pos && nameEnd < nextPos) {
                    xmlValue.append(' ');
                    xmlValue.append(tagText, pos, nameEnd + 1);
                    xmlValue.append('\"');
                    XmlUtils.appendXmlAttributeValue((StringBuilder)xmlValue, (String)tagText, (int)(nameEnd + 1), (int)nextPos);
                    xmlValue.append('\"');
                }
                pos = nextPos;
            }
            xmlValue.append('>');
        }
        return xmlValue.toString();
    }

    private static int indexOfOrEnd(@NotNull String str, char ch, int fromIndex) {
        int index2 = str.indexOf(ch, fromIndex);
        return index2 >= 0 ? index2 : str.length();
    }

    private ProtoStyledStringDecoder() {
    }
}

