/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.threadreference.FramesReply;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.JsonLocation;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class CmdSetThreadReference
extends CmdSet {
    protected CmdSetThreadReference() {
        super(11, "THREAD_REF");
        this.add(1, "Name");
        this.add(2, "Suspend");
        this.add(3, "Resume");
        this.add(4, "Status");
        this.add(5, "ThreadGroup");
        this.add(6, "Frames", CmdSetThreadReference::parseFramesCmd, CmdSetThreadReference::parseFramesReply);
        this.add(7, "FrameCount");
        this.add(8, "OwnerMonitors");
        this.add(9, "CurrentContendedMonitor");
        this.add(10, "Stop");
        this.add(11, "Interrupt");
        this.add(12, "SuspendCount");
        this.add(13, "OwnerMonitorStackDepthInfo");
        this.add(14, "ForceEarlyReturn");
    }

    private static Message parseFramesCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        long threadID = reader.getThreadID();
        int startFrame = reader.getInt();
        int length = reader.getInt();
        message2.addArg("threadID", threadID);
        message2.addArg("startFrame", startFrame);
        message2.addArg("length", length);
        return message2;
    }

    private static Message parseFramesReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        FramesReply frames = FramesReply.parse(reader);
        JsonArray framesArray = new JsonArray();
        for (FramesReply.Frame frame : frames.getFrames()) {
            JsonObject jsonFrame = new JsonObject();
            jsonFrame.addProperty("frameID", (Number)frame.getId());
            jsonFrame.add("location", (JsonElement)JsonLocation.get(frame.getLocation()));
            framesArray.add((JsonElement)jsonFrame);
        }
        message2.addArg("frames", (JsonElement)framesArray);
        return message2;
    }
}

