/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.SourceFileCmd;
import com.android.jdwppacket.SourceFileReply;
import com.android.jdwppacket.referencetype.MethodsCmd;
import com.android.jdwppacket.referencetype.MethodsReply;
import com.android.jdwppacket.referencetype.MethodsWithGenericsCmd;
import com.android.jdwppacket.referencetype.MethodsWithGenericsReply;
import com.android.jdwppacket.referencetype.SignatureCmd;
import com.android.jdwppacket.referencetype.SignatureReply;
import com.android.jdwppacket.referencetype.SignatureWithGenericCmd;
import com.android.jdwppacket.referencetype.SignatureWithGenericReply;
import com.android.jdwppacket.referencetype.SourceDebugExtensionCmd;
import com.android.jdwppacket.referencetype.SourceDebugExtensionReply;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class CmdSetReferenceType
extends CmdSet {
    protected CmdSetReferenceType() {
        super(2, "REF_TYPE");
        this.add(1, "Signature", CmdSetReferenceType::parseSignatureCmd, CmdSetReferenceType::parseSignatureReply);
        this.add(2, "Classloader");
        this.add(3, "Modifiers");
        this.add(4, "Fields");
        this.add(5, "Methods", CmdSetReferenceType::parseMethodsCmd, CmdSetReferenceType::parseMethodsReply);
        this.add(6, "GetValues");
        this.add(7, "SourceFile", CmdSetReferenceType::parseSourceFileCmd, CmdSetReferenceType::parseSourceFileReply);
        this.add(8, "NestedTypes");
        this.add(9, "Status");
        this.add(10, "Interfaces");
        this.add(11, "ClassObject");
        this.add(12, "SourceDebugExtension", CmdSetReferenceType::parseSourceDebugExtensionCmd, CmdSetReferenceType::parseSourceDebugExtensionReply);
        this.add(13, "SignatureWithGenerics", CmdSetReferenceType::parseSignatureWithGenericCmd, CmdSetReferenceType::parseSignatureWithGenericReply);
        this.add(14, "FieldWithGenerics");
        this.add(15, "MethodWithGenerics", CmdSetReferenceType::parseMethodsWithGenericsCmd, CmdSetReferenceType::parseMethodsWithGenericsReply);
        this.add(16, "Instances");
        this.add(17, "ClassFileVersion");
        this.add(18, "ConstantPool");
    }

    private static Message parseSignatureCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        SignatureCmd cmd = SignatureCmd.parse(reader);
        message2.addArg("refType", cmd.getRefType());
        return message2;
    }

    private static Message parseSignatureReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        SignatureReply reply = SignatureReply.parse(reader);
        message2.addArg("signature", reply.getSignature());
        return message2;
    }

    private static Message parseSourceDebugExtensionCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        SourceDebugExtensionCmd cmd = SourceDebugExtensionCmd.parse(reader);
        message2.addArg("refType", cmd.getRefType());
        return message2;
    }

    private static Message parseSourceDebugExtensionReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        SourceDebugExtensionReply reply = SourceDebugExtensionReply.parse(reader);
        message2.addArg("extension", reply.getExtension());
        return message2;
    }

    private static Message parseSignatureWithGenericCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        SignatureWithGenericCmd cmd = SignatureWithGenericCmd.parse(reader);
        message2.addArg("refType", cmd.getRefType());
        return message2;
    }

    private static Message parseSignatureWithGenericReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        SignatureWithGenericReply reply = SignatureWithGenericReply.parse(reader);
        message2.addArg("signature", reply.getSignature());
        message2.addArg("genericSignature", reply.getGenericSignature());
        return message2;
    }

    private static Message parseMethodsCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        MethodsCmd cmd = MethodsCmd.parse(reader);
        message2.addArg("refType", cmd.getRefType());
        return message2;
    }

    private static Message parseMethodsReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        MethodsReply reply = MethodsReply.parse(reader);
        message2.addArg("declared", reply.getMethods().size());
        JsonArray methods = new JsonArray();
        for (MethodsReply.Method method : reply.getMethods()) {
            JsonObject methodJson = new JsonObject();
            methodJson.addProperty("methodID", (Number)method.getMethodID());
            methodJson.addProperty("name", method.getName());
            methodJson.addProperty("signature", method.getSignature());
            methodJson.addProperty("modBits", (Number)method.getModBits());
            methods.add((JsonElement)methodJson);
        }
        message2.addArg("methods", (JsonElement)methods);
        return message2;
    }

    private static Message parseMethodsWithGenericsCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        MethodsWithGenericsCmd cmd = MethodsWithGenericsCmd.parse(reader);
        message2.addArg("refType", cmd.getRefType());
        return message2;
    }

    private static Message parseMethodsWithGenericsReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        MethodsWithGenericsReply reply = MethodsWithGenericsReply.parse(reader);
        message2.addArg("declared", reply.getMethods().size());
        JsonArray methods = new JsonArray();
        for (MethodsWithGenericsReply.Method method : reply.getMethods()) {
            JsonObject methodJson = new JsonObject();
            methodJson.addProperty("methodID", (Number)method.getMethodID());
            methodJson.addProperty("name", method.getName());
            methodJson.addProperty("signature", method.getSignature());
            methodJson.addProperty("genericSignature", method.getGenericSignature());
            methodJson.addProperty("modBits", (Number)method.getModBits());
            methods.add((JsonElement)methodJson);
        }
        message2.addArg("methods", (JsonElement)methods);
        return message2;
    }

    private static Message parseSourceFileCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        SourceFileCmd cmd = SourceFileCmd.parse(reader);
        message2.addArg("refType", cmd.getRefType());
        return message2;
    }

    private static Message parseSourceFileReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        SourceFileReply reply = SourceFileReply.parse(reader);
        message2.addArg("sourceFile", reply.getSourceFile());
        return message2;
    }
}

