/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwppacket;

import com.android.jdwppacket.CmdSet;
import com.android.jdwppacket.MessageReader;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/android/jdwppacket/PacketHeader;", "", "reader", "Lcom/android/jdwppacket/MessageReader;", "(Lcom/android/jdwppacket/MessageReader;)V", "cmd", "", "getCmd", "()I", "cmdSet", "getCmdSet", "error", "", "getError", "()S", "flags", "", "getFlags", "()B", "id", "getId", "length", "", "getLength", "()J", "isCmd", "", "isReply", "toString", "", "Companion", "android.sdktools.jdwppacket"})
public final class PacketHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long length;
    private final int id;
    private final byte flags;
    private final int cmd;
    private final int cmdSet;
    private final short error;
    private static final int HEADER_SIZE = 11;
    private static final int REPLY_BIT = 128;

    public PacketHeader(@NotNull MessageReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.remaining() < HEADER_SIZE) {
            throw new IllegalStateException("Not enough byte to parse PacketHeader");
        }
        this.length = (long)UInt.constructor-impl((int)reader.getInt()) & 0xFFFFFFFFL;
        this.id = reader.getInt();
        this.flags = reader.getByte();
        if (this.isReply()) {
            this.error = reader.getShort();
            this.cmdSet = CmdSet.NoSet.getId();
            this.cmd = 0;
        } else {
            this.error = 0;
            this.cmdSet = UByte.constructor-impl((byte)reader.getByte()) & 0xFF;
            this.cmd = UByte.constructor-impl((byte)reader.getByte()) & 0xFF;
        }
    }

    public final long getLength() {
        return this.length;
    }

    public final int getId() {
        return this.id;
    }

    public final byte getFlags() {
        return this.flags;
    }

    public final int getCmd() {
        return this.cmd;
    }

    public final int getCmdSet() {
        return this.cmdSet;
    }

    public final short getError() {
        return this.error;
    }

    @NotNull
    public String toString() {
        if (this.isReply()) {
            return "reply(0x" + Integer.toHexString(this.id) + ')';
        }
        return "cmd(0x" + Integer.toHexString(this.id) + ") " + this.cmdSet + '-' + this.cmd;
    }

    public final boolean isReply() {
        return (this.flags & REPLY_BIT) == REPLY_BIT;
    }

    public final boolean isCmd() {
        return !this.isReply();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/jdwppacket/PacketHeader$Companion;", "", "()V", "HEADER_SIZE", "", "REPLY_BIT", "getREPLY_BIT$android_sdktools_jdwppacket", "()I", "android.sdktools.jdwppacket"})
    public static final class Companion {
        private Companion() {
        }

        public final int getREPLY_BIT$android_sdktools_jdwppacket() {
            return REPLY_BIT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

