/*
 * Decompiled with CFR 0.152.
 */
package com.android.incfs.install;

import com.android.incfs.install.IBlockTransformer;
import com.android.incfs.install.IDeviceConnection;
import com.android.incfs.install.ILogger;
import com.android.incfs.install.PendingBlock;
import com.android.incfs.install.ReadRequest;
import com.android.incfs.install.StreamingApk;
import com.google.common.base.Charsets;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

class IncrementalInstallSessionImpl
implements AutoCloseable {
    private static final int FULL_REQUEST_SIZE = 12;
    private static final int REQUEST_SIZE = 8;
    private static final byte RESPONSE_CHUNK_HEADER_SIZE = 4;
    private static final int RESPONSE_HEADER_SIZE = 10;
    private static final int DONT_WAIT_TIME_MS = 0;
    private static final int WAIT_TIME_MS = 10;
    private final IDeviceConnection mConnection;
    private final IBlockTransformer mTransformer;
    private final ILogger mLogger;
    private final List<StreamingApk> mApks;
    private final long mResponseTimeoutNs;
    private volatile Exception mPendingException;
    private volatile boolean mInstallSucceeded;
    private volatile boolean mStreamingCompleted;
    private volatile boolean mClosed;

    IncrementalInstallSessionImpl(IDeviceConnection device2, List<StreamingApk> apks, long responseTimeout, IBlockTransformer transformer, ILogger logger) {
        this.mConnection = device2;
        this.mApks = apks;
        this.mResponseTimeoutNs = responseTimeout;
        this.mTransformer = transformer;
        this.mLogger = logger;
    }

    void waitForInstallCompleted(long timeout, TimeUnit timeOutUnits) throws IOException, InterruptedException {
        this.waitForCondition(timeOutUnits.toNanos(timeout), 10L, () -> {
            if (this.mPendingException != null) {
                throw new RuntimeException(this.mPendingException);
            }
            return this.mInstallSucceeded || this.mClosed ? ConditionResult.FULFILLED : ConditionResult.UNFULFILLED;
        });
    }

    void waitForServingCompleted(long timeout, TimeUnit timeOutUnits) throws IOException, InterruptedException {
        this.waitForCondition(timeOutUnits.toNanos(timeout), 10L, () -> {
            if (this.mPendingException != null) {
                throw new RuntimeException(this.mPendingException);
            }
            return this.mStreamingCompleted || this.mClosed ? ConditionResult.FULFILLED : ConditionResult.UNFULFILLED;
        });
    }

    void waitForAnyCompletion(long timeout, TimeUnit timeOutUnits) throws IOException, InterruptedException {
        this.waitForCondition(timeOutUnits.toNanos(timeout), 10L, () -> {
            if (this.mPendingException != null) {
                throw new RuntimeException(this.mPendingException);
            }
            return this.mInstallSucceeded || this.mStreamingCompleted || this.mClosed ? ConditionResult.FULFILLED : ConditionResult.UNFULFILLED;
        });
    }

    private void waitForCondition(long timeoutNs, long waitMs, IOSupplier<ConditionResult> condition) throws IOException, InterruptedException {
        long startNs = System.nanoTime();
        while (timeoutNs == 0L || startNs + timeoutNs >= System.nanoTime()) {
            ConditionResult result = condition.get();
            if (result == ConditionResult.FULFILLED) {
                return;
            }
            if (waitMs > 0L) {
                Thread.sleep(waitMs);
            }
            if (result != ConditionResult.RESET_TIMEOUT) continue;
            startNs = System.nanoTime();
        }
        throw new IOException("timeout while waiting for condition");
    }

    @Override
    public void close() {
        if (this.mClosed) {
            return;
        }
        if (!this.mStreamingCompleted) {
            try {
                this.writeToDevice(IncrementalInstallSessionImpl.buildCloseResponseChunk());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mApks.forEach(StreamingApk::close);
        this.mClosed = true;
    }

    void execute(Executor executor) {
        executor.execute(() -> {
            try {
                this.writeToDevice(ByteBuffer.wrap("OKAY".getBytes(Charsets.UTF_8)));
                this.processDeviceData();
            }
            catch (Exception e) {
                this.mPendingException = e;
            }
        });
    }

    private void processDeviceData() throws IOException, InterruptedException {
        ByteBuffer buffer2 = ByteBuffer.allocate(16384);
        buffer2.flip();
        MagicMatcher magicMatcher = new MagicMatcher();
        StringBuilder errorBuilder = new StringBuilder();
        this.waitForCondition(this.mResponseTimeoutNs, 0L, () -> {
            MagicMatcher.MagicType magic;
            if (this.mClosed) {
                return ConditionResult.FULFILLED;
            }
            if (buffer2.remaining() < 12) {
                buffer2.compact();
                int count = this.mConnection.read(buffer2, 10L);
                buffer2.flip();
                if (count < 0) {
                    throw new EOFException("EOF");
                }
            }
            if ((magic = magicMatcher.findMagic(buffer2)) == null) {
                return ConditionResult.UNFULFILLED;
            }
            switch (magic) {
                case INCREMENTAL: {
                    if (buffer2.remaining() < 8) break;
                    if (this.processReadData(IncrementalInstallSessionImpl.nextRequest(buffer2))) {
                        this.mStreamingCompleted = true;
                    }
                    magicMatcher.advance();
                    break;
                }
                case INSTALLATION_FAILURE: {
                    while (buffer2.hasRemaining()) {
                        byte c = buffer2.get();
                        if (c == 93) {
                            throw new IOException("Installation failure: " + errorBuilder.toString());
                        }
                        errorBuilder.append((char)c);
                    }
                    break;
                }
                case INSTALLATION_SUCCESS: {
                    this.mInstallSucceeded = true;
                    magicMatcher.advance();
                }
            }
            return this.mStreamingCompleted && this.mInstallSucceeded ? ConditionResult.FULFILLED : ConditionResult.RESET_TIMEOUT;
        });
    }

    private static ReadRequest nextRequest(ByteBuffer data) {
        ReadRequest.RequestType type2;
        short typeData = data.getShort();
        switch (typeData) {
            case 0: {
                type2 = ReadRequest.RequestType.SERVING_COMPLETE;
                break;
            }
            case 1: {
                type2 = ReadRequest.RequestType.BLOCK_MISSING;
                break;
            }
            case 2: {
                type2 = ReadRequest.RequestType.PREFETCH;
                break;
            }
            case 3: {
                type2 = ReadRequest.RequestType.DESTROY;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown request type " + typeData);
            }
        }
        return new ReadRequest(type2, data.getShort(), data.getInt());
    }

    private boolean processReadData(ReadRequest request) throws IOException, InterruptedException {
        this.mLogger.verbose("Received %s", request.toString());
        switch (request.requestType) {
            case SERVING_COMPLETE: {
                return true;
            }
            case BLOCK_MISSING: 
            case PREFETCH: {
                StreamingApk apk = this.mApks.get(request.apkId);
                List<PendingBlock> responses = apk.getBlockResponse(request.blockIndex);
                this.writeToDevice(this.buildResponseChunk(request.apkId, responses));
                break;
            }
            case DESTROY: {
                throw new IOException("Destroy request received");
            }
        }
        return false;
    }

    private static ByteBuffer buildCloseResponseChunk() {
        ByteBuffer buffer2 = ByteBuffer.allocate(14);
        buffer2.putInt(10);
        buffer2.putShort((short)-1);
        buffer2.put((byte)0);
        buffer2.put((byte)0);
        buffer2.putInt(0);
        buffer2.putShort((short)0);
        buffer2.flip();
        return buffer2;
    }

    private ByteBuffer buildResponseChunk(short apkId, List<PendingBlock> blocks) throws IOException {
        if (blocks.isEmpty()) {
            return ByteBuffer.allocate(0);
        }
        boolean BLOCK_KIND_DATA = false;
        boolean BLOCK_KIND_HASH = true;
        boolean COMPRESSION_KIND_NONE = false;
        boolean COMPRESSION_KIND_LZ4 = true;
        int maxSize = 4 + 4106 * blocks.size();
        ByteBuffer buffer2 = ByteBuffer.allocate(maxSize);
        buffer2.position(4);
        int totalSize = 0;
        for (PendingBlock block : blocks) {
            block = this.mTransformer.transform(block);
            buffer2.putShort(apkId);
            buffer2.put(block.getType() == PendingBlock.Type.APK_DATA ? (byte)0 : 1);
            buffer2.put(block.getCompression() == PendingBlock.Compression.NONE ? (byte)0 : 1);
            buffer2.putInt(block.getBlockIndex());
            buffer2.putShort(block.getBlockSize());
            block.readBlockData(buffer2);
            totalSize += 10 + block.getBlockSize();
        }
        buffer2.putInt(0, totalSize);
        buffer2.flip();
        return buffer2;
    }

    private void writeToDevice(ByteBuffer data) throws IOException, InterruptedException {
        this.waitForCondition(this.mResponseTimeoutNs, 0L, () -> {
            if (!data.hasRemaining()) {
                return ConditionResult.FULFILLED;
            }
            if (this.mConnection.write(data, 10L) < 0) {
                throw new IOException("channel EOF");
            }
            return ConditionResult.UNFULFILLED;
        });
    }

    private static interface IOSupplier<T> {
        public T get() throws IOException, InterruptedException;
    }

    private static enum ConditionResult {
        FULFILLED,
        UNFULFILLED,
        RESET_TIMEOUT;

    }

    private static class MagicMatcher {
        private static final ArrayList<Magic> MAGICS = new ArrayList();
        private final int[] mPositions = new int[MAGICS.size()];
        private MagicType mFoundMatch = null;

        private MagicMatcher() {
        }

        MagicType findMagic(ByteBuffer buffer2) {
            if (this.mFoundMatch != null) {
                return this.mFoundMatch;
            }
            while (buffer2.hasRemaining()) {
                byte nextByte = buffer2.get();
                for (int i = 0; i < this.mPositions.length; ++i) {
                    byte[] magic = MagicMatcher.MAGICS.get((int)i).value;
                    if (nextByte == magic[this.mPositions[i]]) {
                        int n = i;
                        this.mPositions[n] = this.mPositions[n] + 1;
                        if (this.mPositions[n] != magic.length) continue;
                        this.mFoundMatch = MagicMatcher.MAGICS.get((int)i).type;
                        this.mPositions[i] = 0;
                        return this.mFoundMatch;
                    }
                    this.mPositions[i] = nextByte == magic[0] ? 1 : 0;
                }
            }
            return null;
        }

        void advance() {
            this.mFoundMatch = null;
        }

        static {
            MAGICS.add(new Magic(MagicType.INCREMENTAL, "INCR".getBytes(Charsets.UTF_8)));
            MAGICS.add(new Magic(MagicType.INSTALLATION_FAILURE, "Failure [".getBytes(Charsets.UTF_8)));
            MAGICS.add(new Magic(MagicType.INSTALLATION_SUCCESS, "Success".getBytes(Charsets.UTF_8)));
        }

        private static enum MagicType {
            INCREMENTAL,
            INSTALLATION_FAILURE,
            INSTALLATION_SUCCESS;

        }

        private static class Magic {
            final MagicType type;
            final byte[] value;

            Magic(MagicType type2, byte[] value) {
                this.type = type2;
                this.value = value;
            }
        }
    }
}

