/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.jdwp;

import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import com.android.ddmlib.jdwp.JdwpInterceptor;
import com.android.ddmlib.jdwp.JdwpPipe;
import com.android.ddmlib.jdwp.packets.CapabilitiesNewReply;
import com.android.ddmlib.jdwp.packets.IdSizesReply;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;

public class JdwpProtocol {
    private IdSizesReply mIdSizes;

    public long readObjectId(ByteBuffer buffer2) {
        assert (this.mIdSizes != null);
        return this.readId(buffer2, this.mIdSizes.objectIDSize);
    }

    public long readRefTypeId(ByteBuffer buffer2) {
        assert (this.mIdSizes != null);
        return this.readId(buffer2, this.mIdSizes.refTypeIDSize);
    }

    public long readMethodId(ByteBuffer buffer2) {
        assert (this.mIdSizes != null);
        return this.readId(buffer2, this.mIdSizes.methodIDSize);
    }

    public long readFieldId(ByteBuffer buffer2) {
        assert (this.mIdSizes != null);
        return this.readId(buffer2, this.mIdSizes.fieldIDSize);
    }

    private long readId(ByteBuffer buffer2, int size) {
        switch (size) {
            case 1: {
                return buffer2.get();
            }
            case 2: {
                return buffer2.getShort();
            }
            case 4: {
                return buffer2.getInt();
            }
            case 8: {
                return buffer2.getLong();
            }
        }
        throw new IllegalArgumentException("Unsupported Id size: " + size);
    }

    public String readString(ByteBuffer buffer2) {
        int len = buffer2.getInt();
        byte[] utf8 = new byte[len];
        buffer2.get(utf8);
        return new String(utf8, Charsets.UTF_8);
    }

    public void incoming(JdwpPacket packet, JdwpPipe pipe) {
        if (packet.is(1, 7)) {
            pipe.addReplyInterceptor(packet.getId(), new JdwpInterceptor(){

                @Override
                public JdwpPacket intercept(JdwpPipe pipe, JdwpPacket packet) {
                    JdwpProtocol.this.mIdSizes = new IdSizesReply();
                    JdwpProtocol.this.mIdSizes.parse(packet.getPayload(), JdwpProtocol.this);
                    return packet;
                }
            });
        } else if (packet.is(1, 17)) {
            pipe.addReplyInterceptor(packet.getId(), new JdwpInterceptor(){

                @Override
                public JdwpPacket intercept(JdwpPipe pipe, JdwpPacket packet) {
                    CapabilitiesNewReply reply = new CapabilitiesNewReply();
                    reply.parse(packet.getPayload(), JdwpProtocol.this);
                    packet.setPayload(reply.getConverted());
                    return packet;
                }
            });
        }
    }
}

