/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.jdwp.JdwpClientManagerFactory;
import com.android.ddmlib.internal.jdwp.JdwpProxyClient;
import com.android.ddmlib.internal.jdwp.JdwpSocketHandler;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class JdwpProxyServer
implements Runnable {
    private static final long THROTTLE_TIMEOUT_MS = 1000L;
    private static final long JOIN_TIMEOUT_MS = 5000L;
    private final int mListenPort;
    private final ConnectionState mConnectionStateChangedCallback;
    private final Object myChannelLock = new Object();
    private ServerSocketChannel mListenChannel;
    private SocketChannel mFallbackChannel;
    private boolean mQuit = false;
    private Selector mSelector;
    private JdwpClientManagerFactory mFactory;
    private boolean mIsRunningAsServer = false;
    private InetSocketAddress mServerAddress;
    private long mLastAttemptTime;
    private Thread myRunThread;

    public JdwpProxyServer(int listenPort, ConnectionState callback2) {
        this.mListenPort = listenPort;
        this.mConnectionStateChangedCallback = callback2;
    }

    public void start() throws IOException {
        this.mServerAddress = new InetSocketAddress(InetAddress.getByName("localhost"), this.mListenPort);
        try {
            this.startAsServer();
        }
        catch (BindException ex) {
            this.startAsClient();
        }
        this.myRunThread = new Thread((Runnable)this, "JdwpProxyConnection");
        this.myRunThread.start();
    }

    @VisibleForTesting
    boolean IsRunningAsServer() {
        return this.mIsRunningAsServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean IsConnectedOrListening() {
        Object object = this.myChannelLock;
        synchronized (object) {
            return this.mListenChannel != null && this.mListenChannel.socket().isBound() || this.mFallbackChannel != null && this.mFallbackChannel.isConnected();
        }
    }

    @VisibleForTesting
    JdwpClientManagerFactory getFactory() {
        return this.mFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAsServer() throws IOException {
        Object object = this.myChannelLock;
        synchronized (object) {
            this.mListenChannel = ServerSocketChannel.open();
            this.mSelector = Selector.open();
            this.mFactory = new JdwpClientManagerFactory(this.mSelector);
            this.mListenChannel.socket().setReuseAddress(true);
            this.mListenChannel.socket().bind(this.mServerAddress);
            this.mListenChannel.configureBlocking(false);
            this.mListenChannel.register(this.mSelector, 16, this);
            this.mIsRunningAsServer = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getBindPort() {
        Object object = this.myChannelLock;
        synchronized (object) {
            assert (this.mListenChannel != null);
            return this.mListenChannel.socket().getLocalPort();
        }
    }

    private void startAsClient() {
        this.mIsRunningAsServer = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.mQuit = true;
        if (this.mSelector != null) {
            this.mSelector.wakeup();
        }
        Object object = this.myChannelLock;
        synchronized (object) {
            if (this.mFallbackChannel != null) {
                try {
                    this.mFallbackChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            if (this.mSelector != null) {
                if (!this.mSelector.keys().isEmpty()) {
                    for (SelectionKey key2 : this.mSelector.keys()) {
                        if (!(key2.attachment() instanceof JdwpSocketHandler)) continue;
                        ((JdwpSocketHandler)key2.attachment()).shutdown();
                    }
                }
                this.mSelector.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.myRunThread != null) {
            try {
                this.myRunThread.join(5000L);
                if (this.myRunThread.isAlive()) {
                    Log.e("ddms", "Run thread still alive after 5000ms");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = this.myChannelLock;
        synchronized (object) {
            if (this.mListenChannel != null) {
                try {
                    this.mListenChannel.close();
                    this.mListenChannel.socket().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.mSelector = null;
        object = this.myChannelLock;
        synchronized (object) {
            this.mListenChannel = null;
            this.mFallbackChannel = null;
        }
        this.myRunThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsFallbackServer() throws IOException, InterruptedException {
        try {
            SocketChannel chan;
            if (System.currentTimeMillis() - this.mLastAttemptTime < 1000L) {
                Thread.sleep(1000L);
            }
            this.mLastAttemptTime = System.currentTimeMillis();
            Object object = this.myChannelLock;
            synchronized (object) {
                if (this.mQuit) {
                    return;
                }
                if (this.mFallbackChannel == null) {
                    this.mFallbackChannel = SocketChannel.open(this.mServerAddress);
                }
                chan = this.mFallbackChannel;
            }
            ByteBuffer buffer2 = ByteBuffer.allocate(1);
            chan.read(buffer2);
            this.retryAsServer();
        }
        catch (IOException ex) {
            this.retryAsServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryAsServer() throws IOException {
        if (this.mQuit) {
            return;
        }
        Object object = this.myChannelLock;
        synchronized (object) {
            if (this.mFallbackChannel != null) {
                this.mFallbackChannel.close();
                this.mFallbackChannel = null;
            }
        }
        if (this.mSelector != null) {
            this.mSelector.close();
            this.mSelector = null;
        }
        if (!this.mQuit) {
            this.startAsServer();
            this.mConnectionStateChangedCallback.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsServer() throws IOException {
        int count = this.mSelector.select();
        if (count == 0) {
            return;
        }
        Set<SelectionKey> keys = this.mSelector.selectedKeys();
        Iterator<SelectionKey> iter = keys.iterator();
        while (iter.hasNext()) {
            SelectionKey key2 = iter.next();
            iter.remove();
            try {
                if (key2.isAcceptable()) {
                    Object object = this.myChannelLock;
                    synchronized (object) {
                        SocketChannel client = this.mListenChannel.accept();
                        client.configureBlocking(false);
                        client.register(this.mSelector, 1, new JdwpProxyClient(client, this.mFactory));
                        continue;
                    }
                }
                if (key2.attachment() instanceof JdwpSocketHandler) {
                    JdwpSocketHandler handler = (JdwpSocketHandler)key2.attachment();
                    try {
                        handler.read();
                    }
                    catch (TimeoutException | IOException | BufferOverflowException ex) {
                        handler.shutdown();
                    }
                    continue;
                }
                Log.e("ddms", "unknown activity key");
            }
            catch (Exception e) {
                Log.e("ddms", "Exception during activity from Selector.");
                Log.e("ddms", e);
            }
        }
    }

    @Override
    public void run() {
        while (!this.mQuit) {
            try {
                if (this.mIsRunningAsServer) {
                    this.runAsServer();
                    continue;
                }
                this.runAsFallbackServer();
            }
            catch (Exception ex) {
                Log.e("JdwpProxyServer", ex);
            }
        }
    }

    public static interface ConnectionState {
        public void changed();
    }
}

