/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing.api;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringTokenizer;

public interface DeviceConfig {
    public Optional<String> getValue(Category var1);

    public List<String> getAbis();

    public String getConfigForAllAbis();

    public String getConfigFor(String var1);

    public static class Builder {
        public static DeviceConfig parse(Collection<String> lines) {
            ImmutableList.Builder valuesBuilder = ImmutableList.builder();
            for (String line : lines) {
                for (Category category : Category.values()) {
                    String key2 = category.name().toLowerCase(Locale.US) + ": ";
                    if (!line.startsWith(key2)) continue;
                    valuesBuilder.add((Object)new Values(category, line.substring(key2.length())));
                }
            }
            final ImmutableList values = valuesBuilder.build();
            return new DeviceConfig(){

                @Override
                public Optional<String> getValue(Category category) {
                    for (Values value : values) {
                        if (!value.myCategory.equals((Object)category)) continue;
                        return Optional.of(value.value);
                    }
                    return Optional.empty();
                }

                @Override
                public List<String> getAbis() {
                    ImmutableList.Builder abiBuilder = ImmutableList.builder();
                    Optional<String> abis = this.getValue(Category.ABI);
                    if (abis.isPresent()) {
                        StringTokenizer stringTokenizer = new StringTokenizer(abis.get(), ",");
                        while (stringTokenizer.hasMoreElements()) {
                            abiBuilder.add((Object)stringTokenizer.nextToken());
                        }
                    }
                    return abiBuilder.build();
                }

                @Override
                public String getConfigForAllAbis() {
                    StringBuilder completeConfig = new StringBuilder();
                    Optional<String> config = this.getValue(Category.CONFIG);
                    List<String> abis = this.getAbis();
                    if (abis.isEmpty() && config.isPresent()) {
                        completeConfig.append(config.get());
                    } else {
                        if (config.isPresent()) {
                            completeConfig.append(config.get());
                            completeConfig.append(":");
                        }
                        Joiner.on((String)",").appendTo(completeConfig, abis);
                    }
                    return completeConfig.toString();
                }

                @Override
                public String getConfigFor(String abi) {
                    StringBuilder completeConfig = new StringBuilder();
                    Optional<String> config = this.getValue(Category.CONFIG);
                    if (config.isPresent()) {
                        completeConfig.append(config.get());
                        if (!Strings.isNullOrEmpty((String)abi)) {
                            completeConfig.append(":");
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)abi)) {
                        completeConfig.append(abi);
                    }
                    return completeConfig.toString();
                }
            };
        }

        private static class Values {
            private final Category myCategory;
            private final String value;

            private Values(Category category, String value) {
                this.myCategory = category;
                this.value = value;
            }
        }
    }

    public static enum Category {
        CONFIG,
        ABI;

    }
}

