/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/adblib/utils/JdkLoggerFactory;", "Lcom/android/adblib/AdbLoggerFactory;", "()V", "logger", "Lcom/android/adblib/AdbLogger;", "getLogger", "()Lcom/android/adblib/AdbLogger;", "createLogger", "cls", "Ljava/lang/Class;", "category", "", "JdkLogger", "android.sdktools.adblib"})
public final class JdkLoggerFactory
implements AdbLoggerFactory {
    @NotNull
    private final AdbLogger logger = new JdkLogger("com.android.adblib");

    @Override
    @NotNull
    public AdbLogger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public AdbLogger createLogger(@NotNull Class<?> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        String string = cls.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cls::class.java.name");
        return new JdkLogger(string);
    }

    @Override
    @NotNull
    public AdbLogger createLogger(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return new JdkLogger(category);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/android/adblib/utils/JdkLoggerFactory$JdkLogger;", "Lcom/android/adblib/AdbLogger;", "name", "", "(Ljava/lang/String;)V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "minLevel", "Lcom/android/adblib/AdbLogger$Level;", "getMinLevel", "()Lcom/android/adblib/AdbLogger$Level;", "log", "", "level", "message", "exception", "", "mapLevel", "Ljava/util/logging/Level;", "android.sdktools.adblib"})
    public static final class JdkLogger
    extends AdbLogger {
        @NotNull
        private final Logger logger;

        public JdkLogger(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Logger logger = Logger.getLogger(name);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(name)");
            this.logger = logger;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @Override
        @NotNull
        public AdbLogger.Level getMinLevel() {
            return this.logger.isLoggable(Level.ALL) ? AdbLogger.Level.VERBOSE : (this.logger.isLoggable(Level.FINE) ? AdbLogger.Level.DEBUG : (this.logger.isLoggable(Level.INFO) ? AdbLogger.Level.INFO : (this.logger.isLoggable(Level.WARNING) ? AdbLogger.Level.WARN : AdbLogger.Level.ERROR)));
        }

        @Override
        public void log(@NotNull AdbLogger.Level level, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.logger.log(this.mapLevel(level), message2);
        }

        @Override
        public void log(@NotNull AdbLogger.Level level, @Nullable Throwable exception, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.logger.log(this.mapLevel(level), exception, new Supplier(message2){
                final /* synthetic */ String $message;
                {
                    this.$message = $message;
                }

                public final String get() {
                    return this.$message;
                }
            });
        }

        private final Level mapLevel(AdbLogger.Level level) {
            Level level2;
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    Level level3 = Level.ALL;
                    level2 = level3;
                    Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"ALL");
                    break;
                }
                case 2: {
                    Level level4 = Level.FINE;
                    level2 = level4;
                    Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"FINE");
                    break;
                }
                case 3: {
                    Level level5 = Level.INFO;
                    level2 = level5;
                    Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"INFO");
                    break;
                }
                case 4: {
                    Level level6 = Level.WARNING;
                    level2 = level6;
                    Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"WARNING");
                    break;
                }
                case 5: {
                    Level level7 = Level.SEVERE;
                    level2 = level7;
                    Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"SEVERE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return level2;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AdbLogger.Level.values().length];
                try {
                    nArray[AdbLogger.Level.VERBOSE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AdbLogger.Level.DEBUG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AdbLogger.Level.INFO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AdbLogger.Level.WARN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AdbLogger.Level.ERROR.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

